/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixItHint;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyIntentionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OpenClangTidySettingsAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyAnnotationApplier {
    public void applyFail(@NotNull PsiFile file2, @NotNull String reason, HighlightSeverity severity, @NotNull AnnotationHolder holder) {
        String message = OCInspectionsBundle.message("inspection.clangTidy.failed", new Object[0]) + " " + reason;
        holder.newAnnotation(severity, message).range((PsiElement)file2).fileLevel().withFix((IntentionAction)new OpenClangTidySettingsAction()).create();
    }

    private static void applySuccess(@NotNull PsiFile file2, @NotNull List<ClangTidyDiagnostic> diagnostics2, boolean isBatchMode, @NotNull DiagnosticProcessor diagnosticProcessor) {
        OCFile ocFile = OCLanguageUtils.asOCFile(file2);
        if (ocFile == null) {
            return;
        }
        for (ClangTidyDiagnostic diagnostic : diagnostics2) {
            OCPragma.Mode mode;
            ClangTidyInspectionBase sourceInspection;
            ProgressManager.checkCanceled();
            PsiElement elementToAnnotate = ClangTidyAnnotationApplier.getElementToAnnotate(file2, diagnostic.getFileOffset());
            if (elementToAnnotate == null || (sourceInspection = ClangTidyUtil.findInspectionFromClangTidyDiagnostic(diagnostic, file2, file2.getProject())) == null) continue;
            TextRange rangeToHighlight = ClangTidyAnnotationApplier.getRangeToHighlight(elementToAnnotate);
            String diagnosticMessage = sourceInspection.getMessage(diagnostic.getMessage(), isBatchMode);
            List<ClangTidyReplacement> replacements = diagnostic.getReplacements();
            ClionFixItHint clionFix = diagnostic.getClionFix();
            String diagnosticName = diagnostic.getDiagnosticName();
            HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(((Object)((Object)sourceInspection)).getClass(), (PsiElement)file2, HighlightSeverity.WARNING);
            if (highlightSeverity == null || (mode = OCPragmaSuppressionUtils.getDiagnosticMode(ocFile, rangeToHighlight.getStartOffset(), sourceInspection.getSuppressName(diagnosticName))) == OCPragma.Mode.IGNORE) continue;
            List<IntentionAction> fixesToRegister = clionFix != null ? ClangQuickFixFactoryKt.getClangQuickFixes(clionFix, OCResolveContext.forPsi((PsiElement)file2), (PsiElement)file2) : Collections.singletonList(replacements.isEmpty() ? new EmptyIntentionAction(sourceInspection.getDisplayName()) : new ClangTidyIntentionAction(diagnosticMessage, diagnosticName, replacements));
            for (IntentionAction fix : fixesToRegister) {
                if (!diagnosticProcessor.processDiagnostic(diagnosticMessage, diagnosticName, rangeToHighlight, highlightSeverity, sourceInspection, ocFile, fix)) break;
            }
        }
    }

    public void applySuccess(final @NotNull PsiFile file2, @NotNull Document document2, @NotNull List<ClangTidyDiagnostic> diagnostics2, final @NotNull AnnotationHolder holder) {
        ClangTidyAnnotationApplier.applySuccess(file2, diagnostics2, holder.isBatchMode(), new DiagnosticProcessor(){

            @Override
            public boolean processDiagnostic(@NotNull String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull OCFile ocFile, @NotNull IntentionAction fixToRegister) {
                AnnotationBuilder builder2 = holder.newAnnotation(highlightSeverity, diagnosticMessage).range(rangeToHighlight).withFix((IntentionAction)new IntentionWrapper(fixToRegister, file2)).problemGroup((ProblemGroup)ClangTidyAnnotationApplier.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection));
                if (sourceInspection.getForcedHighlightType() != null) {
                    builder2 = builder2.highlightType(sourceInspection.getForcedHighlightType());
                }
                builder2.create();
                return true;
            }
        });
    }

    public void applySuccess(final @NotNull PsiFile file2, @NotNull List<ClangTidyDiagnostic> diagnostics2, final @NotNull ProblemsHolder holder) {
        ClangTidyAnnotationApplier.applySuccess(file2, diagnostics2, !holder.isOnTheFly(), new DiagnosticProcessor(){

            @Override
            public boolean processDiagnostic(@NotNull String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull OCFile ocFile, @NotNull IntentionAction fixToRegister) {
                PsiElement startElement = file2.findElementAt(rangeToHighlight.getStartOffset());
                PsiElement endElement = file2.findElementAt(rangeToHighlight.getEndOffset() - 1);
                if (startElement == null || endElement == null) {
                    return false;
                }
                IntentionWrapper localQuickFix = new IntentionWrapper(fixToRegister, file2);
                ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)file2.getProject()).createProblemDescriptor(startElement, endElement, diagnosticMessage, sourceInspection.getForcedHighlightType() == null ? HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)highlightSeverity) : sourceInspection.getForcedHighlightType(), holder.isOnTheFly(), new LocalQuickFix[]{localQuickFix});
                problemDescriptor.setProblemGroup((ProblemGroup)ClangTidyAnnotationApplier.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection));
                holder.registerProblem(problemDescriptor);
                return true;
            }
        });
    }

    public void applySuccess(final @NotNull PsiFile file2, @NotNull List<ClangTidyDiagnostic> diagnostics2, final @NotNull HighlightInfoHolder holder, boolean isBatch) {
        ClangTidyAnnotationApplier.applySuccess(file2, diagnostics2, isBatch, new DiagnosticProcessor(){

            @Override
            public boolean processDiagnostic(@NotNull String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull OCFile ocFile, @NotNull IntentionAction fixToRegister) {
                ProblemHighlightType problemHighlightType = sourceInspection.getForcedHighlightType() == null ? HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)highlightSeverity) : sourceInspection.getForcedHighlightType();
                HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)problemHighlightType, (HighlightSeverity)highlightSeverity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)file2.getProject()));
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(rangeToHighlight).descriptionAndTooltip(diagnosticMessage).severity(highlightSeverity).problemGroup((ProblemGroup)ClangTidyAnnotationApplier.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection)).create();
                holder.add(info);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fixToRegister);
                return true;
            }
        });
    }

    @NotNull
    private static ClangTidyProblemGroup createProblemGroup(@NotNull OCFile file2, @NotNull TextRange highlightRange, @NotNull String checkName, @NotNull ClangTidyInspectionBase inspection) {
        boolean canDisable = inspection.canBeDisabledByClangTidyCheckName(file2.getVirtualFile(), file2.getProject());
        return new ClangTidyProblemGroup(file2, highlightRange, checkName, canDisable, inspection.getShortName());
    }

    @Nullable
    private static PsiElement getElementToAnnotate(@NotNull PsiFile file2, int offset) {
        PsiElement element;
        PsiElement psiElement = element = file2.getTextLength() > offset ? file2.findElementAt(offset) : file2.getLastChild();
        if (element instanceof PsiComment) {
            return element;
        }
        if (!OCElementUtil.isElementSignificant(element)) {
            element = OCElementUtil.getPrevSignificantSibling(element);
        }
        if (element == null) {
            return null;
        }
        if (ClangTidyAnnotationApplier.isMakeSenseToHighlight(element.getNode().getElementType())) {
            return element;
        }
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class}) != null) {
            return element;
        }
        OCElement context2 = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCStatement.class, OCExpression.class, OCTypeElement.class, OCDeclarator.class, OCDeclaration.class, OCStructLike.class});
        assert (!(context2 instanceof PsiFile));
        assert (!(element instanceof PsiFile));
        return context2 != null ? context2 : element;
    }

    private static boolean isMakeSenseToHighlight(@NotNull IElementType elementType) {
        if (elementType == OCTokenTypes.LBRACE || elementType == OCTokenTypes.RBRACE) {
            return true;
        }
        if (!OCTokenTypes.KEYWORDS.contains(elementType) || OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(elementType)) {
            return false;
        }
        HashSet keywordsToIgnore = ContainerUtil.newHashSet((Object[])new IElementType[]{OCTokenTypes.OPERATOR_CPP_KEYWORD, OCTokenTypes.VIRTUAL_CPP_KEYWORD, OCTokenTypes.EXPLICIT_CPP_KEYWORD, OCTokenTypes.INLINE_KEYWORD, OCTokenTypes.EXTERN_KEYWORD, OCTokenTypes.REGISTER_KEYWORD, OCTokenTypes.STATIC_KEYWORD, OCTokenTypes.CONST_KEYWORD, OCTokenTypes.VOLATILE_KEYWORD});
        return !keywordsToIgnore.contains(elementType);
    }

    @NotNull
    private static TextRange getRangeToHighlight(@NotNull PsiElement element) {
        List<OCDeclarator> declarators;
        PsiElement identifier;
        OCElementType keyword = null;
        if (element instanceof OCStatementWithExpression) {
            keyword = ((OCStatementWithExpression)element).getKeywordType();
        } else if (element instanceof OCIfStatement) {
            keyword = OCTokenTypes.IF_KEYWORD;
        } else if (element instanceof OCCppNamespace) {
            keyword = OCTokenTypes.NAMESPACE_CPP_KEYWORD;
        }
        if (keyword != null) {
            OCElementType keywordToSearch = keyword;
            Optional<ASTNode> keywordElement = Arrays.stream(element.getNode().getChildren(null)).filter(child -> child.getElementType() == keywordToSearch).findFirst();
            if (keywordElement.isPresent()) {
                return keywordElement.get().getTextRange();
            }
        }
        if (element instanceof OCStructLike && (identifier = ((OCStructLike)element).getNameIdentifier()) != null) {
            return OCElementUtil.getRangeWithMacros(identifier);
        }
        if (element instanceof OCDeclaration && (declarators = ((OCDeclaration)element).getDeclarators()).size() == 1 && declarators.get(0).getName() != "<unnamed>") {
            element = declarators.get(0);
        }
        if (element instanceof OCDeclarator && (identifier = ((OCDeclarator)element).getNameIdentifier()) != null) {
            return OCElementUtil.getRangeWithMacros(identifier);
        }
        if (element instanceof LeafPsiElement && element.getText().equals("typename") && element.getParent() instanceof OCTypeElement) {
            return element.getParent().getTextRange();
        }
        return OCElementUtil.getRangeWithMacros(element);
    }

    static interface DiagnosticProcessor {
        public boolean processDiagnostic(@NotNull String var1, @NotNull String var2, @NotNull TextRange var3, @NotNull HighlightSeverity var4, @NotNull ClangTidyInspectionBase var5, @NotNull OCFile var6, @NotNull IntentionAction var7);
    }
}

