/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyReplacement;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J:\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010JF\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010J \u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder;", "", "()V", "createByteToCharMap", "", "", "byteOffsets", "Ljava/util/SortedSet;", "contentInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion$ContentInfo;", "createFor", "", "errors", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangTidyError;", "unsavedFilePaths", "", "fileToByteOffset", "getContentInfo", "filePath", "Companion", "intellij.c"})
public final class ByteToCharOffsetMapBuilder {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Map<Integer, Integer>> createFor(@NotNull List<? extends ClionClangTidyError> errors, @NotNull Collection<String> unsavedFilePaths) {
        HashMap fileToByteOffset = new HashMap();
        for (ClionClangTidyError clionClangTidyError : errors) {
            Companion.addOffset(clionClangTidyError.getFilePath(), clionClangTidyError.getFileOffset(), fileToByteOffset);
            if (clionClangTidyError.getReplacements() == null) continue;
            for (ClionClangTidyReplacement replacement : clionClangTidyError.getReplacements()) {
                Companion.addOffset(replacement.getFilePath(), replacement.getOffset(), fileToByteOffset);
                Companion.addOffset(replacement.getFilePath(), replacement.getOffset() + replacement.getLength(), fileToByteOffset);
            }
        }
        return this.createFor(fileToByteOffset, unsavedFilePaths);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Map<Integer, Integer>> createFor(@NotNull Map<String, ? extends SortedSet<Integer>> fileToByteOffset, @NotNull Collection<String> unsavedFilePaths) {
        void $this$mapTo$iv$iv;
        Map<String, ? extends SortedSet<Integer>> $this$map$iv = fileToByteOffset;
        boolean $i$f$map = false;
        Map<String, ? extends SortedSet<Integer>> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var8_8.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String filePath = (String)it.getKey();
            SortedSet byteOffsets = (SortedSet)it.getValue();
            Companion.ContentInfo contentInfo = this.getContentInfo(filePath, unsavedFilePaths);
            Pair pair = TuplesKt.to((Object)filePath, this.createByteToCharMap(byteOffsets, contentInfo));
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final Map<Integer, Integer> createByteToCharMap(SortedSet<Integer> byteOffsets, Companion.ContentInfo contentInfo) {
        Integer byteOffset;
        if (contentInfo == null) {
            return MapsKt.emptyMap();
        }
        HashMap byteToCharMap = new HashMap();
        int lastCharOffset = 0;
        int lastByteOffset = contentInfo.getBomLength();
        Iterator iterator2 = byteOffsets.iterator();
        while (iterator2.hasNext() && (byteOffset = (Integer)iterator2.next()) <= contentInfo.getContent().length) {
            Integer n = byteOffset;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            int sliceLength = Math.max(0, n - lastByteOffset);
            byte[] byArray = contentInfo.getContent();
            Charset charset = contentInfo.getEncoding();
            boolean bl = false;
            String slice2 = new String(byArray, lastByteOffset, sliceLength, charset);
            String sliceWithUnifiedSeparators = StringUtil.convertLineSeparators((String)slice2);
            int charOffset = lastCharOffset + sliceWithUnifiedSeparators.length();
            ((Map)byteToCharMap).put(byteOffset, charOffset);
            lastCharOffset = charOffset;
            lastByteOffset = byteOffset;
        }
        return byteToCharMap;
    }

    private final Companion.ContentInfo getContentInfo(String filePath, Collection<String> unsavedFilePaths) {
        VirtualFile virtualFile;
        boolean bl;
        FileDocumentManager manager2;
        block6: {
            manager2 = FileDocumentManager.getInstance();
            Iterable $this$any$iv = unsavedFilePaths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!FileUtil.pathsEqual((String)it, (String)filePath)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl && (virtualFile = VfsUtil.findFile((Path)Paths.get(filePath, new String[0]), (boolean)true)) != null) {
            boolean $i$f$runReadAction = false;
            Document document2 = (Document)ApplicationManager.getApplication().runReadAction(new Computable<T>(manager2, virtualFile){
                final /* synthetic */ FileDocumentManager $manager$inlined;
                final /* synthetic */ VirtualFile $virtualFile$inlined;
                {
                    this.$manager$inlined = fileDocumentManager;
                    this.$virtualFile$inlined = virtualFile;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$manager$inlined.getDocument(this.$virtualFile$inlined);
                }
            });
            if (document2 != null) {
                Charset documentEncoding = Charsets.UTF_8;
                boolean $i$f$runReadAction2 = false;
                byte[] content = (byte[])ApplicationManager.getApplication().runReadAction(new Computable<T>(document2, documentEncoding){
                    final /* synthetic */ Document $document$inlined;
                    final /* synthetic */ Charset $documentEncoding$inlined;
                    {
                        this.$document$inlined = document2;
                        this.$documentEncoding$inlined = charset;
                    }

                    public final T compute() {
                        boolean bl = false;
                        String string = this.$document$inlined.getText();
                        Charset charset = this.$documentEncoding$inlined;
                        boolean bl2 = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = string2.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        return (T)byArray;
                    }
                });
                return new Companion.ContentInfo(content, documentEncoding, ByteToCharOffsetMapBuilder.Companion.getBomLength(content, documentEncoding));
            }
        }
        if ((virtualFile = VfsUtil.findFile((Path)Paths.get(filePath, new String[0]), (boolean)true)) == null) {
            return null;
        }
        byte[] content = FileUtil.loadFileBytes((File)new File(filePath));
        return new Companion.ContentInfo(content, virtualFile.getCharset(), ByteToCharOffsetMapBuilder.Companion.getBomLength(content, virtualFile.getCharset()));
    }

    @JvmStatic
    public static final void addOffset(@NotNull String filePath, int offset, @NotNull Map<String, SortedSet<Integer>> result2) {
        Companion.addOffset(filePath, offset, result2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0007J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion;", "", "()V", "addOffset", "", "filePath", "", "offset", "", "result", "", "Ljava/util/SortedSet;", "getBomLength", "content", "", "encoding", "Ljava/nio/charset/Charset;", "ContentInfo", "intellij.c"})
    public static final class Companion {
        private final int getBomLength(byte[] content, Charset encoding) {
            return CharsetToolkit.getBOMLength((byte[])content, (Charset)encoding);
        }

        @JvmStatic
        public final void addOffset(@NotNull String filePath, int offset, @NotNull Map<String, SortedSet<Integer>> result2) {
            if (!result2.containsKey(filePath)) {
                result2.put(filePath, new TreeSet());
            }
            SortedSet<Integer> sortedSet = result2.get(filePath);
            if (sortedSet == null) {
                Intrinsics.throwNpe();
            }
            sortedSet.add(offset);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion$ContentInfo;", "", "content", "", "encoding", "Ljava/nio/charset/Charset;", "bomLength", "", "([BLjava/nio/charset/Charset;I)V", "getBomLength", "()I", "getContent", "()[B", "getEncoding", "()Ljava/nio/charset/Charset;", "intellij.c"})
        private static final class ContentInfo {
            @NotNull
            private final byte[] content;
            @NotNull
            private final Charset encoding;
            private final int bomLength;

            @NotNull
            public final byte[] getContent() {
                return this.content;
            }

            @NotNull
            public final Charset getEncoding() {
                return this.encoding;
            }

            public final int getBomLength() {
                return this.bomLength;
            }

            public ContentInfo(@NotNull byte[] content, @NotNull Charset encoding, int bomLength) {
                this.content = content;
                this.encoding = encoding;
                this.bomLength = bomLength;
            }
        }
    }
}

