/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangFormatChangeSettingsProvider {
    public static final ExtensionPointName<ClangFormatChangeSettingsProvider> CLANG_FORMAT_PROVIDER = ExtensionPointName.create((String)"com.intellij.clangFormatProvider");
    @NonNls
    public static final String CFC_NO_LANGUAGE_SERVICE_FUTURE = ClangFormatFileUtils.getErrorStyleFor("no `clangd` server future.");
    @NonNls
    public static final String CFC_WRONG_SERVICE_FUTURE_RESPOND = ClangFormatFileUtils.getErrorStyleFor("unpredictable respond from `clangd` server future.");
    @NonNls
    public static final String CFC_NO_CONTEXT_FUTURE = ClangFormatFileUtils.getErrorStyleFor("crash or error respond from context request future.");
    @NonNls
    public static final String CFC_WRONG_CONTEXT_FUTURE_RESPOND = ClangFormatFileUtils.getErrorStyleFor("unpredictable respond from context request future.");
    @NonNls
    public static final String CFK_BreakBeforeBraces = "BreakBeforeBraces";
    @NonNls
    public static final String CFK_AfterClass = "AfterClass";
    @NonNls
    public static final String CFK_AfterControlStatement = "AfterControlStatement";
    @NonNls
    public static final String CFK_AfterEnum = "AfterEnum";
    @NonNls
    public static final String CFK_AfterFunction = "AfterFunction";
    @NonNls
    public static final String CFK_AfterNamespace = "AfterNamespace";
    @NonNls
    public static final String CFK_AfterObjCDeclaration = "AfterObjCDeclaration";
    @NonNls
    public static final String CFK_AfterStruct = "AfterStruct";
    @NonNls
    public static final String CFK_AfterUnion = "AfterUnion";
    @NonNls
    public static final String CFK_AfterExternBlock = "AfterExternBlock";
    @NonNls
    public static final String CFK_BeforeCatch = "BeforeCatch";
    @NonNls
    public static final String CFK_BeforeElse = "BeforeElse";
    @NonNls
    public static final String CFK_IndentBraces = "IndentBraces";
    @NonNls
    public static final String CFK_SplitEmptyFunction = "SplitEmptyFunction";
    @NonNls
    public static final String CFK_SplitEmptyRecord = "SplitEmptyRecord";
    @NonNls
    public static final String CFK_SplitEmptyNamespace = "SplitEmptyNamespace";
    @NonNls
    public static final String CFK_MaxEmptyLinesToKeep = "MaxEmptyLinesToKeep";
    @NonNls
    public static final String CFK_KEEP_EMPTY_LINES_AT_THE_START_OF_BLOCKS = "KeepEmptyLinesAtTheStartOfBlocks";
    @NonNls
    public static final String CFK_ColumnLimit = "ColumnLimit";
    @NonNls
    public static final String CFK_IndentWidth = "IndentWidth";
    @NonNls
    public static final String CFK_ObjCBlockIndentWidth = "ObjCBlockIndentWidth";
    @NonNls
    public static final String CFK_ContinuationIndentWidth = "ContinuationIndentWidth";
    @NonNls
    public static final String CFK_TabWidth = "TabWidth";
    @NonNls
    public static final String CFK_UseTab = "UseTab";
    @NonNls
    public static final String CFK_AccessModifierOffset = "AccessModifierOffset";
    @NonNls
    public static final String CFK_IndentCaseLabels = "IndentCaseLabels";
    @NonNls
    public static final String CFK_NamespaceIndentation = "NamespaceIndentation";
    @NonNls
    public static final String CFV_Custom = "Custom";
    @NonNls
    public static final String CFV_Never = "Never";
    @NonNls
    public static final String CFV_Always = "Always";
    @NonNls
    public static final String CFV_None = "None";
    @NonNls
    public static final String CFV_Inner = "Inner";
    @NonNls
    public static final String CFV_All = "All";

    @Nullable
    public static ClangFormatChangeSettingsProvider findApplicableFormatProvider(@NotNull Project project2, @NotNull FileType language) {
        for (ClangFormatChangeSettingsProvider extension : CLANG_FORMAT_PROVIDER.getExtensionList()) {
            if (!extension.isApplicable(project2, language)) continue;
            return extension;
        }
        return null;
    }

    @NotNull
    public String findClangFormatContent(Project var1, @NotNull VirtualFile var2);

    public VirtualFile extractClangFormatFile(@NotNull String var1);

    public boolean applyCollectedSettings(@NotNull TransientCodeStyleSettings var1, @NotNull PsiFile var2, @NotNull Map<String, Object> var3);

    public boolean isApplicable(@NotNull Project var1, @NotNull FileType var2);

    public boolean isActive(@NotNull Project var1, @NotNull FileType var2);

    @Nullable
    public TextRange format(@NotNull PsiFile var1, @NotNull TextRange var2, @Nullable String var3, boolean var4, boolean var5);

    @Nullable
    public String indent(@NotNull PsiFile var1, int var2, @Nullable String var3);
}

