/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.google.common.collect.Lists;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColRange;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangDaemonFormatProvider
implements ClangFormatChangeSettingsProvider {
    @NonNls
    private static final String ourErrorPreamble = "Problem with access to ClangFormat configuration: ";
    @NonNls
    private static final String ourClangFormatConfigureSourcePrefix = "# ClangFormatConfigureSource: ";
    private static boolean ourDebugRangesForFormat = false;
    @NonNls
    private static final String PARSE_START = "Error reading";
    @NonNls
    private static final String WRONG_CFG_START = "Configuration file(s) do(es) not support";
    private static final Pattern CLANG_FORMAT_CONFIGURE_SOURCE = Pattern.compile("^#\\s*ClangFormatConfigureSource:\\s*'([^']*)'\\s*\n.*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @NonNls
    public String findClangFormatContent(@NotNull Project project2, @NotNull VirtualFile vfCodeFile) {
        ClangLanguageService service = ClangLanguageServiceProvider.getOrStart(project2);
        if (!service.isDummy()) {
            SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "cf_" + vfCodeFile.getPath());
            try {
                service.notifyDocumentOpened(vfCodeFile, openRequestId);
                CompletableFuture<String> future = service.requestClangFormatConfiguration(vfCodeFile);
                try {
                    String clangFormatContent = ClangUtils.waitCancelAware(future, ".clang-format content");
                    if (clangFormatContent == null || clangFormatContent.isEmpty()) {
                        String string = CFC_NO_CONTEXT_FUTURE;
                        return string;
                    }
                    String string = clangFormatContent;
                    return string;
                }
                catch (ExecutionException e) {
                    String clangFormatFileWithErrorURL;
                    OpenFileDescriptor fileDescriptor;
                    CidrLogService.logOnce(Level.WARNING, e.getMessage(), e);
                    @NotNull Throwable cause = e.getCause() != null ? e.getCause() : e;
                    @NotNull String message = cause.getMessage() != null ? cause.getMessage() : cause.getClass().toString();
                    ProcessedMessage pe = ClangDaemonFormatProvider.processMessage(StringUtil.notNullize((String)message, (String)e.toString()));
                    if (!pe.getClangFormatURLs().isEmpty() && (fileDescriptor = ClangDaemonFormatProvider.createOpenFileDescriptor(project2, clangFormatFileWithErrorURL = pe.getClangFormatURLs().get(0))) != null) {
                        String string = ClangDaemonFormatProvider.getCFSourceCommentLine(fileDescriptor.getFile()) + ClangFormatFileUtils.getErrorStyleFor(message);
                        return string;
                    }
                    if (!pe.getFilteredMessage().isEmpty()) {
                        String string = ClangFormatFileUtils.getErrorStyleFor(ourErrorPreamble + message);
                        return string;
                    }
                }
            }
            finally {
                service.notifyDocumentClosed(vfCodeFile, openRequestId);
            }
        }
        return CFC_WRONG_CONTEXT_FUTURE_RESPOND;
    }

    @NotNull
    @NonNls
    public static String getCFSourceCommentLine(@NotNull VirtualFile cfvFile) {
        return "# ClangFormatConfigureSource: 'clang-format-file://" + cfvFile.getCanonicalPath() + "'\n";
    }

    @Override
    public boolean applyCollectedSettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile codeFile, @NotNull Map<String, Object> formattingOptionValue) {
        boolean isModified = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = ClangFormatFileUtils.getOverriddenIndentOptions(settings);
        OCCodeStyleSettings oc = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        CommonCodeStyleSettings common = settings.getCommonSettings(codeFile.getLanguage());
        boolean customBraceStyle = true;
        oc.BLOCK_BRACE_PLACEMENT = 1;
        isModified |= oc.BLOCK_BRACE_PLACEMENT != 1;
        for (Map.Entry<String, Object> entry : formattingOptionValue.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                if ("AfterClass".equals(key)) {
                    int CLASS_BRACE_STYLE = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), false);
                    isModified |= CLASS_BRACE_STYLE != common.CLASS_BRACE_STYLE;
                    common.CLASS_BRACE_STYLE = CLASS_BRACE_STYLE;
                    continue;
                }
                if ("AfterFunction".equals(key)) {
                    int FUNCTION_BRACE_PLACEMENT = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), false);
                    isModified |= FUNCTION_BRACE_PLACEMENT != oc.FUNCTION_BRACE_PLACEMENT;
                    oc.FUNCTION_BRACE_PLACEMENT = FUNCTION_BRACE_PLACEMENT;
                    continue;
                }
                if ("AfterControlStatement".equals(key)) {
                    int BRACE_STYLE = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), ClangDaemonFormatProvider._boolean(formattingOptionValue.get("IndentBraces")));
                    isModified |= BRACE_STYLE != common.BRACE_STYLE;
                    common.BRACE_STYLE = BRACE_STYLE;
                    continue;
                }
                if ("AfterNamespace".equals(key)) {
                    int NAMESPACE_BRACE_PLACEMENT = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), false);
                    isModified |= NAMESPACE_BRACE_PLACEMENT != oc.NAMESPACE_BRACE_PLACEMENT;
                    oc.NAMESPACE_BRACE_PLACEMENT = NAMESPACE_BRACE_PLACEMENT;
                    continue;
                }
                if ("BeforeElse".equals(key)) {
                    boolean vBeforeElse = ClangDaemonFormatProvider._boolean(value);
                    isModified |= vBeforeElse != common.ELSE_ON_NEW_LINE;
                    common.ELSE_ON_NEW_LINE = vBeforeElse;
                    continue;
                }
                if ("BeforeCatch".equals(key)) {
                    boolean vBeforeCatch = ClangDaemonFormatProvider._boolean(value);
                    isModified |= vBeforeCatch != common.CATCH_ON_NEW_LINE;
                    common.CATCH_ON_NEW_LINE = vBeforeCatch;
                    continue;
                }
                if ("ColumnLimit".equals(key)) {
                    int vColumnLimit = ClangDaemonFormatProvider._int(value);
                    boolean vKeepLineBreaks = false;
                    if (vColumnLimit == 0) {
                        vColumnLimit = 1000;
                        vKeepLineBreaks = true;
                    }
                    isModified |= vColumnLimit != common.RIGHT_MARGIN || vKeepLineBreaks != common.KEEP_LINE_BREAKS;
                    common.RIGHT_MARGIN = vColumnLimit;
                    common.KEEP_LINE_BREAKS = vKeepLineBreaks;
                    continue;
                }
                if ("MaxEmptyLinesToKeep".equals(key)) {
                    int vMaxEmptyLinesToKeep = ClangDaemonFormatProvider._int(value);
                    isModified |= vMaxEmptyLinesToKeep != common.KEEP_BLANK_LINES_IN_CODE;
                    common.KEEP_BLANK_LINES_IN_CODE = vMaxEmptyLinesToKeep;
                    continue;
                }
                if ("IndentWidth".equals(key)) {
                    int vIndentWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vIndentWidth != indentOptions.INDENT_SIZE || vIndentWidth != oc.INDENT_CLASS_MEMBERS || vIndentWidth != oc.INDENT_C_STRUCT_MEMBERS || vIndentWidth != oc.INDENT_INTERFACE_MEMBERS || vIndentWidth != oc.INDENT_IMPLEMENTATION_MEMBERS || oc.INDENT_PREPROCESSOR_DIRECTIVE != 0 || oc.INDENT_DIRECTIVE_AS_CODE || !oc.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK;
                    oc.INDENT_INTERFACE_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS = vIndentWidth;
                    oc.INDENT_C_STRUCT_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    oc.INDENT_CLASS_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    indentOptions.INDENT_SIZE = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    oc.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK = true;
                    oc.INDENT_DIRECTIVE_AS_CODE = false;
                    oc.INDENT_PREPROCESSOR_DIRECTIVE = 0;
                    continue;
                }
                if ("ObjCBlockIndentWidth".equals(key)) {
                    int vObjCBlockIndentWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vObjCBlockIndentWidth != oc.INDENT_INSIDE_CODE_BLOCK;
                    oc.INDENT_INSIDE_CODE_BLOCK = vObjCBlockIndentWidth;
                    continue;
                }
                if ("ContinuationIndentWidth".equals(key)) {
                    int vContinuationIndentWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vContinuationIndentWidth != indentOptions.CONTINUATION_INDENT_SIZE;
                    indentOptions.CONTINUATION_INDENT_SIZE = vContinuationIndentWidth;
                    continue;
                }
                if ("TabWidth".equals(key)) {
                    int vTabWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vTabWidth != indentOptions.TAB_SIZE;
                    indentOptions.TAB_SIZE = vTabWidth;
                    continue;
                }
                if ("UseTab".equals(key)) {
                    Boolean vUseTab = null;
                    if ("Never".equals(value)) {
                        vUseTab = Boolean.FALSE;
                    }
                    if ("Always".equals(value)) {
                        vUseTab = Boolean.TRUE;
                    }
                    if (vUseTab == null) continue;
                    isModified |= !vUseTab.equals(indentOptions.USE_TAB_CHARACTER);
                    indentOptions.USE_TAB_CHARACTER = vUseTab;
                    continue;
                }
                if ("AccessModifierOffset".equals(key)) {
                    int vAccessModifierOffset = ClangDaemonFormatProvider._int(value) + ClangDaemonFormatProvider._int(formattingOptionValue.get("IndentWidth"));
                    isModified |= vAccessModifierOffset != oc.INDENT_VISIBILITY_KEYWORDS;
                    oc.INDENT_VISIBILITY_KEYWORDS = vAccessModifierOffset;
                    continue;
                }
                if ("IndentCaseLabels".equals(key)) {
                    boolean vIndentCaseLabels = ClangDaemonFormatProvider._boolean(value);
                    isModified |= vIndentCaseLabels != common.INDENT_CASE_FROM_SWITCH;
                    common.INDENT_CASE_FROM_SWITCH = vIndentCaseLabels;
                    continue;
                }
                if (!"NamespaceIndentation".equals(key)) continue;
                String vNamespaceIndentation = ClangDaemonFormatProvider._str(value);
                int INDENT_NAMESPACE_MEMBERS = oc.INDENT_NAMESPACE_MEMBERS;
                if ("None".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = 0;
                } else if ("Inner".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = 0;
                } else if ("All".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = ClangDaemonFormatProvider._int(formattingOptionValue.get("IndentWidth"));
                }
                isModified |= INDENT_NAMESPACE_MEMBERS != oc.INDENT_NAMESPACE_MEMBERS;
                oc.INDENT_NAMESPACE_MEMBERS = INDENT_NAMESPACE_MEMBERS;
            }
            catch (UnsupportedOperationException t) {
                OCLog.LOG.info("No option:" + key);
            }
            catch (Throwable t) {
                OCLog.LOG.warn("Problem option with " + key + ":" + t.getMessage());
            }
        }
        return isModified;
    }

    @Contract(pure=true)
    private static int getBraceStyle(boolean wrapAfter, boolean indentBrace) {
        return !wrapAfter ? 1 : (indentBrace ? 4 : 2);
    }

    private static String _str(@Nullable Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return value.toString();
    }

    private static int _int(@Nullable Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return Integer.parseInt((String)value);
    }

    private static boolean _boolean(@Nullable Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return Boolean.parseBoolean((String)value);
    }

    @Override
    public boolean isApplicable(@NotNull Project project2, @NotNull FileType fileType) {
        return OCLanguageUtils.isSupported(fileType);
    }

    @Override
    public boolean isActive(@NotNull Project project2, @NotNull FileType fileType) {
        return this.isApplicable(project2, fileType) && ClangUtils.isClangdOn(project2);
    }

    @Nullable
    private static String styleForFormatting(@Nullable String style, @NotNull Project project2) {
        String errorParsingMessageFromStyle = ClangDaemonFormatProvider.getErrorParsingMessageFromStyle(style);
        if (errorParsingMessageFromStyle != null) {
            ClangDaemonFormatProvider.reportClangFormatError(errorParsingMessageFromStyle, project2, MessageType.ERROR);
            return null;
        }
        return ClangDaemonFormatProvider.makeStyleLanguageAgnostic(style);
    }

    @NotNull
    private static String styleToKeepLineBreaks(@NotNull String style) {
        int index = style.indexOf("ColumnLimit:");
        if (index >= 0) {
            int lineEnd = style.indexOf("\n", index);
            style = style.substring(0, index) + "ColumnLimit: 0" + (lineEnd == -1 ? "" : style.substring(lineEnd));
        } else {
            style = style + "ColumnLimit: 0\n";
        }
        style = style + "KeepLineBreaksForNonEmptyLines: true\n";
        return style;
    }

    private static void handleFormatException(@NotNull Exception e, @NotNull Project project2) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        if (application.isInternal()) {
            OCLog.LOG.warn("Problem while ClangFormat procedure", (Throwable)e);
        }
        String message = StringUtil.notNullize((String)(e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
        ClangDaemonFormatProvider.reportClangFormatError(message, project2, MessageType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable(value="return null if cannot guaranty the consistency of Psi and document before or after formatting procedure")
    public @Nullable(value="return null if cannot guaranty the consistency of Psi and document before or after formatting procedure") TextRange format(@NotNull PsiFile source, @NotNull TextRange range, @Nullable String style, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks) {
        Project project2 = source.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        VirtualFile virtualFile = source.getViewProvider().getVirtualFile();
        Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile);
        OCLog.LOG.assertTrue(document2 != null);
        String origText = document2.getText();
        if (ourDebugRangesForFormat) {
            ClangDaemonFormatProvider.outDebugString("Format range: " + source.getName() + ClangDaemonFormatProvider.selectedRangeInContext(origText, range));
        }
        if ((style = ClangDaemonFormatProvider.styleForFormatting(style, project2)) == null) {
            return range;
        }
        if (keepLineBreaks) {
            style = ClangDaemonFormatProvider.styleToKeepLineBreaks(style);
        }
        try {
            CompletableFuture<List<ClangLineColReplace>> future = ClangLanguageServiceProvider.getIfStarted(project2).formatRange(virtualFile, range, style);
            List<ClangLineColReplace> replaces = ClangUtils.waitCancelAware(future, "formatRange");
            if (replaces == null || replaces.isEmpty()) {
                return source.getTextRange();
            }
            Ref start = Ref.create((Object)Integer.MAX_VALUE);
            Ref end = Ref.create((Object)Integer.MIN_VALUE);
            Ref delta = Ref.create((Object)0);
            boolean wasInBulkUpdate = document2.isInBulkUpdate();
            if (!wasInBulkUpdate) {
                document2.setInBulkUpdate(true);
            }
            try {
                replaces.stream().sorted(Comparator.comparingInt(o -> -o.getRange().getStart().getOffset(document2))).map(replace -> {
                    ClangLineColRange replaceRange = replace.getRange();
                    TextRange mappedRange = TextRange.create((int)replaceRange.getStart().getOffset(document2), (int)replaceRange.getEnd().getOffset(document2));
                    if (ourDebugRangesForFormat) {
                        ClangDaemonFormatProvider.outDebugString("map" + ClangDaemonFormatProvider.selectedRangeInContext(origText, mappedRange) + " to >>>" + replace.getReplace() + "<<<");
                    }
                    return Pair.create((Object)replace.getReplace(), (Object)mappedRange);
                }).collect(Collectors.toList()).forEach(replaceRange -> {
                    if (!(!range.intersects((TextRange)replaceRange.second) || range.getEndOffset() != origText.length() && ((TextRange)replaceRange.second).getStartOffset() == range.getEndOffset() || canChangeWhiteSpacesOnly && !StringUtil.isEmptyOrSpaces((String)((String)replaceRange.first)))) {
                        String replaceText = (String)replaceRange.first;
                        int startOffset = ((TextRange)replaceRange.second).getStartOffset();
                        int endOffset = ((TextRange)replaceRange.second).getEndOffset();
                        start.set((Object)Math.min((Integer)start.get(), startOffset));
                        end.set((Object)Math.max((Integer)end.get(), endOffset));
                        int oldLength = endOffset - startOffset;
                        int newLength = replaceText.length();
                        int diff2 = newLength - oldLength;
                        delta.set((Object)((Integer)delta.get() + diff2));
                        if (ourDebugRangesForFormat) {
                            ClangDaemonFormatProvider.outDebugString("Replace:" + ClangDaemonFormatProvider.selectedRangeInContext(origText, (TextRange)replaceRange.second) + "\n to >>>" + replaceText + "<<<");
                        }
                        document2.replaceString(startOffset, endOffset, (CharSequence)replaceText);
                    }
                });
            }
            finally {
                if (!wasInBulkUpdate) {
                    document2.setInBulkUpdate(false);
                }
            }
            if ((Integer)start.get() != Integer.MAX_VALUE && (Integer)start.get() != Integer.MIN_VALUE) {
                TextRange diffRangeInModifiedDoc = TextRange.create((int)((Integer)start.get()), (int)((Integer)end.get() + (Integer)delta.get()));
                return ClangDaemonFormatProvider.psiAndDocumentAreSynchronized(psiDocumentManager, document2) ? TextRange.create((int)Integer.min(range.getStartOffset(), diffRangeInModifiedDoc.getStartOffset()), (int)Integer.max(range.getEndOffset() + (Integer)delta.get(), diffRangeInModifiedDoc.getEndOffset())) : null;
            }
        }
        catch (ProcessCanceledException cancel) {
            throw cancel;
        }
        catch (Exception e) {
            ClangDaemonFormatProvider.handleFormatException(e, project2);
        }
        return range;
    }

    @NotNull
    private static String indentationFromList(@NotNull Document document2, @NotNull List<ClangLineColReplace> replaces, int lineStartOffset) {
        for (ClangLineColReplace replace : Lists.reverse(replaces)) {
            int offsetStart = replace.getRange().getStart().getOffset(document2);
            int offsetEnd = replace.getRange().getEnd().getOffset(document2);
            if (lineStartOffset <= offsetStart || lineStartOffset > offsetEnd) continue;
            String replaceString = replace.getReplace();
            int firstSpace = replaceString.lastIndexOf(10) + 1;
            return replaceString.substring(firstSpace, CharArrayUtil.shiftForward((CharSequence)replaceString, (int)firstSpace, (String)" \t"));
        }
        return "";
    }

    @Override
    public String indent(@NotNull PsiFile source, int lineStartOffset, @Nullable String style) {
        Project project2 = source.getProject();
        VirtualFile virtualFile = source.getViewProvider().getVirtualFile();
        Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile);
        OCLog.LOG.assertTrue(document2 != null);
        style = ClangDaemonFormatProvider.styleForFormatting(style, project2);
        if (style == null) {
            return null;
        }
        String indentString = null;
        try {
            CompletableFuture<List<ClangLineColReplace>> future = ClangLanguageServiceProvider.getIfStarted(project2).indentLine(virtualFile, lineStartOffset, style);
            List<ClangLineColReplace> replaces = ClangUtils.waitCancelAware(future, "indentLine");
            if (replaces == null || replaces.isEmpty()) {
                return null;
            }
            indentString = ClangDaemonFormatProvider.indentationFromList(document2, replaces, lineStartOffset);
        }
        catch (ProcessCanceledException cancel) {
            throw cancel;
        }
        catch (Exception e) {
            ClangDaemonFormatProvider.handleFormatException(e, project2);
        }
        return indentString;
    }

    @Contract(value="null -> null")
    private static String makeStyleLanguageAgnostic(@Nullable String style) {
        if (style == null) {
            return null;
        }
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)style);
        if (Arrays.stream(lines).filter(line -> line.startsWith("---")).count() > 1L) {
            return style;
        }
        return Arrays.stream(lines).filter(line -> !line.startsWith("---") && !line.startsWith("...") && !line.startsWith("Language:")).collect(Collectors.joining());
    }

    @Contract(value="null -> null")
    public static String getErrorParsingMessageFromStyle(@Nullable String style) {
        if (style == null) {
            return null;
        }
        String[] lines = StringUtil.splitByLines((String)style);
        if (lines.length == 1) {
            return ClangFormatFileUtils.getErrorMessageFromYAMLine(lines[0]);
        }
        if ((lines.length == 2 || lines.length == 3) && lines[0].startsWith(ourClangFormatConfigureSourcePrefix)) {
            return ClangFormatFileUtils.getErrorMessageFromYAMLine(lines[1] + (lines.length == 2 ? "" : " - " + lines[2]));
        }
        return null;
    }

    private static boolean psiAndDocumentAreSynchronized(@NotNull PsiDocumentManager psiDocumentManager, @NotNull Document document2) {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            psiDocumentManager.commitDocument(document2);
            return true;
        }
        return psiDocumentManager.isCommitted(document2);
    }

    private static void outDebugString(@NotNull @NonNls String message) {
        assert (ourDebugRangesForFormat);
        System.out.println("=============================== " + message);
    }

    @NotNull
    private static String selectedRangeInContext(@NotNull @NonNls String text, @NotNull TextRange range) {
        return "\n'" + text.substring(0, range.getStartOffset()) + ">>>" + range.substring(text) + "<<<" + text.substring(range.getEndOffset()) + "'";
    }

    public static void reportClangFormatError(@NotNull String message, final @NotNull Project project2, MessageType messageType) {
        ProcessedMessage pe = ClangDaemonFormatProvider.processMessage(message);
        UIUtil.invokeLaterIfNeeded(() -> {
            BalloonLayout layout;
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(pe.getFilteredMessage(), messageType, new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    OpenFileDescriptor descriptor;
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (descriptor = ClangDaemonFormatProvider.createOpenFileDescriptor(project2, e.getDescription())) != null) {
                        new OpenFileHyperlinkInfo(descriptor).navigate(project2);
                    }
                }
            }).setFadeoutTime(0L).setShowCallout(false).setAnimationCycle(0).setHideOnClickOutside(true).setHideOnKeyOutside(true).setHideOnLinkClick(true).setCloseButtonEnabled(true).createBalloon();
            Disposer.register((Disposable)project2, (Disposable)balloon);
            Frame window = WindowManager.getInstance().getFrame(project2);
            if (window == null) {
                window = JOptionPane.getRootFrame();
            }
            if (window instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                balloon.show((PositionTracker)new PositionTracker<Balloon>((Component)((IdeFrame)window).getComponent()){

                    public RelativePoint recalculateLocation(Balloon object) {
                        Component c = this.getComponent();
                        int y = c.getHeight() - 45;
                        return new RelativePoint(c, new Point(c.getWidth() - 150, y));
                    }
                }, Balloon.Position.above);
            }
        });
    }

    @Contract(value="_, null -> null")
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project2, @Nullable String url) {
        VirtualFile vtClangFormat;
        if (url == null) {
            return null;
        }
        int pos = url.lastIndexOf(58);
        int col = 0;
        int line = 0;
        if (pos > 1) {
            String num1 = url.substring(pos + 1);
            if ((pos = (url = url.substring(0, pos)).lastIndexOf(58)) > 1) {
                String num2 = url.substring(pos + 1);
                url = url.substring(0, pos);
                line = ClangDaemonFormatProvider._int(num2);
                col = ClangDaemonFormatProvider._int(num1);
            } else {
                line = ClangDaemonFormatProvider._int(num1);
            }
        }
        if ((vtClangFormat = VfsUtil.findFile((Path)Paths.get(url, new String[0]), (boolean)false)) != null) {
            return new OpenFileDescriptor(project2, vtClangFormat, line - 1, col);
        }
        return null;
    }

    @NotNull
    public static ProcessedMessage processMessage(@NotNull String message) {
        int pos;
        if (message.startsWith(PARSE_START)) {
            int pos2 = message.lastIndexOf(":");
            String messageEnd = message.substring(pos2);
            String fileName = message.substring(PARSE_START.length(), pos2).trim();
            return ProcessedMessage.createProcessedMessage(Collections.singletonList(fileName), "<html><body>Error reading <a href='" + fileName + "'>" + fileName + "</a>" + messageEnd + "</body></html>");
        }
        if (message.startsWith(WRONG_CFG_START) && (pos = message.indexOf(":")) > 0) {
            StringBuffer sb = new StringBuffer(message.substring(0, pos + 1));
            List paths = StringUtil.split((String)message.substring(pos + 1), (String)",");
            boolean[] first = new boolean[]{true};
            SmartList clangFormatURLs = new SmartList();
            paths.forEach(arg_0 -> ClangDaemonFormatProvider.lambda$processMessage$6((List)clangFormatURLs, first, sb, arg_0));
            return ProcessedMessage.createProcessedMessage((List<String>)clangFormatURLs, "<html><body>" + sb.toString() + "</body></html>");
        }
        return ProcessedMessage.createProcessedMessage(ContainerUtil.emptyList(), message);
    }

    private static int _int(String num2) {
        try {
            return Integer.parseInt(num2);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    @Override
    @Nullable
    public VirtualFile extractClangFormatFile(@NotNull String clangFormatExtendedContext) {
        String formatSource = ClangDaemonFormatProvider.extractClangFormatSource(clangFormatExtendedContext);
        return formatSource == null ? null : ClangFormatFileUtils.getClangFormatFile(formatSource, false);
    }

    @Nullable
    public static String extractClangFormatSource(@NotNull String clangFormatExtendedContext) {
        Matcher matcher = CLANG_FORMAT_CONFIGURE_SOURCE.matcher(clangFormatExtendedContext);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static /* synthetic */ void lambda$processMessage$6(List clangFormatURLs, boolean[] first, StringBuffer sb, String fileName) {
        String trim = fileName.trim();
        clangFormatURLs.add(trim);
        if (first[0]) {
            first[0] = false;
            sb.append(" ");
        } else {
            sb.append(", ");
        }
        sb.append("<a href='").append(trim).append("'>").append(trim).append("</a>");
    }

    public static class ProcessedMessage {
        private final List<String> myClangFormatURLs;
        private final String myFilteredMessage;

        private ProcessedMessage(@NotNull List<String> clangFormatURLs, @NotNull String message) {
            this.myClangFormatURLs = clangFormatURLs;
            this.myFilteredMessage = message;
        }

        public List<String> getClangFormatURLs() {
            return this.myClangFormatURLs;
        }

        public String getFilteredMessage() {
            return this.myFilteredMessage;
        }

        @NotNull
        @Contract(value="_, _ -> new")
        public static ProcessedMessage createProcessedMessage(@NotNull List<String> clangFormatURLs, @NotNull String message) {
            return new ProcessedMessage(clangFormatURLs, message);
        }
    }
}

