/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.table.JBTable;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.BuildPreambleError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangPreambleTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetryListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdInfoPanel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdInfoPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdInfoPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "makePidText", "", "status", "makePreambleStatsText", "intellij.c"})
public final class ClangdInfoPanel
extends ClangdPanelBase {
    @NotNull
    public final String makePreambleStatsText(@NotNull Project project2) {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor();
        String curFile = fileEditor != null && (fileEditor = fileEditor.getFile()) != null ? fileEditor.getPath() : null;
        ClangTelemetry telemetry = ClangLanguageServiceProvider.getIfStarted(project2).getTelemetry();
        if (curFile != null && telemetry != null) {
            ClangPreambleTelemetry preambleTelemetry = telemetry.getPreambleTelemetry();
            int preambleParses = preambleTelemetry.getPreambleParses(curFile);
            int preambleReuses = preambleTelemetry.getPreambleReuses(curFile);
            int preambleFailures = preambleTelemetry.getPreambleFailures(curFile);
            int preambleDidntHitTarget = preambleTelemetry.getPreambleFailures(curFile, BuildPreambleError.DidntHitTargetFile);
            int preambleCancels = preambleTelemetry.getPreambleCancels(curFile);
            return "Preamble [reparsed: " + (preambleParses - preambleCancels) + ", " + "cancelled: " + preambleCancels + ", " + "reused: " + preambleReuses + ", " + "failed: " + preambleFailures + " (" + preambleDidntHitTarget + " didn't hit)]";
        }
        return "Preamble [reparsed: N/A, cancelled: N/A, reused: N/A, failed: N/A, empty: N/A]";
    }

    private final String makePidText(Project project2, String status) {
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project2);
        int pid = service.getServerPid();
        return "Clangd server PID: " + (pid == -1 ? "Unknown" : String.valueOf(pid)) + " [" + status + ']';
    }

    /*
     * WARNING - void declaration
     */
    public ClangdInfoPanel(final @NotNull Project project2) {
        void it;
        void pidPanel;
        void preamblePanel;
        JPanel centerPanel = new JPanel(new BorderLayout());
        final JLabel memoryLabel = new JLabel(ClangdBundle.message("language.cpp.clangd.memory.usage.info.na", new Object[0]));
        final JLabel preambleLabel = new JLabel(this.makePreambleStatsText(project2));
        final JLabel pidLabel = new JLabel(this.makePidText(project2, "Running"));
        AbstractTableModel perFileModel2 = new AbstractTableModel(){
            @NotNull
            private List<ClangMemoryUsageInfo.PerFile> perFile;

            @NotNull
            public final List<ClangMemoryUsageInfo.PerFile> getPerFile() {
                return this.perFile;
            }

            public final void setPerFile(@NotNull List<ClangMemoryUsageInfo.PerFile> list) {
                this.perFile = list;
            }

            public int getRowCount() {
                return this.perFile.size();
            }

            public int getColumnCount() {
                return 2;
            }

            @Nullable
            public String getValueAt(int rowIndex, int columnIndex) {
                String string;
                switch (columnIndex) {
                    case 0: {
                        string = this.perFile.get(rowIndex).getPath();
                        break;
                    }
                    case 1: {
                        string = ClangdInfoPanelKt.access$kb2Mb(this.perFile.get(rowIndex).getKb());
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                return string;
            }
            {
                this.perFile = CollectionsKt.emptyList();
            }
        };
        JBTable table = new JBTable((TableModel)perFileModel2);
        centerPanel.add((Component)memoryLabel, "First");
        JPanel jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        boolean bl2 = false;
        JPanel jPanel2 = jPanel;
        JPanel jPanel3 = centerPanel;
        boolean bl3 = false;
        preamblePanel.add((Component)preambleLabel, "First");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        boolean bl4 = false;
        boolean bl5 = false;
        JPanel jPanel5 = jPanel4;
        void var17_18 = preamblePanel;
        boolean bl6 = false;
        pidPanel.add((Component)pidLabel, "First");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        boolean bl7 = false;
        boolean bl8 = false;
        JPanel jPanel7 = jPanel6;
        void var23_24 = pidPanel;
        boolean bl9 = false;
        it.add((Component)new JLabel(ClangdBundle.message("language.cpp.clangd.info.panel.per.file.label", new Object[0])), "First");
        it.add((Component)table, "Center");
        Unit unit = Unit.INSTANCE;
        var23_24.add(jPanel6);
        Unit unit2 = Unit.INSTANCE;
        var17_18.add(jPanel4);
        Unit unit3 = Unit.INSTANCE;
        jPanel3.add((Component)jPanel, "Center");
        this.add(centerPanel);
        project2.getMessageBus().connect((Disposable)this).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(perFileModel2, table){
            final /* synthetic */ perFileModel.1 $perFileModel;
            final /* synthetic */ JBTable $table;

            @Override
            public void onServerRunning() {
                this.updatePid("Running");
            }

            @Override
            public void onServerFailure() {
                this.updatePid("Failure");
            }

            @Override
            public void onServerShutDown() {
                this.updatePid("Shut Down");
            }

            private final void updatePid(String status) {
                pidLabel.setText(this.makePidText(project2, status));
            }

            @Override
            public void onMemoryUsageInfoReceived(@NotNull ClangMemoryUsageInfo info) {
                memoryLabel.setText(ClangdBundle.message("language.cpp.clangd.memory.usage.info", ClangdInfoPanelKt.access$kb2Mb(info.getWorkingSet()), ClangdInfoPanelKt.access$kb2Mb(info.getDrafts()), ClangdInfoPanelKt.access$kb2Mb(info.getUnsaved())));
                this.$perFileModel.setPerFile(info.getPerFile());
                this.$table.updateUI();
            }
            {
                this.$perFileModel = $captured_local_variable$4;
                this.$table = $captured_local_variable$5;
            }
        });
        project2.getMessageBus().connect((Disposable)this).subscribe(ClangTelemetryListener.TOPIC, (Object)new ClangTelemetryListener(){

            @Override
            public void onPreambleTelemetry(@NotNull ClangTelemetry telemetry) {
                preambleLabel.setText(this.makePreambleStatsText(project2));
            }
        });
        project2.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                preambleLabel.setText(this.makePreambleStatsText(project2));
            }
        });
    }
}

