/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelKt;
import java.awt.Component;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "output", "Ljavax/swing/JTextPane;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getUpdateQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "setUpdateQueue", "(Lcom/intellij/util/ui/update/MergingUpdateQueue;)V", "setupTextPane", "", "EditorEventListener", "ViewUpdate", "intellij.c"})
public final class ClangdCaretPanel
extends ClangdPanelBase {
    private final JTextPane output;
    @NotNull
    private MergingUpdateQueue updateQueue;
    private final Project project;

    @NotNull
    public final MergingUpdateQueue getUpdateQueue() {
        return this.updateQueue;
    }

    public final void setUpdateQueue(@NotNull MergingUpdateQueue mergingUpdateQueue) {
        this.updateQueue = mergingUpdateQueue;
    }

    private final void setupTextPane() {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet attrs = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.FontFamily, "Lucida Console");
        attrs = sc.addAttribute(attrs, StyleConstants.Alignment, 3);
        this.output.setCharacterAttributes(attrs, false);
    }

    public ClangdCaretPanel(@NotNull Project project2) {
        this.project = project2;
        this.output = new JTextPane(new DefaultStyledDocument());
        this.updateQueue = new MergingUpdateQueue("Clang Caret Context Queue", 600, true, null, (Disposable)this, null, false);
        this.setupTextPane();
        this.add((Component)new JBScrollPane((Component)this.output));
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        EditorEventListener listener = new EditorEventListener();
        eventMulticaster.addCaretListener((CaretListener)listener, (Disposable)this);
        if (eventMulticaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListener((FocusChangeListener)listener, (Disposable)this);
        }
    }

    public static final /* synthetic */ JTextPane access$getOutput$p(ClangdCaretPanel $this) {
        return $this.output;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel$EditorEventListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel;)V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "focusGained", "editor", "Lcom/intellij/openapi/editor/Editor;", "focusLost", "update", "intellij.c"})
    public final class EditorEventListener
    implements CaretListener,
    FocusChangeListener {
        public void caretPositionChanged(@NotNull CaretEvent event) {
            this.update(event.getEditor());
        }

        public void focusGained(@NotNull Editor editor) {
            this.update(editor);
        }

        public void focusLost(@NotNull Editor editor) {
        }

        private final void update(Editor editor) {
            if (ClangdPanelKt.isPanelActive(ClangdCaretPanel.this.project, "Caret")) {
                Document document2 = editor.getDocument();
                int hash = document2.hashCode();
                ClangdCaretPanel.this.getUpdateQueue().queue((Update)new ViewUpdate(document2, editor.getCaretModel().getOffset(), hash));
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel$ViewUpdate;", "Lcom/intellij/util/ui/update/Update;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "hash", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel;Lcom/intellij/openapi/editor/Document;II)V", "run", "", "intellij.c"})
    public final class ViewUpdate
    extends Update {
        private final Document document;
        private final int offset;

        /*
         * WARNING - void declaration
         */
        public void run() {
            VirtualFile virtualFile;
            PsiFile psiFile;
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(ClangdCaretPanel.this.project);
            boolean $i$f$runReadAction = false;
            PsiFile psiFile2 = psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ ViewUpdate this$0;
                {
                    this.this$0 = viewUpdate;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)PsiDocumentManager.getInstance((Project)ClangdCaretPanel.access$getProject$p(this.this$0.ClangdCaretPanel.this)).getPsiFile(ViewUpdate.access$getDocument$p(this.this$0));
                }
            });
            Object object = virtualFile = psiFile2 != null ? psiFile2.getVirtualFile() : null;
            if (virtualFile != null) {
                try {
                    void gotoResult;
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    objectRef.element = "";
                    service.gotoDefinition(virtualFile, this.offset, (ClangResultConsumer)new ClangResultConsumer<List<ClangSym>, Exception>((Ref.ObjectRef)gotoResult){
                        final /* synthetic */ Ref.ObjectRef $gotoResult;

                        public final void consume(@NotNull ClangResult<List<ClangSym>> it) {
                            List<ClangSym> clangSyms;
                            List<ClangSym> list = clangSyms = it.waitForResult(3000L);
                            if (list != null) {
                                Iterable $this$forEach$iv = list;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    ClangSym it2 = (ClangSym)element$iv;
                                    boolean bl = false;
                                    this.$gotoResult.element = Intrinsics.stringPlus((String)((String)this.$gotoResult.element), (Object)(it2.name + " at " + it2.location.url + ':' + it2.location.position.getLine() + ':' + it2.location.position.getColumn() + '\n'));
                                }
                            }
                        }
                        {
                            this.$gotoResult = objectRef;
                        }
                    });
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, (Ref.ObjectRef)gotoResult){
                        final /* synthetic */ ViewUpdate this$0;
                        final /* synthetic */ Ref.ObjectRef $gotoResult;

                        public final void run() {
                            ClangdCaretPanel.access$getOutput$p(this.this$0.ClangdCaretPanel.this).setText(String.valueOf((String)this.$gotoResult.element));
                        }
                        {
                            this.this$0 = viewUpdate;
                            this.$gotoResult = objectRef;
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public ViewUpdate(Document document2, int offset, int hash) {
            super((Object)("USRs View Update: " + hash));
            this.document = document2;
            this.offset = offset;
        }

        public static final /* synthetic */ Document access$getDocument$p(ViewUpdate $this) {
            return $this.document;
        }
    }
}

