/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDFATuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangNamehintInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

class ClangParseResponseImpl
extends UserDataHolderBase
implements ClangParseResponse {
    @NotNull
    private final String myUrl;
    private final int myVersion;
    private final boolean myIsCancellable;
    @NotNull
    private final CompletableFuture<Boolean> myOperationState = new CompletableFuture();
    @NotNull
    private final CompletableFuture<Supplier<List<ClangDiagnostic>>> myDiagnostics = new CompletableFuture();
    @NotNull
    private final CompletableFuture<Supplier<List<ClangHighlighting>>> myHighlightings = new CompletableFuture();
    @NotNull
    private final CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> myOurTidyDiagnostics = new CompletableFuture();
    @NotNull
    private final CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> myTidyDiagnostics = new CompletableFuture();
    @NotNull
    private final CompletableFuture<Supplier<List<ClangNamehintInfo>>> myNamehints = new CompletableFuture();
    @NotNull
    private final CompletableFuture<Supplier<List<ClangDFATuple>>> myDFAInput = new CompletableFuture();

    ClangParseResponseImpl(@NotNull String url, @NotNull String path, int version, boolean isCancellable) {
        this.myUrl = url;
        this.myVersion = version;
        this.myIsCancellable = isCancellable;
        if (ClangDebugLevel.isInfoOrMore()) {
            long startTime = System.currentTimeMillis();
            String fileName = new File(path).getName();
            this.myDiagnostics.thenAccept(res -> {
                long diagnosticsCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.infoClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of diagnostics for " + fileName + " took " + diagnosticsCalculationDuration + " ms");
            });
            this.myHighlightings.thenAccept(res -> {
                long highlightingsCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.infoClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of highlightings for " + fileName + " took " + highlightingsCalculationDuration + " ms");
            });
            this.myOurTidyDiagnostics.thenAccept(res -> {
                long calculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.infoClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of our clang-tidy diagnostics for " + fileName + " took " + calculationDuration + " ms");
            });
            this.myTidyDiagnostics.thenAccept(res -> {
                long tidyDiagnosticsCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.infoClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of clang-tidy diagnostics for " + fileName + " took " + tidyDiagnosticsCalculationDuration + " ms");
            });
            this.myNamehints.thenAccept(res -> {
                long namehintCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.infoClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of clang namehints diagnostics for " + fileName + " took " + namehintCalculationDuration + " ms");
            });
        }
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @Override
    public int getVersion() {
        return Math.abs(this.myVersion);
    }

    @Override
    public boolean isCancellable() {
        return this.myIsCancellable;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> getOperationState() {
        return this.myOperationState;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getDiagnostics() {
        return this.myDiagnostics;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangHighlighting>>> getHighlightings() {
        return this.myHighlightings;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getOurTidyDiagnostics() {
        return this.myOurTidyDiagnostics;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getTidyDiagnostics() {
        return this.myTidyDiagnostics;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangNamehintInfo>>> getNamehints() {
        return this.myNamehints;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangDFATuple>>> getDFAInput() {
        return this.myDFAInput;
    }

    public String toString() {
        return this.getUrl() + "[" + this.getVersion() + "]";
    }
}

