/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Collections;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class ClangSaveRequest
implements ClangInteraction {
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final String myUrl;

    @NotNull
    public static ClangInteractionPromise<ClangSaveRequest> createPromise(@NotNull ClangDaemonContext context2, @NotNull String url) {
        return new ClangInteractionPromiseImpl.Builder<ClangSaveRequest>(new ClangSaveRequest(context2, url)).setWriteAccessedProperties(Collections.singletonList(Pair.create((Object)url, (Object)((Object)ClangProperty.SavedFlag)))).create();
    }

    private ClangSaveRequest(@NotNull ClangDaemonContext context2, @NotNull String url) {
        this.myContext = context2;
        this.myUrl = url;
    }

    @Override
    public void send(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        server.clionDidSave(new DidSaveTextDocumentParams(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(this.myUrl))));
        this.toNextRemoteState(ws);
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        this.toNextRemoteState(ws);
    }

    private void toNextRemoteState(@NotNull ClangRemoteWorkspace ws) {
        ws.modify(this.myUrl, wf -> {
            wf.put(RemoteWorkspaceFile.IS_SAVED, true);
            if (!wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED).booleanValue()) {
                wf.put(RemoteWorkspaceFile.CONTENT, null);
            }
        });
    }
}

