/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangHeavyRequestBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangReparseNotification
extends ClangFileBasedNotification<ReparseData> {
    @NotNull
    private final ClangParseResponse myResponse;
    @NotNull
    private final String myMacrosUrl;
    private final int myMacrosVersion;
    @NotNull
    private final String myMacroDefinitions;

    @NotNull
    public static ClangInteractionPromise<ClangReparseNotification> createPromise(@NotNull ClangHeavyRequestBuilder builder2, @NotNull ClangDaemonContext context2, @NotNull VirtualFile virtualFile, @NotNull ClangParseResponse response, @NotNull String macrosUrl, int macrosVersion) {
        CompletableFuture<ClangReparseNotification> futureRequest = builder2.later(() -> ClangReparseNotification.create(context2, virtualFile, response, macrosUrl, macrosVersion));
        return new ClangInteractionPromiseImpl.Builder<ClangReparseNotification>(ClangReparseNotification.class, futureRequest).addReadAccessedProperties(response.getUrl(), ClangProperty.Content).addReadAccessedProperties(ClangRequestsHelper.getMacrosFileUrl(context2, response.getUrl()), ClangProperty.Content).addWriteAccessedProperties(response.getUrl(), ClangProperty.Ast).addRejectedHandler(() -> ClangLanguageServiceUtils.finishOperation(response, false)).create();
    }

    @Nullable
    private static ClangReparseNotification create(@NotNull ClangDaemonContext context2, @NotNull VirtualFile virtualFile, @NotNull ClangParseResponse response, @NotNull String macrosUrl, int macrosVersion) {
        if (context2.getProject().isDisposed()) {
            return null;
        }
        Project project2 = context2.getProject();
        String url = response.getUrl();
        int version = response.getVersion();
        boolean cancellable = response.isCancellable();
        if (ClangRequestsHelper.isAllowedByGuard(context2, url)) {
            String macros;
            ClionCompileCommandParams compileParams;
            Trustworthiness trustworthiness;
            String macrosPath = context2.getUrlConverter().fromUri(context2.getUrlConverter().toUri(macrosUrl));
            ClangdCompilationCommand cc = context2.getIdeFacade().getCompilationCommand(context2.getUrlConverter(), project2, virtualFile, macrosPath);
            if (cc != null) {
                trustworthiness = cc.trustworthiness;
                compileParams = cc.ccParams;
                macros = cc.ppDefines;
            } else {
                trustworthiness = new Trustworthiness(1);
                String targetURI = context2.getUrlConverter().toUri(virtualFile.getUrl());
                compileParams = new ClionCompileCommandParams(targetURI, targetURI, "", Collections.emptyList(), "/dev/null");
                macros = "";
            }
            if (compileParams.getCommandLine().stream().noneMatch(arg -> arg.startsWith("--target="))) {
                trustworthiness = trustworthiness.add(4);
            }
            response.putUserData(ClangParseResponse.TRUSTWORTHINESS, trustworthiness);
            ClionClangTidyConfigParams clangTidyConfig = context2.getIdeFacade().getClangTidyConfig(project2, virtualFile);
            ClionClangNamehintConfigParams clangNamehintConfig = context2.getIdeFacade().getNamehintConfig();
            UnusedIncludesInspectionMode unusedInspectionMode = context2.getIdeFacade().getUnusedIncludesInspectionMode(project2, virtualFile);
            ClionWantDiagnostics WantDiags = cancellable ? ClionWantDiagnostics.Auto : ClionWantDiagnostics.Yes;
            boolean isDFAEnabled = context2.getIdeFacade().isDFAEnabled(project2, virtualFile);
            VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
            docId.setUri(context2.getUrlConverter().toUri(url));
            docId.setVersion(Integer.valueOf(version));
            ClionReparseTextDocumentParams params = new ClionReparseTextDocumentParams(docId, compileParams, clangTidyConfig, clangNamehintConfig, unusedInspectionMode, WantDiags, isDFAEnabled);
            if (!ClangReparseNotification.areNamehintsEnabled(clangNamehintConfig)) {
                response.getNamehints().complete(null);
            }
            ReparseData reparseData = new ReparseData(context2, url, params);
            return new ClangReparseNotification(context2, response, reparseData, macrosUrl, macrosVersion, StringUtil.notNullize((String)macros));
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            CidrLogService.logOnce(Level.WARNING, "File [" + url + "] was banned!", new Exception());
        }
        return null;
    }

    private ClangReparseNotification(@NotNull ClangDaemonContext context2, @NotNull ClangParseResponse response, @NotNull ReparseData data, @NotNull String macrosUrl, int macrosVersion, @NotNull String macroDefinitions) {
        super(context2, response.getUrl(), response.getVersion(), true, data);
        this.myResponse = response;
        this.myMacrosUrl = macrosUrl;
        this.myMacrosVersion = macrosVersion;
        this.myMacroDefinitions = macroDefinitions;
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        assert (ws.isOpenedRemotely(this.myUrl));
        if (ClangDebugLevel.isWarnOrMore()) {
            ClangUtils.warnClangd(LOG, "Reparsing file " + this.myUrl + " of version " + ((ReparseData)this.myParams).params.getTextDocument().getVersion());
        }
        this.myContext.getTelemetry().getGeneralTelemetry().notifyReparseSent(this);
        String prevMacrosContent = ws.apply(this.myMacrosUrl, rf -> rf.getContent());
        if (!Objects.equals(prevMacrosContent, this.myMacroDefinitions)) {
            VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
            docId.setUri(this.myContext.getUrlConverter().toUri(this.myMacrosUrl));
            docId.setVersion(Integer.valueOf(this.myMacrosVersion));
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(this.myMacroDefinitions);
            ClangChangeNotification.create(this.myContext, this.myMacrosUrl, this.myMacrosVersion, new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent)), false).send(server, ws);
        }
        if (ClangReparseNotification.doSend(server, (ReparseData)this.myParams)) {
            ClangLanguageServiceUtils.finishOperation(this.myResponse, true);
            return true;
        }
        return false;
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        super.onSkipped(ws);
        ClangLanguageServiceUtils.finishOperation(this.myResponse, false);
    }

    @Override
    public void onRejected() {
        super.onRejected();
        ClangLanguageServiceUtils.finishOperation(this.myResponse, false);
    }

    @Override
    protected void toNextRemoteState(@NotNull ClangRemoteWorkspace ws, @NotNull ReparseData params) {
        super.toNextRemoteState(ws, params);
        this.myResponse.putUserData(ClangParseResponse.UNSAVED_FILES, ws.getUnsavedFiles());
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull ReparseData params) {
        super.toNextRemoteState(wf, params);
        wf.put(RemoteWorkspaceFile.REMOTE_COMPILATION_COMMAND, params.params);
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull ReparseData data) {
        server.clionReparse(data.params);
        return true;
    }

    private static boolean areNamehintsEnabled(@Nullable ClionClangNamehintConfigParams params) {
        return params != null && params.isEnableNamehints();
    }

    static class ReparseData {
        @NotNull
        public final ClangDaemonContext context;
        @NotNull
        public final String url;
        @NotNull
        public final ClionReparseTextDocumentParams params;

        ReparseData(@NotNull ClangDaemonContext context2, @NotNull String url, @NotNull ClionReparseTextDocumentParams params) {
            this.context = context2;
            this.url = url;
            this.params = params;
        }
    }
}

