/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangFormatRangeRequest
extends ClangAbstractRequest<DocumentRangeFormattingParams, List<ClangLineColReplace>> {
    @NotNull
    private final String myUrl;

    @NotNull
    public static ClangInteractionPromise<ClangFormatRangeRequest> createPromise(@NotNull ClangFormatRangeRequest request) {
        return new ClangInteractionPromiseImpl.Builder<ClangFormatRangeRequest>(request).addReadAccessedProperties(request.myUrl, ClangProperty.Content).create();
    }

    public ClangFormatRangeRequest(@NotNull String url, @NotNull DocumentRangeFormattingParams params) {
        super(params);
        this.myUrl = url;
    }

    @Override
    @Nullable
    protected CompletableFuture<List<ClangLineColReplace>> sendRequest(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        return server.getTextDocumentService().rangeFormatting((DocumentRangeFormattingParams)this.myParams).thenApply(textEdits -> ContainerUtil.map((Collection)textEdits, te -> new ClangLineColReplace((TextEdit)te)));
    }
}

