/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import org.jetbrains.annotations.NotNull;

public abstract class ClangFileBasedNotification<T>
extends ClangAbstractNotification<T> {
    @NotNull
    protected final ClangDaemonContext myContext;
    @NotNull
    protected final String myUrl;
    protected final int myVersion;
    private final boolean myShouldRecover;

    ClangFileBasedNotification(@NotNull ClangDaemonContext context2, @NotNull String url, int version, boolean shouldRecover, @NotNull T params) {
        super(params);
        this.myContext = context2;
        this.myUrl = url;
        this.myVersion = version;
        this.myShouldRecover = shouldRecover;
    }

    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    public int getVersion() {
        return this.myVersion;
    }

    @Override
    public boolean requiresRecover() {
        return this.myShouldRecover;
    }

    @Override
    protected boolean sendNotification(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (this.sendNotificationImpl(server, ws)) {
            this.toNextRemoteState(ws, this.myParams);
            return true;
        }
        return false;
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        this.toNextRemoteState(ws, this.myParams);
    }

    protected abstract boolean sendNotificationImpl(@NotNull ClangServer var1, @NotNull ClangRemoteWorkspace var2);

    protected void toNextRemoteState(@NotNull ClangRemoteWorkspace ws, @NotNull T params) {
        ws.modify(this.myUrl, wf -> {
            int prevVersion = wf.getOrDefault(RemoteWorkspaceFile.VERSION);
            Class<?> prevOpClass = wf.get(RemoteWorkspaceFile.OP_CLASS);
            if (this.myVersion <= prevVersion) {
                LOG.error("Wrong order of operations: prevVersion = " + prevVersion + ", prevOp = " + (prevOpClass != null ? prevOpClass.getSimpleName() : "unknown") + ", newVersion = " + this.myVersion + ", newOp = " + this.getClass().getSimpleName() + (ClangRequestsHelper.isMacroFile(this.myContext, wf.getUrl()) ? ", for macros file" : ""));
            } else {
                wf.put(RemoteWorkspaceFile.VERSION, this.myVersion);
                wf.put(RemoteWorkspaceFile.OP_CLASS, this.getClass());
                this.toNextRemoteState((RemoteWorkspaceFile)wf, params);
            }
        });
    }

    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull T params) {
    }
}

