/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidCloseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class ClangCloseNotification
extends ClangFileBasedNotification<ClionDidCloseTextDocumentParams> {
    @NotNull
    public static ClangInteractionPromise<ClangCloseNotification> createPromise(@NotNull ClangDaemonContext context2, @NotNull String url, int version, @NotNull String closedContent, boolean isSaved) {
        return new ClangInteractionPromiseImpl.Builder<ClangCloseNotification>(ClangCloseNotification.create(context2, url, version, closedContent, isSaved)).addWriteAccessedProperties(url, ClangProperty.Ast, ClangProperty.Content, ClangProperty.SavedFlag).create();
    }

    @NotNull
    public static ClangCloseNotification create(@NotNull ClangDaemonContext context2, @NotNull String url, int version, @NotNull String closedContent, boolean isSaved) {
        ClionDidCloseTextDocumentParams params = new ClionDidCloseTextDocumentParams(new TextDocumentIdentifier(context2.getUrlConverter().toUri(url)), closedContent, isSaved, version);
        return new ClangCloseNotification(context2, url, version, params);
    }

    private ClangCloseNotification(@NotNull ClangDaemonContext context2, @NotNull String url, int version, @NotNull ClionDidCloseTextDocumentParams params) {
        super(context2, url, version, false, params);
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        server.clionDidClose((ClionDidCloseTextDocumentParams)((Object)this.myParams));
        return true;
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull ClionDidCloseTextDocumentParams params) {
        super.toNextRemoteState(wf, params);
        wf.put(RemoteWorkspaceFile.IS_OPENED, false);
        wf.put(RemoteWorkspaceFile.IS_SAVED, params.isSaved());
        wf.put(RemoteWorkspaceFile.CONTENT, !params.isSaved() ? params.getText() : null);
    }
}

