/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidChangeTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.jetbrains.annotations.NotNull;

public class ClangChangeNotification
extends ClangFileBasedNotification<ClionDidChangeTextDocumentParams> {
    @NotNull
    public static ClangInteractionPromise<ClangChangeNotification> createPromise(@NotNull ClangDaemonContext context2, @NotNull String url, int version, @NotNull DidChangeTextDocumentParams params, boolean isSaved) {
        return new ClangInteractionPromiseImpl.Builder<ClangChangeNotification>(ClangChangeNotification.create(context2, url, version, params, isSaved)).addWriteAccessedProperties(url, ClangProperty.Ast, ClangProperty.Content, ClangProperty.SavedFlag).setImmediate(false).create();
    }

    @NotNull
    public static ClangChangeNotification create(@NotNull ClangDaemonContext context2, @NotNull String url, int version, @NotNull DidChangeTextDocumentParams params, boolean isSaved) {
        ClionDidChangeTextDocumentParams clangParams = new ClionDidChangeTextDocumentParams(params.getTextDocument(), params.getContentChanges(), isSaved, params.getTextDocument().getVersion());
        return new ClangChangeNotification(context2, url, version, clangParams);
    }

    private ClangChangeNotification(@NotNull ClangDaemonContext context2, @NotNull String url, int version, @NotNull ClionDidChangeTextDocumentParams params) {
        super(context2, url, version, false, params);
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        return ClangChangeNotification.doSend(server, (ClionDidChangeTextDocumentParams)((Object)this.myParams));
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull ClionDidChangeTextDocumentParams params) {
        super.toNextRemoteState(wf, params);
        assert (params.getContentChanges().size() == 1) : "Fixme!";
        String content = ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText();
        wf.put(RemoteWorkspaceFile.CONTENT, content);
        wf.put(RemoteWorkspaceFile.IS_SAVED, params.isSaved());
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull ClionDidChangeTextDocumentParams params) {
        server.clionDidChange(params);
        return true;
    }
}

