/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory;

import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDogListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class ClangMemoryUsageWatchDogImpl
implements ClangMemoryUsageWatchDog,
ClangServerListener,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)ClangMemoryUsageWatchDog.class.getName());
    private static final int DELAY = 10000;
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final ClangLanguageService myService;
    @NotNull
    private final ScheduledFuture<?> myFuture;

    public ClangMemoryUsageWatchDogImpl(final @NotNull ClangDaemonContext context2, @NotNull ClangLanguageService service) {
        this.myContext = context2;
        this.myService = service;
        Disposer.register((Disposable)context2, (Disposable)this);
        ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue().addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (context2.canPublishMessage()) {
                    ((ClangMemoryUsageWatchDogListener)context2.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onMaxMemoryChanged(ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(value));
                }
            }
        }, (Disposable)context2);
        context2.getMessageBus().connect().subscribe(ClangServerListener.TOPIC, (Object)this);
        this.myFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::requestState, 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getMaxMemory() {
        return ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue());
    }

    @Override
    public void onServerFailure() {
        this.reportMemoryUsed(0L);
    }

    @Override
    public void onServerShutDown() {
        this.reportMemoryUsed(0L);
    }

    private void requestState() {
        if (ClangMemoryUsageWatchDogImpl.isEnabled()) {
            try {
                ClangMemoryUsageInfo memoryUsage = ClangUtils.waitCancelAware(this.myService.debugDumpMemoryStat(), 10000L, "memory stats");
                if (memoryUsage != null) {
                    long workingSet = Long.valueOf(memoryUsage.getWorkingSet()) * 1024L;
                    long maxMemory = this.getMaxMemory();
                    if (ClangMemoryUsageWatchDogImpl.isEnabled() && workingSet > maxMemory) {
                        this.myService.shutDownServer();
                        LOG.warn("Server was restarted because the memory limit was exceeded: " + workingSet / 0x100000L + "M used of " + maxMemory / 0x100000L + "M");
                        FUCounterUsageLogger.getInstance().logEvent("oc.clangd.memoryLimitExceedances", "total");
                    }
                    this.reportMemoryUsed(workingSet);
                }
            }
            catch (ExecutionException ex) {
                LOG.warn((Throwable)ex);
            }
            catch (TimeoutException ex) {
                LOG.warn("Timeout when getting memory stats");
            }
        }
    }

    public void dispose() {
        this.myFuture.cancel(true);
        this.reportMemoryUsed(0L);
    }

    private void reportMemoryUsed(long howMuch) {
        if (this.myContext.canPublishMessage()) {
            ((ClangMemoryUsageWatchDogListener)this.myContext.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onUsedMemoryChanged(howMuch);
        }
    }

    private static boolean isEnabled() {
        return ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue()) > 0L;
    }

    private static long getMaxMemoryImpl(@NotNull RegistryValue value) {
        return Long.valueOf(value.asInteger()) * 0x100000L;
    }

    @NotNull
    private static RegistryValue getMaxMemoryRegistryValue() {
        return Registry.get((String)"clion.clangd.max.memory");
    }
}

