/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangResolveUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClionXRefAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)ClionXRefAction.class.getName());
    private static final boolean INCLUDE_PARSE_TIME = false;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 != null) {
            AtomicLong totalClangTime = new AtomicLong();
            AtomicLong totalClionTime = new AtomicLong();
            Stream<VirtualFile> files = this.getFiles(project2, e.getDataContext()).stream().limit(Registry.get((String)"clion.clang.xref.limit").asInteger());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project2);
                files.forEach(file2 -> {
                    PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project2).findFile(file2));
                    if (OCLanguageUtils.isSupported(psiFile)) {
                        SimpleOpenRequestId temporaryOpenId = new SimpleOpenRequestId(ClionXRefAction.class, "XRef action for " + file2.getPath());
                        try {
                            service.notifyDocumentOpened((VirtualFile)file2, temporaryOpenId);
                            AtomicInteger clionRefsCounter = new AtomicInteger();
                            Runnable clionXRef = () -> new XRefVisitor(true, clionRefsCounter).visitFile(psiFile);
                            AtomicInteger clangRefsCounter = new AtomicInteger();
                            Runnable clangXRef = () -> new XRefVisitor(false, clangRefsCounter).visitFile(psiFile);
                            LOG.warn("START CLION XREF [" + file2.getName() + "] ");
                            WriteAction.runAndWait(() -> {
                                PsiManager.getInstance((Project)project2).dropPsiCaches();
                                PsiManager.getInstance((Project)project2).dropResolveCaches();
                            });
                            ClangUtils.forceClangdNavigationOff(project2);
                            long clionTime = ClionXRefAction.measure(clionXRef);
                            LOG.warn("START CLANG XREF [" + file2.getName() + "] ");
                            WriteAction.runAndWait(() -> {
                                PsiManager.getInstance((Project)project2).dropPsiCaches();
                                PsiManager.getInstance((Project)project2).dropResolveCaches();
                            });
                            long clangTime = service.computeWithParsed((VirtualFile)file2, response -> {
                                try {
                                    long result2;
                                    if (response != null) {
                                        LOG.warn("REPARSING FILE [" + file2.getName() + "] WITH CLANG (this time is excluded from results)");
                                        response.getDiagnostics().get();
                                        response.getTidyDiagnostics().get();
                                        response.getOurTidyDiagnostics().get();
                                        response.getNamehints().get();
                                        LOG.warn("REPARSING FINISHED");
                                        ClangUtils.forceClangdNavigationOn(project2);
                                        result2 = ClionXRefAction.measure(clangXRef);
                                        ClangUtils.stopForcingClangdNavigation(project2);
                                    } else {
                                        LOG.warn("Failed to reparse [" + file2.getName() + "]");
                                        result2 = clionTime;
                                    }
                                    return result2;
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    throw new RuntimeException(ex);
                                }
                            });
                            LOG.warn("File [" + file2.getName() + "]: clang(" + clangRefsCounter.get() + " refs) " + clangTime + "ms vs clion(" + clionRefsCounter.get() + " refs) " + clionTime + "ms");
                            totalClangTime.addAndGet(clangTime);
                            totalClionTime.addAndGet(clionTime);
                        }
                        catch (Exception ex) {
                            LOG.error((Throwable)ex);
                        }
                        finally {
                            service.notifyDocumentClosed((VirtualFile)file2, temporaryOpenId);
                        }
                    }
                });
                LOG.warn("Total: clang " + totalClangTime.get() + "ms vs clion " + totalClionTime.get() + "ms");
                if (totalClangTime.get() <= totalClionTime.get()) {
                    LOG.warn("Clang saved " + (totalClionTime.get() - totalClangTime.get()) + "ms");
                } else {
                    LOG.warn("Clang used " + (totalClangTime.get() - totalClionTime.get()) + "ms more");
                }
            });
        }
    }

    @NotNull
    protected Collection<VirtualFile> getFiles(@NotNull Project project2, @NotNull DataContext context2) {
        return OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project2);
    }

    private static long measure(@NotNull Runnable what) {
        return (Long)ReadAction.compute(() -> {
            long before2 = System.currentTimeMillis();
            what.run();
            long after2 = System.currentTimeMillis();
            return after2 - before2;
        });
    }

    private static class XRefVisitor
    extends PsiRecursiveElementVisitor {
        final AtomicInteger myRefCounter;
        final boolean myTrueResolve;

        private XRefVisitor(boolean trueResolve, @Nullable AtomicInteger refCounter) {
            this.myTrueResolve = trueResolve;
            this.myRefCounter = refCounter;
        }

        public void visitElement(@NotNull PsiElement element) {
            OCReferenceElementImpl ref = null;
            if (element instanceof OCReferenceElementImpl) {
                ref = (OCReferenceElementImpl)element;
            } else if (element instanceof OCQualifiedExpressionImpl) {
                ref = element.getReference();
            } else {
                PsiReference elementRef = element.getReference();
                if (elementRef instanceof OCOperatorReference) {
                    ref = elementRef;
                }
            }
            if (ref != null) {
                if (this.myRefCounter != null) {
                    this.myRefCounter.incrementAndGet();
                }
                if (this.myTrueResolve) {
                    ref.resolve();
                } else {
                    ClangResolveUtils.findTargetSymbolViaClang(ref);
                }
            }
            super.visitElement(element);
        }
    }
}

