/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdRequestsPlanner {
    static final int DEFAULT_PATIENT_SEND_DELAY_SEC = 10;
    private static final Logger LOG = Logger.getInstance((String)ClangdRequestsPlanner.class.getName());
    @NotNull
    private final ClangServerAccessor myServerAccessor;
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final AtomicBoolean myIsStopped = new AtomicBoolean(false);
    @NotNull
    private final LinkedList<ClangRequestTask> myQueue = new LinkedList();
    @NotNull
    private final AtomicBoolean myExecutorMonitor = new AtomicBoolean(false);
    @Nullable
    private final ScheduledFuture<?> myTimerFuture;

    public ClangdRequestsPlanner(@NotNull String descriptor, @NotNull ClangServerAccessor serverAccessor) {
        this(descriptor, serverAccessor, 10);
    }

    public ClangdRequestsPlanner(@NotNull String descriptor, @NotNull ClangServerAccessor serverAccessor, int patientSendDelaySeconds) {
        this.myServerAccessor = serverAccessor;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("ClangdRequestsPlanner [" + descriptor + "]"));
        this.myExecutorService.execute(new ExecutorRunnable());
        this.myTimerFuture = patientSendDelaySeconds > 0 ? AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::notifyExecutor, patientSendDelaySeconds, patientSendDelaySeconds, TimeUnit.SECONDS) : null;
    }

    @NotNull
    ClangServerAccessor getServerAccessor() {
        return this.myServerAccessor;
    }

    @NotNull
    Future<Boolean> send(@Nullable ClangInteractionPromise<?> promise) {
        if (promise != null) {
            ClangRequestTask requestTask = ClangdRequestsPlanner.createTask(promise);
            this.addTask(requestTask);
            if (requestTask.isImmediateTask()) {
                this.notifyExecutor();
            }
            return requestTask.getTaskFuture();
        }
        return CompletableFuture.completedFuture(false);
    }

    void sendImmediately(@NotNull ClangInteraction request) {
        this.myServerAccessor.post(request);
    }

    void waitUntilTasksFinished() {
        assert (this.myServerAccessor.isRunningSynchronously() || !ApplicationManager.getApplication().isWriteAccessAllowed()) : "Holding write lock here can result in a deadlock, because there could be pending tasks requiring read lock!";
        CompletableFuture waitFuture = new CompletableFuture();
        ClangInteraction waitRequest = ClangInteraction.newInteraction("Wait").action((Consumer<? super ClangServer>)((Consumer)server -> waitFuture.complete(null))).onSkipped(() -> waitFuture.complete(null)).create();
        ClangInteractionPromise<ClangInteraction> waitPromise = new ClangInteractionPromiseImpl.Builder<ClangInteraction>(waitRequest).setRearrangeable(false).create();
        this.addTask(new ClangRequestTask(waitPromise));
        this.notifyExecutor();
        try {
            waitFuture.get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    ClangStopData stop() {
        this.myIsStopped.set(true);
        if (this.myTimerFuture != null) {
            this.myTimerFuture.cancel(true);
        }
        this.notifyExecutor();
        this.myExecutorService.shutdown();
        return this.myServerAccessor.stop();
    }

    @NotNull
    private static ClangRequestTask createTask(@NotNull ClangInteractionPromise<?> clangRequestPromise) {
        if (clangRequestPromise.getInteractionClass().equals(ClangChangeNotification.class)) {
            return new ClangChangeFileTask(clangRequestPromise);
        }
        return new ClangRequestTask(clangRequestPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(@NotNull ClangRequestTask task2) {
        LinkedList<ClangRequestTask> linkedList = this.myQueue;
        synchronized (linkedList) {
            ClangRequestTask queued;
            ListIterator<ClangRequestTask> iterator2 = this.myQueue.listIterator(this.myQueue.size());
            while (iterator2.hasPrevious() && task2.canEat(queued = iterator2.previous())) {
                queued.onRejected();
                iterator2.remove();
            }
            this.myQueue.add(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<ClangRequestTask> takeTasks() {
        LinkedList<ClangRequestTask> linkedList = this.myQueue;
        synchronized (linkedList) {
            ArrayList<ClangRequestTask> toProcess = new ArrayList<ClangRequestTask>(this.myQueue);
            this.myQueue.clear();
            return toProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEvent() {
        AtomicBoolean atomicBoolean = this.myExecutorMonitor;
        synchronized (atomicBoolean) {
            while (!this.myExecutorMonitor.get()) {
                try {
                    this.myExecutorMonitor.wait();
                }
                catch (InterruptedException ex) {
                    LOG.warn((Throwable)ex);
                    break;
                }
            }
            this.myExecutorMonitor.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExecutor() {
        AtomicBoolean atomicBoolean = this.myExecutorMonitor;
        synchronized (atomicBoolean) {
            this.myExecutorMonitor.set(true);
            this.myExecutorMonitor.notifyAll();
        }
    }

    private static class DependenciesManager {
        private static final Function<String, Set<ClangProperty>> EMPTY_PROPERTY_SET = u -> EnumSet.noneOf(ClangProperty.class);
        private boolean hasRequests = false;
        private boolean hasNotRearrangeable = false;
        @NotNull
        private final Map<String, Set<ClangProperty>> myReadAccessedProperties = new HashMap<String, Set<ClangProperty>>();
        @NotNull
        private final Map<String, Set<ClangProperty>> myWriteAccessedProperties = new HashMap<String, Set<ClangProperty>>();

        private DependenciesManager() {
        }

        void mergeNext(@NotNull ClangInteractionPromise<?> promise) {
            List<Pair<String, ClangProperty>> writeProperties;
            List<Pair<String, ClangProperty>> readProperties;
            if (!promise.isRearrangeable()) {
                this.hasNotRearrangeable = true;
            }
            if ((readProperties = promise.getReadProperties()) != null) {
                for (Pair<String, ClangProperty> urlAndProperty : readProperties) {
                    Set<ClangProperty> properties = this.myReadAccessedProperties.computeIfAbsent((String)urlAndProperty.first, EMPTY_PROPERTY_SET);
                    properties.add((ClangProperty)((Object)urlAndProperty.second));
                }
            }
            if ((writeProperties = promise.getWrittenProperties()) != null) {
                for (Pair<String, ClangProperty> urlAndProperty : writeProperties) {
                    Set<ClangProperty> properties = this.myWriteAccessedProperties.computeIfAbsent((String)urlAndProperty.first, EMPTY_PROPERTY_SET);
                    properties.add((ClangProperty)((Object)urlAndProperty.second));
                }
            }
            this.hasRequests = true;
        }

        boolean isDependent(@NotNull ClangInteractionPromise<?> promise) {
            if (this.hasRequests && !promise.isRearrangeable()) {
                return true;
            }
            if (this.hasNotRearrangeable) {
                return true;
            }
            if (promise.getReadProperties() != null) {
                for (Pair<String, ClangProperty> urlAndProperty : promise.getReadProperties()) {
                    Set<ClangProperty> writeProperties = this.myWriteAccessedProperties.get(urlAndProperty.first);
                    if (writeProperties == null || !writeProperties.contains(urlAndProperty.second)) continue;
                    return true;
                }
            }
            if (promise.getWrittenProperties() != null) {
                for (Pair<String, ClangProperty> urlAndProperty : promise.getWrittenProperties()) {
                    Set<ClangProperty> readProperties = this.myReadAccessedProperties.get(urlAndProperty.first);
                    if (readProperties != null && readProperties.contains(urlAndProperty.second)) {
                        return true;
                    }
                    Set<ClangProperty> writeProperties = this.myWriteAccessedProperties.get(urlAndProperty.first);
                    if (writeProperties == null || !writeProperties.contains(urlAndProperty.second)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class ExecutorRunnable
    implements Runnable {
        @NotNull
        private final Set<ClangRequestTask> myKnownStuckTasks = Collections.newSetFromMap(new IdentityHashMap());

        private ExecutorRunnable() {
        }

        @Override
        public void run() {
            try {
                LinkedList executorQueue = new LinkedList();
                while (true) {
                    List<ClangRequestTask> stuckTasks;
                    ClangdRequestsPlanner.this.waitForEvent();
                    if (ClangdRequestsPlanner.this.myIsStopped.get()) break;
                    List newTasks = ClangdRequestsPlanner.this.takeTasks();
                    executorQueue.addAll(newTasks);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Taken " + newTasks.size() + " new tasks to execute. Total tasks pool is " + executorQueue.size());
                    }
                    if ((stuckTasks = this.sendPending(executorQueue.iterator())) != null) {
                        assert (!executorQueue.isEmpty());
                        for (ClangRequestTask stuckTask : stuckTasks) {
                            if (this.myKnownStuckTasks.contains(stuckTask)) continue;
                            this.myKnownStuckTasks.add(stuckTask);
                            stuckTask.getRequestPromise().getInteraction().whenComplete((res, resEx) -> ClangdRequestsPlanner.this.notifyExecutor());
                        }
                    }
                    this.myKnownStuckTasks.removeIf(ClangRequestTask::isReady);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Currently there are " + this.myKnownStuckTasks.size() + " known stuck tasks");
                }
                for (ClangRequestTask task2 : executorQueue) {
                    task2.onRejected();
                }
            }
            catch (Throwable ex) {
                LOG.error(ex);
            }
        }

        @Nullable
        private List<ClangRequestTask> sendPending(@NotNull Iterator<ClangRequestTask> iterator2) {
            ArrayList<ClangRequestTask> stuckRequests = null;
            DependenciesManager dependencies = new DependenciesManager();
            while (iterator2.hasNext()) {
                ClangRequestTask task2 = iterator2.next();
                if (dependencies.isDependent(task2.getRequestPromise())) {
                    dependencies.mergeNext(task2.getRequestPromise());
                    continue;
                }
                if (!this.trySendOne(task2)) {
                    dependencies.mergeNext(task2.getRequestPromise());
                    if (stuckRequests == null) {
                        stuckRequests = new ArrayList<ClangRequestTask>();
                    }
                    stuckRequests.add(task2);
                    continue;
                }
                iterator2.remove();
            }
            return stuckRequests;
        }

        private boolean trySendOne(@NotNull ClangRequestTask task2) {
            CompletableFuture futureRequest = task2.getRequestPromise().getInteraction();
            try {
                ClangInteraction request = (ClangInteraction)futureRequest.get(100L, TimeUnit.MILLISECONDS);
                if (request != null && !task2.getTaskFuture().isCancelled()) {
                    CompletableFuture<Boolean> post = ClangdRequestsPlanner.this.myServerAccessor.post(request);
                    if (post == null) {
                        task2.onRejected();
                    } else {
                        ClangUtils.tie(task2.getTaskFuture(), post);
                    }
                } else {
                    task2.onRejected();
                }
                return true;
            }
            catch (TimeoutException ex) {
                return false;
            }
            catch (CancellationException ex) {
                task2.onRejected();
                return true;
            }
            catch (ExecutionException ex) {
                if (!(ex.getCause() instanceof ControlFlowException)) {
                    LOG.warn((Throwable)ex);
                }
                task2.onRejected();
                return true;
            }
            catch (Throwable thr) {
                LOG.warn(thr);
                task2.onRejected();
                return true;
            }
        }
    }

    private static class ClangChangeFileTask
    extends ClangRequestTask {
        ClangChangeFileTask(@NotNull ClangInteractionPromise<?> requestPromise) {
            super(requestPromise);
        }

        @Override
        protected boolean canEat(@NotNull ClangRequestTask other) {
            if (!(other instanceof ClangChangeFileTask)) {
                return false;
            }
            if (!this.myRequestPromise.getInteraction().isDone() || !other.myRequestPromise.getInteraction().isDone()) {
                return false;
            }
            ClangInteraction request = (ClangInteraction)ClangUtils.getIfCompletedNormally(this.myRequestPromise.getInteraction());
            ClangInteraction otherRequest = (ClangInteraction)ClangUtils.getIfCompletedNormally(other.myRequestPromise.getInteraction());
            assert (request instanceof ClangChangeNotification && otherRequest instanceof ClangChangeNotification);
            ClangChangeNotification change = (ClangChangeNotification)request;
            ClangChangeNotification otherChange = (ClangChangeNotification)otherRequest;
            return change.getUrl().contentEquals(otherChange.getUrl()) && change.getVersion() >= otherChange.getVersion();
        }
    }

    private static class ClangRequestTask {
        @NotNull
        private final CompletableFuture<Boolean> myTaskFuture = new CompletableFuture();
        @NotNull
        protected final ClangInteractionPromise<?> myRequestPromise;

        ClangRequestTask(@NotNull ClangInteractionPromise<?> requestPromise) {
            this.myRequestPromise = requestPromise;
        }

        @NotNull
        private ClangInteractionPromise<?> getRequestPromise() {
            return this.myRequestPromise;
        }

        @NotNull
        private CompletableFuture<Boolean> getTaskFuture() {
            return this.myTaskFuture;
        }

        protected boolean isImmediateTask() {
            return this.myRequestPromise.isImmediate();
        }

        protected final boolean isReady() {
            return this.myRequestPromise.getInteraction().isDone();
        }

        protected boolean canEat(@NotNull ClangRequestTask other) {
            return false;
        }

        protected void onRejected() {
            Runnable rejectedHandler;
            this.myTaskFuture.complete(false);
            ClangInteraction request = (ClangInteraction)ClangUtils.getIfCompletedNormally(this.myRequestPromise.getInteraction());
            if (request != null) {
                request.onRejected();
            }
            if ((rejectedHandler = this.myRequestPromise.getRejectedHandler()) != null) {
                rejectedHandler.run();
            }
        }
    }
}

