/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.CLionCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangInlayParameterHintsProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangIdeFacadeImpl
implements ClangIdeFacade {
    private static final Logger LOG = Logger.getInstance((String)ClangIdeFacadeImpl.class.getName());
    @NotNull
    private final ExecutorService myMessagingService;
    @Nullable
    private volatile OCLanguageKind myLanguageKindForH;
    private static final String[] ourPathOpts = new String[]{"--include-directory", "--include-directory-after", "--include-prefix", "--include-with-prefix", "--include-with-prefix-after", "--include-with-prefix-before"};
    private static final String[] ourPrefixPathOpts = new String[]{"-I", "--include-directory=", "-F", "-idirafter", "--include-directory-after=", "-iframework", "-iquote", "-isystem", "-iprefix", "--include-prefix=", "-iwithprefix", "--include-with-prefix-after=", "--include-with-prefix=", "-iwithprefixbefore", "--include-with-prefix-before=", "-isysroot", "-iwithsysroot", "-imacros"};

    public ClangIdeFacadeImpl(@NotNull String descriptor) {
        this.myMessagingService = ConcurrencyUtil.newSingleThreadExecutor((String)("ClangdMessagingThread [" + descriptor + "]"));
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile(@NotNull String url) {
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Override
    @Nullable
    public Document getDocument(@NotNull VirtualFile file2) {
        return FileDocumentManager.getInstance().getDocument(file2);
    }

    @Override
    @NotNull
    public List<OpenRequestId> getOpenRequests(@NotNull Project project2, @NotNull VirtualFile file2) {
        Document document2 = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (document2 != null) {
            return EditorFactory.getInstance().editors(document2).filter(editor -> editor.getProject() == project2).map(EditorOpenRequestId::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isModified(@NotNull VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager fileDocManager = FileDocumentManager.getInstance();
        return fileDocManager.isFileModified(file2);
    }

    @Override
    @Nullable
    public String getText(@NotNull VirtualFile file2) {
        Document document2 = this.getDocument(file2);
        if (document2 == null) {
            return null;
        }
        return this.getText(file2, document2);
    }

    @Override
    @NotNull
    public String getText(@NotNull VirtualFile file2, @NotNull Document document2) {
        String text = document2.getText();
        if (file2 instanceof OCFragmentVirtualFile) {
            CharSequence parentFileContent = ((OCFragmentVirtualFile)file2).getParentFileContent();
            int parentOffset = ((OCFragmentVirtualFile)file2).getParentOffset();
            return parentFileContent.subSequence(0, parentOffset) + text + parentFileContent.subSequence(parentOffset, parentFileContent.length());
        }
        return text;
    }

    @Override
    @Nullable
    public ClangdCompilationCommand getCompilationCommand(@NotNull ClangUrlConverter converter, @NotNull Project project2, @NotNull VirtualFile file2, @NotNull String pathToMacrosFile) {
        ClangUtils.ClangCompilationCommand clangCommand;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        OCPsiFile ocFile = ClangIdeFacadeImpl.getOCPsiFile(project2, file2);
        if (ocFile == null) {
            if (ClangDebugLevel.isWarnOrMore()) {
                CidrLogService.logOnce(Level.WARNING, "Failed to get OCPsiFile for file " + file2.getPath());
            }
            return null;
        }
        CLionCompilationInfo ccInfo = this.getCLionCompilationInfo(ocFile, file2);
        if (ccInfo == null) {
            if (ClangDebugLevel.isWarnOrMore()) {
                CidrLogService.logOnce(Level.WARNING, "Failed to get or create compile command for file " + file2.getPath());
            }
            return null;
        }
        try {
            clangCommand = ClangUtils.createCompilationCommand(ocFile, ccInfo, false);
        }
        catch (IOException ex) {
            LOG.error("Failed to get or create compile command for file " + file2.getPath(), (Throwable)ex);
            return null;
        }
        ArrayList<String> compilerOptions = new ArrayList<String>();
        Map userCompilationCommands = (Map)project2.getUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS);
        if (userCompilationCommands == null || !userCompilationCommands.containsKey(clangCommand.inputFile)) {
            compilerOptions.add(FileUtil.toSystemDependentName((String)clangCommand.compilerExecutable));
            compilerOptions.add("-nostdinc");
            compilerOptions.add("-nostdlib");
            compilerOptions.add("-nostdlibinc");
            compilerOptions.add("-ccc-no-implicit-pch-or-pth");
            compilerOptions.add("-clion-take-last-input");
            compilerOptions.add("-D__CLION_IDE_");
            ClangIdeFacadeImpl.addPreparedCompilerOptions(compilerOptions, clangCommand.compilerOptions);
            compilerOptions.add("-imacros" + FileUtil.toSystemDependentName((String)pathToMacrosFile));
            compilerOptions.add(FileUtil.toSystemDependentName((String)clangCommand.entryFile));
        } else {
            compilerOptions.addAll((Collection)userCompilationCommands.get(clangCommand.inputFile));
        }
        String macroDefinitions = StringUtil.isNotEmpty((String)clangCommand.preprocessorDefines) ? clangCommand.preprocessorDefines : null;
        ClionCompileCommandParams compileCommandParams = new ClionCompileCommandParams(converter.toUri(clangCommand.inputFile), converter.toUri(clangCommand.entryFile), clangCommand.workingDir, compilerOptions, "/dev/null");
        Trustworthiness trustworthiness = new Trustworthiness();
        if (ccInfo.isGuessed()) {
            trustworthiness.add(2);
        }
        return new ClangdCompilationCommand(compileCommandParams, macroDefinitions, trustworthiness);
    }

    private static void addPreparedCompilerOptions(@NotNull List<String> transformed, @NotNull List<String> original) {
        boolean nextIsPathOption = false;
        for (String option : original) {
            if (nextIsPathOption) {
                option = FileUtil.toSystemDependentName((String)option);
                nextIsPathOption = false;
            } else if (option.startsWith("-std:")) {
                option = option.replaceFirst(":", "=");
            } else {
                switch (ClangIdeFacadeImpl.getPathOptType(option)) {
                    case NextWithPath: {
                        nextIsPathOption = true;
                        break;
                    }
                    case ThisWithPath: {
                        option = FileUtil.toSystemDependentName((String)option);
                    }
                }
            }
            transformed.add(option);
        }
    }

    @NotNull
    static PathOptType getPathOptType(@NotNull String option) {
        return ClangIdeFacadeImpl.getPathOptInfo((String)option).type;
    }

    @NotNull
    static PathOptInfo getPathOptInfo(@NotNull String option) {
        if (option.equals("-I-")) {
            return new PathOptInfo(PathOptType.NotAPathOpt, "-I-");
        }
        for (String opt : ourPathOpts) {
            if (!option.equals(opt)) continue;
            return new PathOptInfo(PathOptType.NextWithPath, opt);
        }
        for (String opt : ourPrefixPathOpts) {
            if (!option.startsWith(opt)) continue;
            return new PathOptInfo(PathOptType.ThisWithPath, opt);
        }
        return new PathOptInfo(PathOptType.NotAPathOpt, option);
    }

    @Override
    @Nullable
    public UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(@NotNull Project project2, @NotNull VirtualFile file2) {
        OCPsiFile ocFile = ClangIdeFacadeImpl.getOCPsiFile(project2, file2);
        if (ocFile == null) {
            ClangUtils.warnClangd(LOG, "Failed to get OCPsiFile for file " + file2.getPath());
            return null;
        }
        return ClangIdeFacadeImpl.getUnusedIncludesInspectionMode(ocFile);
    }

    @Override
    public boolean isDFAEnabled(@NotNull Project project2, @NotNull VirtualFile file2) {
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
        return psiFile != null && OCInspectionUtil.isClangdDFAEnabled((PsiElement)psiFile);
    }

    @NotNull
    private static UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(@NotNull OCPsiFile ocFile) {
        Class<? extends OCInspection> inspectionClass = OCInspectionUtil.getUnusedInspectionClass(ocFile);
        if (!OCInspectionUtil.isInspectionEnabled(ocFile, inspectionClass)) {
            return UnusedIncludesInspectionMode.Off;
        }
        if (inspectionClass.equals(OCUnusedIncludeDirectiveInspection.class)) {
            InspectionProfileImpl inspectionProfile;
            InspectionToolWrapper tool;
            HighlightDisplayKey key;
            String shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
            HighlightDisplayKey highlightDisplayKey = key = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
            if (key != null && (tool = (inspectionProfile = InspectionProjectProfileManager.getInstance((Project)ocFile.getProject()).getCurrentProfile()).getInspectionTool(key.toString(), ocFile.getProject())) != null && tool.getTool() instanceof OCUnusedIncludeDirectiveInspection) {
                OCUnusedIncludeDirectiveInspection inspection = (OCUnusedIncludeDirectiveInspection)tool.getTool();
                if (!inspection.showInHeaders && ocFile.isHeader()) {
                    return UnusedIncludesInspectionMode.Off;
                }
                switch (inspection.strategy) {
                    case RemoveCompletelyUnused: {
                        return UnusedIncludesInspectionMode.RemoveCompletelyUnused;
                    }
                    case RemoveNotDirectlyUsed: {
                        return UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
                    }
                    case RemoveNotRequired: {
                        return UnusedIncludesInspectionMode.RemoveNotRequired;
                    }
                }
            }
        }
        return UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
    }

    @Override
    @Nullable
    public ClionClangTidyConfigParams getClangTidyConfig(@NotNull Project project2, @NotNull VirtualFile file2) {
        OCPsiFile ocFile = ClangIdeFacadeImpl.getOCPsiFile(project2, file2);
        if (ocFile == null) {
            ClangUtils.warnClangd(LOG, "Failed to get OCPsiFile for file " + file2.getPath());
            return null;
        }
        ClangTidyInspection inspection = ClangTidyUtil.getInspection(ocFile, project2);
        if (inspection == null) {
            ClangUtils.warnClangd(LOG, "Failed to get 'preferClangTidyFilesOverIDESettings' option, default one will be used");
        }
        boolean preferClangTidyFilesOverIDESettings = inspection != null && inspection.isPreferClangTidyFilesOverIDESettings();
        String clangTidyConfig = ClangIdeFacadeImpl.getClangTidyConfig(project2, ocFile, false);
        String ourClangTidyConfig = ClangIdeFacadeImpl.getClangTidyConfig(project2, ocFile, true);
        if (StringUtil.isEmpty((String)clangTidyConfig) && StringUtil.isEmpty((String)ourClangTidyConfig)) {
            return null;
        }
        return new ClionClangTidyConfigParams(ourClangTidyConfig, clangTidyConfig, preferClangTidyFilesOverIDESettings);
    }

    @Override
    @NotNull
    public ClionClangNamehintConfigParams getNamehintConfig() {
        ClangInlayParameterHintsProvider inlayProvider = ClangInlayParameterHintsProvider.Companion.getInstance();
        return new ClionClangNamehintConfigParams(inlayProvider.isEnabled(), inlayProvider.isShowHintsForEnumConstants().get(), inlayProvider.isShowHintsForConstructorExpressions().get(), inlayProvider.isShowHintsForMacroExpressions().get(), inlayProvider.isShowHintsForNonConstReferences().get());
    }

    @Override
    @Nullable
    public Long getPsiModificationCounter(@NotNull Project project2) {
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)project2);
        return psiModificationTracker != null ? Long.valueOf(psiModificationTracker.getModificationCount()) : null;
    }

    @Override
    public void sendMessageLater(@NotNull Runnable runnable) {
        if (!this.myMessagingService.isShutdown()) {
            this.myMessagingService.execute(() -> {
                while (!this.myMessagingService.isShutdown()) {
                    if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable)) {
                        return;
                    }
                    ProgressIndicatorUtils.yieldToPendingWriteActions();
                }
                return;
            });
        }
    }

    @Override
    public void stop() {
        this.myMessagingService.shutdown();
    }

    @Nullable
    private static OCPsiFile getOCPsiFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
        if (psiFile == null) {
            ClangUtils.warnClangd(LOG, "Failed to get PSI file for file: " + file2.getPath());
            return null;
        }
        OCPsiFile ocFile = OCLanguageUtils.asOCPsiFile(psiFile);
        if (ocFile == null) {
            ClangUtils.warnClangd(LOG, "PSI file is not OCPsiFile: " + file2.getPath());
            return null;
        }
        return ocFile;
    }

    @NotNull
    private static String getClangTidyConfig(@NotNull Project project2, @NotNull PsiFile file2, boolean takeOurClangTidyConfig) {
        List<ClangTidyCheckOption> forcedOptions;
        String forcedConfig = (String)project2.getUserData(takeOurClangTidyConfig ? ClangIdeFacade.CLION_CLANG_TIDY_CONFIG : ClangIdeFacade.CLANG_TIDY_CONFIG);
        List<ClangTidyCheckOption> list = forcedOptions = takeOurClangTidyConfig ? (List<ClangTidyCheckOption>)project2.getUserData(ClangIdeFacade.CLION_CLANG_TIDY_OPTIONS) : null;
        if (forcedConfig != null) {
            return ClangTidyUtil.getClangTidyConfig(forcedConfig, forcedOptions != null ? forcedOptions : Collections.emptyList());
        }
        if (!ClangUtils.isClangTidyViaClangdOn(project2) || ClangTidyUtil.getCustomClangTidyPath() != null) {
            return ClangTidyUtil.getClangTidyConfig("-*", ContainerUtil.emptyList());
        }
        if (takeOurClangTidyConfig) {
            List<OurClangTidyInspection> ourClangTidyInspections = ClangTidyUtil.getOurInspections(true, file2, project2);
            ArrayList checks = ContainerUtil.newArrayList((Object[])new String[]{"-*"});
            checks.addAll(ContainerUtil.map(ourClangTidyInspections, OurClangTidyInspection::getCheckName));
            ArrayList<ClangTidyCheckOption> checkOptions = new ArrayList<ClangTidyCheckOption>();
            for (OurClangTidyInspection inspection : ourClangTidyInspections) {
                checkOptions.addAll(inspection.getClangTidyCheckOptions());
            }
            return ClangTidyUtil.getClangTidyConfig(StringUtil.join((Collection)checks, (String)","), checkOptions);
        }
        ClangTidyInspection clangTidyInspection = ClangTidyUtil.getInspection(file2, project2);
        if (clangTidyInspection != null) {
            String checks = ClangTidyUtil.concatClangTidyChecks(clangTidyInspection.getClangTidyChecks(), "-clion-*");
            return ClangTidyUtil.getClangTidyConfig(checks, clangTidyInspection.getClangTidyCheckOptions());
        }
        return ClangTidyUtil.getClangTidyConfig("-clion-*", ContainerUtil.emptyList());
    }

    @Nullable
    private CLionCompilationInfo getCLionCompilationInfo(@NotNull OCPsiFile ocFile, @NotNull VirtualFile virtualFile) {
        Project project2 = ocFile.getProject();
        ResolveInfo resolveInfo = this.getResolveInfoForFile(project2, ocFile, virtualFile);
        if (resolveInfo == null) {
            return null;
        }
        OCResolveConfiguration configuration = resolveInfo.configuration;
        OCLanguageKind languageKind = resolveInfo.languageKind;
        VirtualFile root = resolveInfo.root;
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, root);
        OCCompilerKind compiler = compilerSettings.getCompilerKind() != null ? compilerSettings.getCompilerKind() : UnknownCompilerKind.INSTANCE;
        File compilerExecutable = compilerSettings.getCompilerExecutable() != null ? compilerSettings.getCompilerExecutable() : new File("unknown");
        File compilerWorkingDir = compilerSettings.getCompilerWorkingDir() != null ? compilerSettings.getCompilerWorkingDir() : new File("");
        List<HeadersSearchPath> headerPaths = compilerSettings.getHeadersSearchPaths();
        return new CLionCompilationInfo(project2, configuration, compilerSettings, compiler, compilerExecutable, compilerWorkingDir, root, headerPaths, languageKind, resolveInfo.guessed);
    }

    @Nullable
    private ResolveInfo getResolveInfoForFile(@NotNull Project project2, @NotNull OCPsiFile ocFile, @NotNull VirtualFile vf) {
        OCResolveConfiguration configuration = null;
        VirtualFile rootVirtualFile = null;
        OCLanguageKind languageKind = null;
        boolean guessed = false;
        if (FileSymbolTablesCache.areSymbolsLoaded(project2)) {
            try {
                OCResolveRootAndConfiguration rrAndConfig = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(vf, project2);
                configuration = rrAndConfig.getConfiguration();
                rootVirtualFile = rrAndConfig.getRootFile();
                languageKind = ocFile.getKind();
            }
            catch (ProcessCanceledException ex) {
                throw ex;
            }
            catch (Throwable thr) {
                configuration = null;
                rootVirtualFile = null;
                languageKind = null;
            }
        }
        if (configuration == null || rootVirtualFile == null || languageKind == null) {
            Collection<VirtualFile> roots2 = OCImportGraph.getInstance(project2).findAllRootsThatInclude(vf, false);
            for (VirtualFile root : roots2) {
                String extension;
                OCResolveConfiguration conf = OCInclusionContextUtil.doGetPreselectedConfiguration(root, project2);
                if (conf == null) continue;
                configuration = conf;
                rootVirtualFile = root;
                languageKind = OCLanguageKindCalculator.calculateMinimalKindByExtension(project2, root.getName());
                String string = extension = root.getExtension() != null ? root.getExtension().toLowerCase(Locale.ENGLISH) : null;
                if (extension == null || !ClangIdeFacadeImpl.isCppSource(extension) && !ClangIdeFacadeImpl.isCSource(extension)) {
                    guessed = true;
                }
                if (!Objects.equals("h", extension)) break;
                OCLanguageKind defaultKind = this.myLanguageKindForH;
                if (defaultKind == null && (defaultKind = ClangIdeFacadeImpl.detectMostFrequentSourcesKind(project2)) != null && this.myLanguageKindForH == null) {
                    this.myLanguageKindForH = defaultKind;
                }
                if (defaultKind == null) break;
                languageKind = defaultKind;
                break;
            }
        }
        if (configuration != null && rootVirtualFile != null && languageKind != null) {
            return new ResolveInfo(configuration, rootVirtualFile, languageKind, guessed);
        }
        return null;
    }

    private static boolean isCppSource(@NotNull String name) {
        return StringUtils.endsWith((String)name, (String)".c++") || StringUtils.endsWith((String)name, (String)".cc") || StringUtils.endsWith((String)name, (String)".cpp") || StringUtils.endsWith((String)name, (String)".cxx");
    }

    private static boolean isCSource(@NotNull String name) {
        return StringUtils.endsWith((String)name, (String)".c");
    }

    @Nullable
    private static OCLanguageKind detectMostFrequentSourcesKind(@NotNull Project project2) {
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project2);
        if (projectDir == null) {
            return null;
        }
        long timestamp = System.currentTimeMillis();
        AtomicInteger cppCounter = new AtomicInteger(0);
        AtomicInteger cCounter = new AtomicInteger(0);
        FileUtil.visitFiles((File)projectDir.toNioPath().toFile(), file2 -> {
            ProgressManager.checkCanceled();
            String name = file2.getName().toLowerCase(Locale.ENGLISH);
            if (!name.startsWith("cmakecxxcompilerid") && !name.startsWith("cmakeccompilerid")) {
                if (ClangIdeFacadeImpl.isCppSource(name)) {
                    cppCounter.incrementAndGet();
                } else if (ClangIdeFacadeImpl.isCSource(name)) {
                    cCounter.incrementAndGet();
                }
            }
            return System.currentTimeMillis() - timestamp < 3000L;
        });
        if (cppCounter.get() == 0 && cCounter.get() == 0) {
            return null;
        }
        return cppCounter.get() > cCounter.get() ? CLanguageKind.CPP : CLanguageKind.C;
    }

    private static class ResolveInfo {
        @NotNull
        public final OCResolveConfiguration configuration;
        @NotNull
        public final VirtualFile root;
        @NotNull
        public final OCLanguageKind languageKind;
        public final boolean guessed;

        private ResolveInfo(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @NotNull OCLanguageKind languageKind, boolean guessed) {
            this.configuration = configuration;
            this.root = root;
            this.languageKind = languageKind;
            this.guessed = guessed;
        }
    }

    public static final class PathOptInfo {
        @NotNull
        public final PathOptType type;
        @NotNull
        public final String opt;

        public PathOptInfo(@NotNull PathOptType type, @NotNull String opt) {
            this.type = type;
            this.opt = opt;
        }
    }

    static enum PathOptType {
        ThisWithPath,
        NextWithPath,
        NotAPathOpt;

    }
}

