/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangCommandLineParser;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangCommandLineParserKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLineArgument;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOptionsFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineOption;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineParser;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineParserCancellationException;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineParserException;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineParserUnknownException;
import com.jetbrains.cidr.lang.toolchains.CidrInvalidSwitchException;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangCommandLineParser;", "Lcom/jetbrains/cidr/lang/toolchains/CidrCommandLineParser;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "compilerToFlags", "Lkotlin/Pair;", "Ljava/util/EnumSet;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangOptionsFlags;", "compiler", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "parse", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/jetbrains/cidr/lang/toolchains/CidrCommandLineOption;", "switches", "", "", "parseSync", "intellij.c"})
public final class ClangCommandLineParser
implements CidrCommandLineParser {
    private final Project project;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<List<CidrCommandLineOption>> parse(@NotNull OCCompilerKind compiler, @NotNull List<String> switches) {
        void flagsToInclude;
        Pair<EnumSet<ClangOptionsFlags>, EnumSet<ClangOptionsFlags>> pair = this.compilerToFlags(compiler);
        EnumSet enumSet = (EnumSet)pair.component1();
        EnumSet flagsToExclude = (EnumSet)pair.component2();
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(this.project);
        if (clangLanguageServiceProvider == null) {
            throw (Throwable)new IllegalStateException("no Clangd language provider");
        }
        ClangLanguageServiceProvider provider2 = clangLanguageServiceProvider;
        if (!ClangdSettings.getInstance(this.project).isClangdEnabled()) {
            throw (Throwable)new IllegalStateException("Clangd is disabled");
        }
        ClangLanguageService service = provider2.getOrStart();
        return ((CompletableFuture)service.parseCommandLine(switches, (EnumSet<ClangOptionsFlags>)flagsToInclude, flagsToExclude).exceptionally((Function)new Function<Throwable, List<? extends ClangCommandLineArgument>>(switches){
            final /* synthetic */ List $switches;

            public final List<? extends ClangCommandLineArgument> apply(Throwable cause) {
                Throwable throwable;
                OCLog.LOG.warn(cause);
                Throwable throwable2 = cause;
                if (throwable2 instanceof CancellationException || throwable2 instanceof InterruptedException) {
                    throwable = new CidrCommandLineParserCancellationException(cause);
                } else if (throwable2 instanceof ExecutionException || throwable2 instanceof ResponseErrorException) {
                    Pair pair;
                    String string = cause.getMessage();
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        pair = ClangCommandLineParserKt.access$parseErrorMessage(it);
                    } else {
                        pair = null;
                    }
                    Pair pair2 = pair;
                    throwable = pair2 != null ? (CidrCommandLineParserException)new CidrInvalidSwitchException(this.$switches, ((Number)pair2.getFirst()).intValue(), cause) : (CidrCommandLineParserException)new CidrCommandLineParserUnknownException(cause);
                } else {
                    throwable = new CidrCommandLineParserUnknownException(cause);
                }
                throw throwable;
            }
            {
                this.$switches = list;
            }
        })).thenApply((Function)parse.2.INSTANCE);
    }

    private final Pair<EnumSet<ClangOptionsFlags>, EnumSet<ClangOptionsFlags>> compilerToFlags(OCCompilerKind compiler) {
        OCCompilerKind oCCompilerKind = compiler;
        return Intrinsics.areEqual((Object)oCCompilerKind, (Object)GCCCompilerKind.INSTANCE) ? TuplesKt.to(null, EnumSet.of((Enum)ClangOptionsFlags.CLOption)) : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangCompilerKind.INSTANCE) ? TuplesKt.to(null, EnumSet.of((Enum)ClangOptionsFlags.CLOption)) : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)MSVCCompilerKind.INSTANCE) ? TuplesKt.to(EnumSet.of((Enum)ClangOptionsFlags.DriverOption, (Enum)ClangOptionsFlags.CLOption), null) : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangClCompilerKind.INSTANCE) ? TuplesKt.to(EnumSet.of((Enum)ClangOptionsFlags.DriverOption, (Enum)ClangOptionsFlags.CLOption), null) : TuplesKt.to(null, null))));
    }

    @Override
    @NotNull
    public List<CidrCommandLineOption> parseSync(@NotNull OCCompilerKind compiler, @NotNull List<String> switches) throws CidrCommandLineParserException {
        List list;
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() && !application.isUnitTestMode()) {
            OCLog.LOG.warn("Do not call on EDT!");
        }
        if ((list = (List)ClangUtils.waitCancelAware(this.parse(UnknownCompilerKind.INSTANCE, switches), Long.MAX_VALUE, "clionParseCommandLine")) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public ClangCommandLineParser(@NotNull Project project2) {
        this.project = project2;
    }
}

