/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.connector;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangDaemonNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessServerConnectionProvider
implements ServerConnectionProvider {
    private static final String CLANGD_LOG_PATH = System.getProperty("CLANGD_LOG_PATH");
    private static final Logger LOG = Logger.getInstance(ProcessServerConnectionProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myExePath;
    @Nullable
    private Error myLastError;

    public ProcessServerConnectionProvider(@NotNull Project project2, @NotNull String exePath) {
        this.myProject = project2;
        this.myExePath = exePath;
    }

    @Override
    @Nullable
    public ServerConnection create() {
        GeneralCommandLine commandLine = this.buildCommandLine();
        File clangdPath = new File(commandLine.getExePath());
        if (!ProcessServerConnectionProvider.isAvailable(clangdPath)) {
            if (!clangdPath.exists()) {
                if (this.myLastError != Error.ClangdNotFound) {
                    Notifications.Bus.notify((Notification)new ClangDaemonNotification("clion-clangd is not found at " + clangdPath), (Project)this.myProject);
                    LOG.warn("clion-clangd is not found at " + clangdPath);
                }
                this.myLastError = Error.ClangdNotFound;
            } else {
                if (this.myLastError != Error.ClangdCannotBeExecuted) {
                    Notifications.Bus.notify((Notification)new ClangDaemonNotification("clion-clangd cannot be executed at " + clangdPath), (Project)this.myProject);
                    LOG.warn("clion-clangd cannot be executed at " + clangdPath);
                }
                this.myLastError = Error.ClangdCannotBeExecuted;
            }
            return null;
        }
        this.myLastError = null;
        try {
            ClangdProcessHandler processHandler = new ClangdProcessHandler(commandLine.createProcess(), commandLine.getPreparedCommandLine());
            CompletableFuture<Integer> stopFuture = new CompletableFuture<Integer>();
            processHandler.addProcessListener((ProcessListener)new ClangdProcessAdapter(stopFuture));
            processHandler.startNotify();
            return new ProcessServerConnection(processHandler, stopFuture);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    private GeneralCommandLine buildCommandLine() {
        String traceFilePath;
        String mirrorFilePath;
        GeneralCommandLine commandLine = new GeneralCommandLine().withExePath(this.myExePath);
        commandLine.addParameter("-clion-mode");
        commandLine.addParameter("-update-debounce=0");
        commandLine.addParameter("-index=false");
        commandLine.addParameter("-include-ineligible-results");
        commandLine.addParameter("-clang-tidy=0");
        if (CLANGD_LOG_PATH != null) {
            commandLine.addParameter("-trace=" + CLANGD_LOG_PATH);
        }
        String resourceDir = ClangUtils.getClangCudaHeaderDir().getParent();
        commandLine.addParameter("-resource-dir=" + resourceDir);
        if (Registry.is((String)"clion.clang.clangd.thread.pool")) {
            commandLine.addParameter("-clion-enable-thread-pool");
        }
        if (Registry.is((String)"clion.clang.clangd.recovery.ast")) {
            commandLine.addParameter("-recovery-ast");
        }
        if ((mirrorFilePath = (String)this.myProject.getUserData(ClangDaemonContext.MIRROR_FILE_PATH)) != null) {
            commandLine.addParameter("-input-mirror-file=" + mirrorFilePath);
            commandLine.addParameter("-clion-delimited-mirror-file");
        }
        if ((traceFilePath = (String)this.myProject.getUserData(ClangDaemonContext.TRACE_FILE_PATH)) != null) {
            commandLine.withEnvironment("CLANGD_TRACE", traceFilePath);
        }
        if (ClangDebugLevel.isInfoOrMore()) {
            commandLine.addParameter("-log=verbose");
        }
        return commandLine;
    }

    private static boolean isAvailable(@Nullable File clangdPath) {
        try {
            return clangdPath != null && clangdPath.exists() && clangdPath.canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static final class ClangdProcessHandler
    extends BaseProcessHandler<Process> {
        ClangdProcessHandler(@NotNull Process process2, @NotNull String cmdLine) {
            super(process2, cmdLine, StandardCharsets.UTF_8);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    try {
                        myWaitFor.setTerminationCallback(exitCode -> this.notifyProcessTerminated(exitCode));
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }
            });
            super.startNotify();
        }

        @NotNull
        public Future<?> executeOnPooledThread(@NotNull Runnable task2) {
            return ProcessIOExecutorService.INSTANCE.submit(task2);
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task2) {
            return this.executeOnPooledThread(task2);
        }

        protected void closeStreams() {
            super.closeStreams();
            try {
                this.myProcess.getErrorStream().close();
                this.myProcess.getOutputStream().close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        @Nullable
        public InputStream getProcessOutput() {
            return this.myProcess.getInputStream();
        }

        @Nullable
        public InputStream getProcessErrors() {
            return this.myProcess.getErrorStream();
        }
    }

    private static final class ClangdProcessAdapter
    extends ProcessAdapter {
        @NotNull
        final CompletableFuture<Integer> myAssociatedStopFuture;

        ClangdProcessAdapter(@NotNull CompletableFuture<Integer> associatedStopFuture) {
            this.myAssociatedStopFuture = associatedStopFuture;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            this.myAssociatedStopFuture.complete(event.getExitCode());
        }
    }

    public static final class ProcessServerConnection
    implements ServerConnection {
        @NotNull
        private final ClangdProcessHandler myProcessHandler;
        @NotNull
        private final CompletableFuture<Integer> myStopFuture;

        ProcessServerConnection(@NotNull ClangdProcessHandler processHandler, @NotNull CompletableFuture<Integer> stopFuture) {
            this.myProcessHandler = processHandler;
            this.myStopFuture = stopFuture;
        }

        public Process getProcess() {
            return this.myProcessHandler.getProcess();
        }

        @Override
        public void stop() {
            if (this.isActive()) {
                this.myProcessHandler.destroyProcess();
            }
        }

        @Override
        public void kill() {
            Process process2 = this.getProcess();
            if (this.isActive()) {
                if (OSProcessHandler.processCanBeKilledByOS((Process)process2)) {
                    OSProcessUtil.killProcess((Process)process2);
                } else {
                    process2.destroy();
                }
            }
        }

        @Override
        @NotNull
        public CompletableFuture<Integer> getStopFuture() {
            return this.myStopFuture;
        }

        @Override
        public boolean isActive() {
            return !this.myStopFuture.isDone();
        }

        @Override
        @Nullable
        public InputStream getInputStream() {
            if (this.isActive()) {
                return this.myProcessHandler.getProcessOutput();
            }
            return null;
        }

        @Override
        @Nullable
        public OutputStream getOutputStream() {
            if (this.isActive()) {
                return this.myProcessHandler.getProcessInput();
            }
            return null;
        }

        @Override
        @Nullable
        public InputStream getErrorStream() {
            if (this.isActive()) {
                return this.myProcessHandler.getProcessErrors();
            }
            return null;
        }
    }

    private static enum Error {
        ClangdNotFound,
        ClangdCannotBeExecuted;

    }
}

