/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdCompletionUtils;
import com.jetbrains.cidr.lang.editor.completion.TemplateInsertHandler;
import org.jetbrains.annotations.NotNull;

public class SnippetInsertHandler
extends TemplateInsertHandler {
    protected SnippetInsertHandler(String insertion) {
        super(insertion);
    }

    private static String getText(Document document2, int startOffset, int endOffset) {
        if (startOffset >= 0 && endOffset > startOffset) {
            CharSequence chars = document2.getImmutableCharSequence();
            return chars.subSequence(Math.min(chars.length() - 1, startOffset), Math.min(chars.length() - 1, endOffset)).toString();
        }
        return "";
    }

    private static boolean hasMatchingCharAfterInsertion(@NotNull String insertion, Document document2, int endOffset, String character) {
        return insertion.endsWith(character) && endOffset < document2.getTextLength() && SnippetInsertHandler.getText(document2, endOffset, endOffset + 1).equals(character);
    }

    @Override
    protected void reformatAfterInsertion(@NotNull InsertionContext context2, @NotNull String insertion) {
        Document document2 = context2.getDocument();
        int endOffset = context2.getTailOffset();
        ClangdCompletionUtils.adjustCompletionInLiveTemplateIfNeeded(context2.getProject(), context2.getEditor(), document2, insertion, endOffset);
        if (SnippetInsertHandler.hasMatchingCharAfterInsertion(insertion, document2, endOffset, " ")) {
            document2.replaceString(endOffset - 1, endOffset + 1, (CharSequence)" ");
            return;
        }
        if (context2.getCompletionChar() == ';' && SnippetInsertHandler.getText(document2, endOffset - 1, endOffset).equals(";")) {
            context2.setAddCompletionChar(false);
        }
        if (insertion.endsWith(";") || insertion.startsWith("case") || insertion.startsWith("new ") || insertion.startsWith("using namespace ") || insertion.endsWith(" ") && context2.getCompletionChar() != ';') {
            ClangdCompletionUtils.reindentCompletion(context2, context2.getStartOffset());
            return;
        }
        ClangdCompletionUtils.reformatCompletion(context2, context2.getStartOffset(), context2.getStartOffset() + insertion.length());
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        super.handleInsert(context2, item);
    }

    public static LookupElementBuilder snippetLookup(String template) {
        String data = template.replaceAll("\\n|(<caret>)|(<#(.*)#>)", "").trim();
        return SnippetInsertHandler.snippetLookup(data, template);
    }

    public static LookupElementBuilder snippetLookup(String userString, String template) {
        Object insertHandler;
        int caretIndex = template.indexOf("<caret>");
        if (userString.endsWith(")") && !userString.endsWith("\")") && (caretIndex == -1 || caretIndex > template.indexOf(40))) {
            insertHandler = new SnippetParenthesesHandler(!template.endsWith("()"));
            userString = userString.substring(0, userString.lastIndexOf("("));
        } else {
            insertHandler = new SnippetInsertHandler(template);
        }
        return LookupElementBuilder.create((Object)new TemplateInsertHandler.TemplateObject(userString), (String)userString).withInsertHandler((InsertHandler)insertHandler);
    }

    private static class SnippetParenthesesHandler
    implements InsertHandler<LookupElement> {
        final boolean myHasParameters;

        SnippetParenthesesHandler(boolean hasParameters) {
            this.myHasParameters = hasParameters;
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            Editor editor = context2.getEditor();
            Document document2 = editor.getDocument();
            String text = document2.getText();
            boolean hasLParen = context2.getTailOffset() < text.length() && text.substring(context2.getTailOffset()).trim().startsWith("(");
            int offsetBeforeLParen = context2.getTailOffset();
            if (context2.getTailOffset() > 0 && context2.getTailOffset() < text.length() && text.substring(context2.getTailOffset() - 1, context2.getTailOffset() + 1).equals("  ")) {
                document2.replaceString(context2.getTailOffset(), context2.getTailOffset() + 1, (CharSequence)"");
            }
            ParenthesesInsertHandler.getInstance((boolean)this.myHasParameters, (boolean)false, (boolean)false, (!hasLParen ? 1 : 0) != 0, (boolean)false).handleInsert(context2, item);
            if (hasLParen && this.myHasParameters) {
                text = document2.getText();
                int lParenOffset = offsetBeforeLParen < text.length() ? text.indexOf("(", offsetBeforeLParen) : context2.getTailOffset();
                editor.getCaretModel().moveToOffset(lParenOffset + 1);
            }
        }
    }
}

