/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdCompletionUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ClangdInsertHandler
implements InsertHandler<LookupElement> {
    private final CLionCompletionItem completion;
    private final int prefixLength;
    private final String charBeforePrefix;
    private final Position completionCaretPosition;

    private static boolean isFunctionLike(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.Function || completion.getKind() == CompletionItemKind.Method || completion.getKind() == CompletionItemKind.Constructor || completion.getKind() == CompletionItemKind.Text && CLionCompletionFlags.isMacro(completion.getCLionFlags()) && completion.getLabel().startsWith("(");
    }

    @Contract(pure=true)
    ClangdInsertHandler(@NotNull CLionCompletionItem completion, int prefixLength, String charBeforePrefix, Position completionCaretPosition) {
        this.completion = completion;
        this.prefixLength = prefixLength;
        this.charBeforePrefix = charBeforePrefix;
        this.completionCaretPosition = completionCaretPosition;
    }

    private static int matchingRBracket(@NotNull HighlighterIterator iterator2, IElementType lBracketType, IElementType rBracketType) {
        int balance = 1;
        while (balance > 0 && !iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (tokenType == lBracketType) {
                ++balance;
            } else if (tokenType == rBracketType && --balance == 0) {
                int rAngleOffset = iterator2.getStart();
                iterator2.advance();
                return rAngleOffset;
            }
            iterator2.advance();
        }
        return -1;
    }

    private String handleMatchingSignature(InsertionContext context2, String insertion, char completionChar, Ref<Integer> editEndOffset, Ref<Integer> newCaretOffset) {
        if (!this.completion.getLabel().startsWith("(") && !this.completion.getLabel().startsWith("<")) {
            return insertion;
        }
        EditorHighlighter highlighter = ((EditorEx)context2.getEditor()).getHighlighter();
        @NotNull HighlighterIterator iterator2 = highlighter.createIterator(context2.getTailOffset());
        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(iterator2.getTokenType())) {
            iterator2.advance();
        }
        if (iterator2.atEnd()) {
            return insertion;
        }
        int prevInsertionLength = insertion.length();
        IElementType tokenType = iterator2.getTokenType();
        if (this.completion.getLabel().startsWith("<") && insertion.contains("<")) {
            if (tokenType != OCTokenTypes.LT) {
                return insertion;
            }
            int lAngleBracketOffset = iterator2.getStart();
            iterator2.advance();
            if (iterator2.atEnd()) {
                return insertion;
            }
            int rAngleBracketOffset = ClangdInsertHandler.matchingRBracket(iterator2, OCTokenTypes.LT, OCTokenTypes.GT);
            if (rAngleBracketOffset < 0) {
                return insertion;
            }
            insertion = insertion.substring(0, insertion.indexOf("<")) + "<";
            editEndOffset.set((Object)(lAngleBracketOffset + 1));
            newCaretOffset.set((Object)((Integer)newCaretOffset.get() + insertion.length() - prevInsertionLength));
            return insertion;
        }
        if (tokenType != OCTokenTypes.LPAR || !insertion.contains("(")) {
            return insertion;
        }
        int lParOffset = iterator2.getStart();
        iterator2.advance();
        int rParOffset = ClangdInsertHandler.matchingRBracket(iterator2, OCTokenTypes.LPAR, OCTokenTypes.RPAR);
        if (rParOffset < 0) {
            return insertion;
        }
        if (!insertion.endsWith("}")) {
            boolean noParameters = this.completion.getLabel().endsWith("()");
            if (completionChar == '(' || !noParameters || rParOffset - lParOffset != 1) {
                insertion = insertion.substring(0, insertion.indexOf("(")) + "(";
                editEndOffset.set((Object)(lParOffset + 1));
            } else {
                insertion = insertion.substring(0, insertion.indexOf("(")) + "()";
                editEndOffset.set((Object)(rParOffset + 1));
            }
            newCaretOffset.set((Object)((Integer)newCaretOffset.get() + insertion.length() - prevInsertionLength));
            return insertion;
        }
        if (completionChar != '\t') {
            return insertion;
        }
        int lBraceOffset = -1;
        while (!iterator2.atEnd()) {
            tokenType = iterator2.getTokenType();
            if (tokenType == OCTokenTypes.LBRACE) {
                lBraceOffset = iterator2.getStart();
                break;
            }
            iterator2.advance();
        }
        if (lBraceOffset == -1) {
            return insertion;
        }
        insertion = insertion.substring(0, insertion.length() - 2);
        editEndOffset.set((Object)lBraceOffset);
        iterator2.advance();
        if (iterator2.atEnd()) {
            return insertion;
        }
        int bodyStartOffset = iterator2.getStart();
        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(iterator2.getTokenType())) {
            iterator2.advance();
            if (iterator2.atEnd()) {
                return insertion;
            }
            bodyStartOffset = iterator2.getStart();
            tokenType = iterator2.getTokenType();
            if (tokenType == OCTokenTypes.RBRACE) {
                bodyStartOffset = Math.max(lBraceOffset + 1, bodyStartOffset - 1);
            }
            iterator2.retreat();
        }
        newCaretOffset.set((Object)((Integer)newCaretOffset.get() + bodyStartOffset - lBraceOffset - 1));
        iterator2.retreat();
        if (!BraceMatchingUtil.matchBrace((CharSequence)context2.getDocument().getCharsSequence(), (FileType)context2.getFile().getFileType(), (HighlighterIterator)iterator2, (boolean)true)) {
            return insertion;
        }
        iterator2.retreat();
        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(iterator2.getTokenType())) {
            iterator2.retreat();
        }
        context2.getEditor().getSelectionModel().setSelection(bodyStartOffset, Math.max(bodyStartOffset, iterator2.getEnd()));
        return insertion;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Document document2 = context2.getDocument();
        TextEdit textEdit = this.completion.getTextEdit();
        if (textEdit == null) {
            return;
        }
        if (FileUtilRt.getExtension((String)context2.getFile().getName()).endsWith("m")) {
            context2.setAddCompletionChar(false);
        }
        Editor editor = context2.getEditor();
        int startOffset = context2.getStartOffset();
        Position currentStartPos = ClangLanguageServiceUtils.offset2LspPos(document2, startOffset);
        int lineDiff = 0;
        int columnDiff = 0;
        if (this.completionCaretPosition.getLine() != currentStartPos.getLine() || this.completionCaretPosition.getCharacter() - this.prefixLength != currentStartPos.getCharacter()) {
            if (editor.getCaretModel().getCaretCount() == 1) {
                return;
            }
            if (this.charBeforePrefix.isEmpty() || ClangdCompletionUtils.getText(document2, startOffset - 1, startOffset).equals(this.charBeforePrefix)) {
                lineDiff = currentStartPos.getLine() - this.completionCaretPosition.getLine();
                columnDiff = currentStartPos.getCharacter() - (this.completionCaretPosition.getCharacter() - this.prefixLength);
            } else {
                return;
            }
        }
        ArrayList<TextEdit> allTextEdits = new ArrayList<TextEdit>(Collections.singletonList(textEdit));
        if (this.completion.getAdditionalTextEdits() != null) {
            allTextEdits.addAll(this.completion.getAdditionalTextEdits());
        }
        allTextEdits.sort((left, right) -> {
            Position rightStart;
            Position leftStart = left.getRange().getStart();
            if (leftStart.equals((Object)(rightStart = right.getRange().getStart()))) {
                return 0;
            }
            if (leftStart.getLine() < rightStart.getLine()) {
                return 1;
            }
            if (leftStart.getLine() == rightStart.getLine() && leftStart.getCharacter() < rightStart.getCharacter()) {
                return 1;
            }
            return -1;
        });
        document2.deleteString(startOffset + this.prefixLength, context2.getTailOffset());
        for (int i2 = 0; i2 < allTextEdits.size(); ++i2) {
            String textSoFar;
            int includeStartIndex;
            Position start = ((TextEdit)allTextEdits.get(i2)).getRange().getStart();
            Position end = ((TextEdit)allTextEdits.get(i2)).getRange().getEnd();
            if (lineDiff != 0 || columnDiff != 0) {
                start = new Position(start.getLine() + lineDiff, start.getCharacter() + columnDiff);
                end = new Position(end.getLine() + lineDiff, end.getCharacter() + columnDiff);
            }
            int editStartOffset = document2.getLineCount() == 0 ? 0 : ClangLanguageServiceUtils.lspPos2Offset(document2, start);
            Ref editEndOffset = new Ref((Object)(document2.getLineCount() == 0 ? 0 : ClangLanguageServiceUtils.lspPos2Offset(document2, end)));
            char completionChar = context2.getCompletionChar();
            List allCarets = editor.getCaretModel().getAllCarets();
            Caret completionCaret = null;
            for (Caret caret : allCarets) {
                if (caret.getOffset() != startOffset + this.prefixLength) continue;
                completionCaret = caret;
                break;
            }
            String newText = ((TextEdit)allTextEdits.get(i2)).getNewText();
            if (i2 == 0 && ClangdCompletionUtils.hasMatchingSpaceAfterInsertion(newText, document2, (Integer)editEndOffset.get())) {
                newText = StringUtil.trimEnd((String)newText, (char)' ');
            }
            Ref newCaretOffset = new Ref((Object)(editStartOffset + newText.length()));
            boolean functionDefinitionCompletion = newText.endsWith("}");
            String documentText = ClangdCompletionUtils.getText(document2, context2.getTailOffset(), document2.getTextLength());
            if (this.completion.getLabel().startsWith("(") || this.completion.getLabel().startsWith("<")) {
                newText = this.handleMatchingSignature(context2, newText, completionChar, (Ref<Integer>)editEndOffset, (Ref<Integer>)newCaretOffset);
            } else if (newText.endsWith(":") && documentText.startsWith(":")) {
                newText = newText.substring(0, newText.length() - (newText.endsWith("::") ? 2 : 1));
                editEndOffset.set((Object)context2.getTailOffset());
                newCaretOffset.set((Object)(editStartOffset + newText.length()));
            }
            if (this.completion.getKind() == CompletionItemKind.File && (includeStartIndex = StringUtil.lastIndexOfAny((CharSequence)(textSoFar = ClangdCompletionUtils.getText(editor, 0, (int)((Integer)editEndOffset.get()))), (String)"\"<")) > 0) {
                boolean angled;
                boolean bl = angled = textSoFar.charAt(includeStartIndex) == '<';
                if (ClangdCompletionUtils.getText(editor, (int)((Integer)editEndOffset.get()), (Integer)editEndOffset.get() + 1).equals("\n")) {
                    newText = newText + (angled ? (char)'>' : '\"');
                }
                if (angled) {
                    OCTypedHandlerDelegate.overTypeNextRightAngleBracket();
                } else {
                    OCTypedHandlerDelegate.overTypeNextQuote();
                }
            }
            document2.replaceString(editStartOffset, ((Integer)editEndOffset.get()).intValue(), (CharSequence)newText);
            if (newText.endsWith(":")) {
                OCTypedHandlerDelegate.overTypeNextColon(newText.endsWith("::") ? 2 : 1);
            }
            if (i2 != 0 || completionCaret == null) continue;
            if (functionDefinitionCompletion) {
                completionCaret.moveToOffset((Integer)newCaretOffset.get() - 1);
                ClangdCompletionUtils.reformatCompletion(context2, editStartOffset, editStartOffset + newText.length());
                continue;
            }
            if (newText.endsWith("<>")) {
                newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 1));
                TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue());
            } else if (ClangdInsertHandler.isFunctionLike(this.completion) && !this.completion.getLabel().startsWith("()") && newText.endsWith("()")) {
                newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 1));
                TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue());
                if (newText.endsWith("<>()")) {
                    newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 2));
                    TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue(), (Integer)newCaretOffset.get() + 2);
                } else if (newText.endsWith("<><<<>>>()")) {
                    newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 8));
                    TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue(), (Integer)newCaretOffset.get() + 4);
                    TabOutScopesTracker.getInstance().registerEmptyScope(editor, (Integer)newCaretOffset.get() + 4, (Integer)newCaretOffset.get() + 8);
                } else if (newText.endsWith("<<<>>>()")) {
                    newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 4));
                    TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue(), (Integer)newCaretOffset.get() + 4);
                } else {
                    AutoPopupController.getInstance((Project)context2.getProject()).autoPopupParameterInfo(editor, null);
                }
            }
            completionCaret.moveToOffset(((Integer)newCaretOffset.get()).intValue());
        }
        if (this.completion.getKind() == CompletionItemKind.File) {
            ClangdInsertHandler.removeErrorForExistingHeader(context2.getProject(), document2, startOffset, context2.getTailOffset());
        }
    }

    private static void removeErrorForExistingHeader(@NotNull Project project2, @NotNull Document document2, int startOffset, int endOffset) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        if (documentManager.getCachedPsiFile(document2) == null) {
            return;
        }
        SmartList infosToDispose = new SmartList();
        DaemonCodeAnalyzerEx.processHighlights((Document)document2, (Project)project2, null, (int)startOffset, (int)endOffset, arg_0 -> ClangdInsertHandler.lambda$removeErrorForExistingHeader$1((List)infosToDispose, arg_0));
        for (HighlightInfo info : infosToDispose) {
            info.getHighlighter().dispose();
        }
    }

    private static /* synthetic */ boolean lambda$removeErrorForExistingHeader$1(List infosToDispose, HighlightInfo info) {
        infosToDispose.add(info);
        return true;
    }
}

