/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.completion.ml.MLWeigherUtil;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.json.editor.smartEnter.JsonSmartEnterProcessor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFuture;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdCompletionUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdInsertHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdLookupElement;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.SnippetInsertHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.editor.completion.ExternalCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.OCNameSuggestionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCNonImportedReferenceCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.QualifiedSelectorCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCExpressionCodeFragmentType;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUDLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCLabelSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import icons.CidrLangIcons;
import icons.CidrProjectModelIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdCodeCompletionProvider
implements ExternalCompletionProvider,
DumbAware {
    static final Key<Integer> IDEA_TIMESTAMP = Key.create((String)"IDEA_TIMESTAMP");
    static final Key<Integer> CLANGD_TIMESTAMP = Key.create((String)"CLANGD_TIMESTAMP");

    @Nullable
    private static Document documentByPath(@NotNull String path) {
        VirtualFile completionSourceFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (completionSourceFile == null) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(completionSourceFile);
    }

    @Nullable
    private static PsiElement psiFromClangdCompletion(@NotNull String path, @NotNull Position position, @NotNull Project project2) {
        Document completionSourceDocument = ClangdCodeCompletionProvider.documentByPath(path);
        if (completionSourceDocument == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(completionSourceDocument);
        if (psiFile == null) {
            return null;
        }
        if (completionSourceDocument.getLineCount() <= position.getLine()) {
            return null;
        }
        int offset = completionSourceDocument.getLineStartOffset(position.getLine()) + position.getCharacter();
        PsiElement result2 = psiFile.findElementAt(offset);
        if (result2 != null && !(result2 instanceof OCSymbolDeclarator)) {
            return result2.getParent();
        }
        return result2;
    }

    private static boolean isKeyword(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.Keyword || completion.getKind() == CompletionItemKind.Snippet;
    }

    private static boolean isHeaderFile(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.File;
    }

    private static boolean isFolder(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.Folder;
    }

    private static boolean isTemplateArg(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.Text && CLionCompletionFlags.isTemplateArg(completion.getCLionFlags());
    }

    private static boolean isMacro(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.Text && CLionCompletionFlags.isMacro(completion.getCLionFlags());
    }

    private static boolean isMacro(@NotNull OCSymbol symbol) {
        return symbol instanceof OCMacroSymbol;
    }

    private static boolean isNamespace(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.Module;
    }

    private static boolean isNamespace(@NotNull OCSymbol symbol) {
        return symbol instanceof OCNamespaceAliasSymbol || symbol instanceof OCNamespaceSymbol && !(symbol instanceof OCStructSymbol);
    }

    private static String pathToCompare(String path) {
        if (!SystemInfo.isFileSystemCaseSensitive) {
            path = path.toLowerCase();
        }
        return PathUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)path));
    }

    private static boolean isPPDirective(@NotNull CLionCompletionItem completion) {
        return CLionCompletionFlags.isDirective(completion.getCLionFlags());
    }

    @Nullable
    private static Icon iconFromCompletionKind(@NotNull CLionCompletionItem item, @NotNull OCVisibility visibility, boolean clangdOnlyMode) {
        CompletionItemKind itemKind = item.getKind();
        int clionFlags = item.getCLionFlags();
        boolean applyVisibility = false;
        Icon baseIcon = null;
        switch (itemKind) {
            case Enum: {
                baseIcon = CidrLangIcons.CodeAssistantEnum;
                break;
            }
            case File: {
                baseIcon = CidrLangIcons.FileTypes.H;
                break;
            }
            case Folder: {
                baseIcon = CLionCompletionFlags.isFramework(clionFlags) ? CidrProjectModelIcons.Framework : PlatformIcons.FOLDER_ICON;
                break;
            }
            case Class: 
            case Struct: {
                applyVisibility = true;
                if (CLionCompletionFlags.isClass(clionFlags)) {
                    baseIcon = clangdOnlyMode ? CidrLangIcons.CodeAssistantClass : CidrLangIcons.CodeAssistantStruct;
                    break;
                }
                if (CLionCompletionFlags.isUnion(clionFlags)) {
                    baseIcon = CidrLangIcons.CodeAssistantUnion;
                    break;
                }
                baseIcon = CidrLangIcons.CodeAssistantStruct;
                break;
            }
            case Field: {
                applyVisibility = true;
                baseIcon = CidrLangIcons.CodeAssistantField;
                if (CLionCompletionFlags.isStatic(clionFlags)) {
                    baseIcon = OCIcons.getStaticIcon(baseIcon);
                }
                if (!CLionCompletionFlags.isConstant(clionFlags)) break;
                baseIcon = OCIcons.getConstIcon(baseIcon);
                break;
            }
            case Function: 
            case Method: 
            case Constructor: {
                applyVisibility = true;
                baseIcon = OCIcons.getFunctionIcon(CLionCompletionFlags.isStatic(clionFlags), false, !CLionCompletionFlags.isVirtualMethod(clionFlags), null);
                baseIcon = CLionCompletionFlags.isConstant(clionFlags) ? OCIcons.getConstIcon(baseIcon) : baseIcon;
                break;
            }
            case Variable: {
                Icon icon = baseIcon = CLionCompletionFlags.isLocal(clionFlags) ? CidrLangIcons.CodeAssistantLocal : CidrLangIcons.CodeAssistantGlobal;
                if (!CLionCompletionFlags.isConstant(clionFlags)) break;
                baseIcon = OCIcons.getConstIcon(baseIcon);
                break;
            }
            case Module: {
                baseIcon = CidrLangIcons.CodeAssistantNamespace;
                break;
            }
            case TypeParameter: {
                baseIcon = CidrLangIcons.CodeAssistantType;
                break;
            }
            case Text: {
                if (!CLionCompletionFlags.isMacro(clionFlags)) break;
                baseIcon = CidrLangIcons.CodeAssistantMacro;
                break;
            }
            case EnumMember: 
            case Value: {
                baseIcon = CidrLangIcons.CodeAssistantEnumConst;
                break;
            }
            case Property: {
                baseIcon = CidrLangIcons.CodeAssistantParameter;
                break;
            }
            case Reference: 
            case Interface: {
                baseIcon = CidrLangIcons.CodeAssistantType;
                break;
            }
        }
        return applyVisibility ? OCIcons.getVisibilityIcon(visibility, baseIcon) : baseIcon;
    }

    @NotNull
    private static OCSymbolKind symbolKindFromCompletionKind(@NotNull CompletionItemKind itemKind) {
        switch (itemKind) {
            case Enum: {
                return OCSymbolKind.ENUM;
            }
            case File: {
                return OCSymbolKind.IMPORT;
            }
            case Class: {
                return OCSymbolKind.STRUCT;
            }
            case Field: {
                return OCSymbolKind.STRUCT_FIELD;
            }
            case Function: {
                return OCSymbolKind.FUNCTION_DECLARATION;
            }
            case Method: {
                return OCSymbolKind.METHOD;
            }
            case Variable: {
                return OCSymbolKind.PARAMETER;
            }
            case Module: {
                return OCSymbolKind.NAMESPACE;
            }
            case Text: {
                return OCSymbolKind.MACRO;
            }
            case Value: {
                return OCSymbolKind.ENUM_CONST;
            }
            case Property: {
                return OCSymbolKind.PROPERTY;
            }
            case Reference: {
                return OCSymbolKind.TYPEDEF;
            }
            case Constructor: {
                return OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION;
            }
            case Snippet: {
                return OCSymbolKind.BLOCK;
            }
            case Keyword: {
                return OCSymbolKind.BUILTIN_SYMBOL;
            }
        }
        return OCSymbolKind.GENERIC_PARAMETER;
    }

    private static Range subtractFromRange(Range range, Position shift) {
        Position start = range.getStart();
        Position end = range.getEnd();
        start.setLine(start.getLine() - shift.getLine());
        if (start.getLine() == 0) {
            start.setCharacter(start.getCharacter() - shift.getCharacter());
        }
        end.setLine(end.getLine() - shift.getLine());
        if (end.getLine() == 0) {
            end.setCharacter(end.getCharacter() - shift.getCharacter());
        }
        range.setStart(start);
        range.setEnd(end);
        return range;
    }

    private static TemplateImpl correctCompletion(@NotNull CLionCompletionItem completion, Position extraPositionOffset, String fragmentFilename) {
        File parent;
        String file2;
        String wholeCompletion = completion.getLabel();
        String[] lines = wholeCompletion.split("\\\\u2029");
        String signature = lines[0];
        completion.setLabel(signature);
        completion.setKind(CompletionItemKind.forValue((int)Integer.parseInt(lines[1])));
        completion.setDetail(lines[2]);
        completion.setFilterText(lines[3]);
        completion.setSortText(lines[4]);
        completion.setCLionFlags(Integer.parseInt(lines[5]));
        completion.setFromFile(lines[6]);
        int fromFileLine = Integer.parseInt(lines[7]);
        int fromFileChar = Integer.parseInt(lines[8]);
        completion.setFromFilePosition(new Position(fromFileLine, fromFileChar));
        String insertText = lines[9];
        int rangeStartLine = Integer.parseInt(lines[10]);
        int rangeStartChar = Integer.parseInt(lines[11]);
        int rangeEndLine = Integer.parseInt(lines[12]);
        int rangeEndChar = Integer.parseInt(lines[13]);
        Range range = new Range(new Position(rangeStartLine, rangeStartChar), new Position(rangeEndLine, rangeEndChar));
        completion.setTextEdit(new TextEdit(range, insertText));
        Ref nextReplacementIndex = new Ref((Object)14);
        Supplier<Boolean> nextReplacement = () -> lines.length > (Integer)nextReplacementIndex.get() && !lines[(Integer)nextReplacementIndex.get()].isEmpty();
        while (nextReplacement.get().booleanValue()) {
            int index = (Integer)nextReplacementIndex.get();
            int startLine = Integer.parseInt(lines[index + 1]);
            int startChar = Integer.parseInt(lines[index + 2]);
            int endLine = Integer.parseInt(lines[index + 3]);
            int endChar = Integer.parseInt(lines[index + 4]);
            if (completion.getAdditionalTextEdits() == null) {
                completion.setAdditionalTextEdits(Collections.singletonList(new TextEdit(new Range(new Position(startLine, startChar), new Position(endLine, endChar)), lines[index])));
            } else {
                completion.getAdditionalTextEdits().add(new TextEdit(new Range(new Position(startLine, startChar), new Position(endLine, endChar)), lines[index]));
            }
            nextReplacementIndex.set((Object)(index + 5));
        }
        TemplateImpl snippet = null;
        if (ClangdCodeCompletionProvider.isKeyword(completion)) {
            if (ClangdCodeCompletionProvider.isPPDirective(completion)) {
                completion.setFilterText('#' + completion.getFilterText());
            }
            if (completion.getKind() == CompletionItemKind.Snippet) {
                Matcher snippetMatcher = Pattern.compile("\\$\\{[0-9]+:([^}]+)}").matcher(insertText);
                String snippetText = insertText;
                ArrayList<Variable> variables = new ArrayList<Variable>();
                int shift = 0;
                int insertTextShift = 0;
                boolean insertPlaceholders = CLionCompletionFlags.needInsertPlaceholders(completion.getCLionFlags());
                while (snippetMatcher.find()) {
                    String matched = snippetMatcher.group(1).replaceAll("-", "_");
                    if (variables.isEmpty()) {
                        insertText = insertText.substring(0, snippetMatcher.start()) + "<caret>" + insertText.substring(snippetMatcher.end());
                        insertTextShift += 7 - (snippetMatcher.end() - snippetMatcher.start());
                    } else {
                        insertText = insertText.substring(0, snippetMatcher.start() + insertTextShift) + insertText.substring(snippetMatcher.end() + insertTextShift);
                        insertTextShift += snippetMatcher.start() - snippetMatcher.end();
                    }
                    snippetText = snippetText.substring(0, snippetMatcher.start() + shift) + "$" + matched + "$" + snippetText.substring(snippetMatcher.end() + shift);
                    shift += matched.length() + 2 - (snippetMatcher.end() - snippetMatcher.start());
                    variables.add(new Variable(matched, null, (Expression)(insertPlaceholders ? new TextExpression(matched) : null), true, false));
                }
                if (variables.size() > 1 && !insertText.contains("{")) {
                    snippet = new TemplateImpl(completion.getFilterText(), snippetText, "C/C++");
                    snippet.setDescription(snippetText.substring(completion.getFilterText().length()).replaceAll("\\$", ""));
                    if (!snippetText.endsWith(")")) {
                        snippet.setToReformat(true);
                    }
                    for (Variable variable : variables) {
                        snippet.addVariable(variable.getName(), variable.getDefaultValueExpression(), true);
                    }
                }
            }
            if (!insertText.trim().equals(",")) {
                insertText = insertText.replaceAll(", |,", "");
            }
        } else if (ClangdCodeCompletionProvider.isHeaderFile(completion)) {
            if (insertText.endsWith("\"") || insertText.endsWith(">")) {
                completion.setFilterText(insertText.substring(0, insertText.length() - 1));
            }
        } else if (ClangdCodeCompletionProvider.isFolder(completion) && insertText.endsWith("/")) {
            completion.setFilterText(insertText.substring(0, insertText.length() - 1));
        }
        completion.getTextEdit().setNewText(insertText);
        if (extraPositionOffset.getLine() != 0 || extraPositionOffset.getCharacter() != 0) {
            completion.getTextEdit().setRange(ClangdCodeCompletionProvider.subtractFromRange(completion.getTextEdit().getRange(), extraPositionOffset));
        }
        if ((file2 = FileUtil.toCanonicalPath((String)completion.getFromFile())) != null && file2.equals(fragmentFilename) && (parent = FileUtil.getParentFile((File)new File(file2))) != null) {
            String realPath = parent.getAbsolutePath();
            completion.setFromFile(FileUtil.toCanonicalPath((String)realPath.substring(0, realPath.length() - 4)));
        }
        return snippet;
    }

    private static OCCompletionPriority keywordPriority(@NotNull CLionCompletionItem completion) {
        float score = Float.parseFloat(completion.getSortText());
        if (score > 1.0f) {
            return OCCompletionPriority.HIGH_KEYWORDS_PRIORITY;
        }
        return OCCompletionPriority.NORMAL_KEYWORDS_PRIORITY;
    }

    private static float priorityFromCompletionItem(@NotNull CLionCompletionItem completion, @NotNull OCVisibility visibility) {
        if (completion.getKind() == CompletionItemKind.Method) {
            return OCCompletionPriority.HIGH_PRIORITY1.getValue();
        }
        OCCompletionPriority completionPriority = ClangdCodeCompletionProvider.isKeyword(completion) ? ClangdCodeCompletionProvider.keywordPriority(completion) : OCCompletionPriority.getPriority(ClangdCodeCompletionProvider.symbolKindFromCompletionKind(completion.getKind()), completion.getFilterText());
        String completionLabel = completion.getFilterText();
        if (completionLabel.equals("new") || completionLabel.equals("delete")) {
            completionPriority = OCCompletionPriority.getPriority(OCSymbolKind.FUNCTION_DECLARATION, completion.getFilterText());
        }
        float priority = completionPriority.getValue();
        if (CLionCompletionFlags.isNotAccessible(completion.getCLionFlags())) {
            if (visibility == OCVisibility.PROTECTED) {
                priority -= 200.0f;
            } else if (visibility == OCVisibility.PRIVATE) {
                priority -= 300.0f;
            }
        } else if (CLionCompletionFlags.isNotAvailable(completion.getCLionFlags())) {
            priority -= 1500.0f;
        }
        return priority;
    }

    @NotNull
    private static String getActionShortcut() {
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
    }

    private static CompletionSorterImpl createClangdSorter(@NotNull CompletionParameters parameters, final boolean clangdOnlyMode) {
        final CompletionLocation location = new CompletionLocation(parameters);
        CompletionSorterImpl sorter = ((CompletionSorterImpl)CompletionService.getCompletionService().emptySorter()).weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh(new LookupElementWeigher("exactMatch"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element, @NotNull WeighingContext context2) {
                LookupElementPresentation presentation = new LookupElementPresentation();
                element.renderElement(presentation);
                if (presentation.getItemText() == null) {
                    return Boolean.valueOf(true);
                }
                return Boolean.valueOf(!presentation.getItemText().equals(context2.itemPattern(element)));
            }

            public boolean isPrefixDependent() {
                return true;
            }
        }).weigh(new LookupElementWeigher("exactPrefixMatch"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element, @NotNull WeighingContext context2) {
                return Boolean.valueOf(!element.getLookupString().startsWith(context2.itemPattern(element)));
            }

            public boolean isPrefixDependent() {
                return true;
            }
        }).weigh(new LookupElementWeigher("priority"){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                PsiElement psiElem;
                ClangdLookupElement clangdElement = (ClangdLookupElement)((Object)element.as(ClangdLookupElement.CLASS_CONDITION_KEY));
                if (clangdElement != null) {
                    return -clangdElement.getScore();
                }
                if (clangdOnlyMode) {
                    return 0.0;
                }
                PrioritizedLookupElement prioritized = (PrioritizedLookupElement)element.as(PrioritizedLookupElement.CLASS_CONDITION_KEY);
                if (prioritized != null) {
                    return -prioritized.getPriority();
                }
                LookupItem item = (LookupItem)element.as(LookupItem.CLASS_CONDITION_KEY);
                if (item != null) {
                    return -item.getPriority();
                }
                if (element instanceof LookupElementDecorator) {
                    element = ((LookupElementDecorator)element).getDelegate();
                }
                if ((psiElem = element.getPsiElement()) != null) {
                    OCSymbolKind symbolKind = null;
                    if (psiElem instanceof OCSymbolDeclarator) {
                        symbolKind = ((OCSymbolDeclarator)psiElem).getSymbol().getKind();
                    } else if ((psiElem = psiElem.getParent()) instanceof OCSymbolDeclarator) {
                        symbolKind = ((OCSymbolDeclarator)psiElem).getSymbol().getKind();
                    }
                    if (symbolKind != null) {
                        return -Double.valueOf(OCCompletionPriority.getPriority(symbolKind, element.getLookupString()).getValue()).doubleValue();
                    }
                }
                return 0.0;
            }
        }).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher()).weigh(new LookupElementWeigher("alphabetic"){

            @NotNull
            public String weigh(@NotNull LookupElement element) {
                ClangdLookupElement clangdElement = (ClangdLookupElement)((Object)element.as(ClangdLookupElement.CLASS_CONDITION_KEY));
                if (clangdElement == null || !ClangdCodeCompletionProvider.isKeyword(clangdElement.getCompletionItem())) {
                    return "";
                }
                return element.getLookupString();
            }
        }).withClassifier((ClassifierFactory)new ClassifierFactory<LookupElement>("stats"){

            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
            }
        }).weigh(new LookupElementWeigher("alphabetic"){

            @NotNull
            public String weigh(@NotNull LookupElement element) {
                return element.getLookupString();
            }
        }).weigh(new LookupElementWeigher("kind"){

            @NotNull
            public Boolean weigh(@NotNull LookupElement element) {
                ClangdLookupElement clangdElement = (ClangdLookupElement)((Object)element.as(ClangdLookupElement.CLASS_CONDITION_KEY));
                if (clangdElement != null) {
                    return clangdElement.getKind() == CompletionItemKind.Snippet;
                }
                return false;
            }
        }).withClassifier("prefix", true, (ClassifierFactory)new ClassifierFactory<LookupElement>("liftShorter"){

            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }
        });
        LookupElementWeigher mlWeigher = MLWeigherUtil.findMLWeigher((CompletionLocation)location);
        if (mlWeigher != null) {
            sorter = sorter.weigh(mlWeigher);
        }
        return sorter;
    }

    protected LookupElement lookup(@NotNull CLionCompletionItem completion, @Nullable Icon icon, int prefixLength, String charBeforePrefix, Position completionCaretPosition, @Nullable TemplateImpl snippet) {
        if (completion.getKind() == CompletionItemKind.Snippet) {
            if (snippet != null) {
                return new LiveTemplateLookupElementImpl(snippet, false);
            }
            return SnippetInsertHandler.snippetLookup(completion.getTextEdit().getNewText()).withBoldness(true).withPresentableText(completion.getFilterText()).withTailText(completion.getLabel()).withTypeText(completion.getDetail());
        }
        if (completion.getKind() == CompletionItemKind.Keyword) {
            return LookupElementBuilder.create((Object)((Object)completion), (String)completion.getTextEdit().getNewText()).withPresentableText(completion.getFilterText()).withTypeText(completion.getDetail()).withTailText(completion.getLabel()).withBoldness(true).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
                    if (FileUtilRt.getExtension((String)context2.getFile().getName()).endsWith("m")) {
                        context2.setAddCompletionChar(false);
                    }
                    Document document2 = context2.getDocument();
                    int endOffset = context2.getTailOffset();
                    ClangdCompletionUtils.adjustCompletionInLiveTemplateIfNeeded(context2.getProject(), context2.getEditor(), document2, item.getLookupString(), endOffset);
                    if (ClangdCompletionUtils.hasMatchingSpaceAfterInsertion(item.getLookupString(), document2, endOffset)) {
                        document2.replaceString(endOffset - 1, endOffset + 1, (CharSequence)" ");
                    }
                }
            });
        }
        String presentation = completion.getFilterText();
        if (CLionCompletionFlags.isOverrideCall(completion.getCLionFlags())) {
            String insertedText = completion.getTextEdit().getNewText();
            presentation = insertedText.substring(0, insertedText.indexOf(presentation)) + presentation;
        }
        return LookupElementBuilder.create((Object)((Object)completion), (String)StringUtil.trimStart((String)completion.getFilterText(), (String)"~")).withPresentableText(presentation).withTypeText(completion.getDetail()).withTailText(completion.getLabel()).withIcon(icon).withStrikeoutness(CLionCompletionFlags.isDeprecated(completion.getCLionFlags())).withInsertHandler((InsertHandler)new ClangdInsertHandler(completion, prefixLength, charBeforePrefix, completionCaretPosition));
    }

    protected LookupElement wrapLookup(LookupElement lookupElement) {
        return lookupElement;
    }

    protected boolean isClangdOnlyMode(@NotNull Project project2) {
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isClangdOn() && settings.getCompletionType() == ClangdSettings.CompletionType.Clangd;
    }

    private boolean consumeResult(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull Either<List<CLionCompletionItem>, CLionCompletionList> completionResult, @NotNull ItemSourceChecker sourceChecker, String charBeforePrefix, Position completionCaretPosition, Position extraPositionOffset, String fragmentFilename) {
        List<CLionCompletionItem> completions = completionResult.isLeft() ? (List<CLionCompletionItem>)completionResult.getLeft() : ((CLionCompletionList)completionResult.getRight()).getItems();
        boolean clangdOnlyMode = this.isClangdOnlyMode(parameters.getPosition().getProject());
        int invocationCount = parameters.getInvocationCount();
        if (parameters.getProcess().isAutopopupCompletion()) {
            ++invocationCount;
        }
        boolean atLeastOneElementAdded = false;
        for (CLionCompletionItem completion : completions) {
            TemplateImpl snippet = ClangdCodeCompletionProvider.correctCompletion(completion, extraPositionOffset, fragmentFilename);
            if ((CLionCompletionFlags.isNotAccessible(completion.getCLionFlags()) || CLionCompletionFlags.isNotAvailable(completion.getCLionFlags())) && invocationCount <= 1) {
                if (invocationCount != 1 || !clangdOnlyMode) continue;
                result2.addLookupAdvertisement(ClangdBundle.message("completion.press.shortcut.for.non.public.members", ClangdCodeCompletionProvider.getActionShortcut()));
                --invocationCount;
                continue;
            }
            OCVisibility visibility = CLionCompletionFlags.isPrivate(completion.getCLionFlags()) ? OCVisibility.PRIVATE : (CLionCompletionFlags.isProtected(completion.getCLionFlags()) ? OCVisibility.PROTECTED : OCVisibility.PUBLIC);
            LookupElement element = sourceChecker.createClangdItemIfNeeded(completion, clangdOnlyMode, item -> {
                if (ClangdCodeCompletionProvider.isKeyword(item)) {
                    if (charBeforePrefix.equals("@")) {
                        item.setFilterText("@" + item.getFilterText());
                    }
                    if (clangdOnlyMode) {
                        return ClangdLookupElement.withCompletionItem(this.lookup((CLionCompletionItem)((Object)item), null, 0, charBeforePrefix, completionCaretPosition, snippet), completion);
                    }
                    return PrioritizedLookupElement.withPriority((LookupElement)this.lookup((CLionCompletionItem)((Object)item), null, 0, charBeforePrefix, completionCaretPosition, snippet), (double)ClangdCodeCompletionProvider.priorityFromCompletionItem(item, visibility));
                }
                Icon icon = ClangdCodeCompletionProvider.iconFromCompletionKind(completion, visibility, clangdOnlyMode);
                if (clangdOnlyMode) {
                    return ClangdLookupElement.withCompletionItem(this.lookup((CLionCompletionItem)((Object)item), icon, result2.getPrefixMatcher().getPrefix().length(), charBeforePrefix, completionCaretPosition, snippet), completion);
                }
                return PrioritizedLookupElement.withPriority((LookupElement)this.lookup((CLionCompletionItem)((Object)item), icon, result2.getPrefixMatcher().getPrefix().length(), charBeforePrefix, completionCaretPosition, snippet), (double)ClangdCodeCompletionProvider.priorityFromCompletionItem(item, visibility));
            });
            if (element == null || !result2.getPrefixMatcher().prefixMatches(element)) continue;
            atLeastOneElementAdded = true;
            try {
                result2.addElement(element);
            }
            catch (ProcessCanceledException ex) {
                return true;
            }
        }
        return atLeastOneElementAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean consume(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull Either<List<CLionCompletionItem>, CLionCompletionList> completionResult, @NotNull ItemSourceChecker sourceChecker, String charBeforePrefix, Position completionCaretPosition, Position extraPositionOffset, String fragmentFilename) throws ExecutionException, TimeoutException {
        boolean atLeastOneElementAdded = this.consumeResult(parameters, result2, completionResult, sourceChecker, charBeforePrefix, completionCaretPosition, extraPositionOffset, fragmentFilename);
        ProgressManager progressManager = ProgressManager.getInstance();
        while (completionResult.isRight() && ((CLionCompletionList)completionResult.getRight()).isIncomplete()) {
            ProgressIndicator completionIndicator = progressManager.getProgressIndicator();
            if (completionIndicator == null || completionIndicator.isCanceled()) {
                return atLeastOneElementAdded;
            }
            ClangResultFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> future = ClangdCodeCompletionProvider.clangdCompletionFuture(parameters, CompletionTriggerKind.TriggerForIncompleteCompletions, extraPositionOffset);
            try {
                completionResult = ClangUtils.waitCancelAware(future.asFuture(), Long.MAX_VALUE, "complete");
            }
            finally {
                future.release();
            }
            if (completionResult == null) break;
            atLeastOneElementAdded |= this.consumeResult(parameters, result2, completionResult, sourceChecker, charBeforePrefix, completionCaretPosition, extraPositionOffset, fragmentFilename);
        }
        return atLeastOneElementAdded;
    }

    private static ClangResultFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> clangdCompletionFuture(@NotNull CompletionParameters parameters, @NotNull CompletionTriggerKind kind, Position extraPositionOffset) {
        Project project2 = parameters.getPosition().getProject();
        FileViewProvider viewProvider = parameters.getOriginalFile().getViewProvider();
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        int offset = parameters.getOffset();
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project2);
        if (virtualFile instanceof OCFragmentVirtualFile) {
            int parentOffset = ((OCFragmentVirtualFile)virtualFile).getParentOffset();
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)((OCFragmentVirtualFile)virtualFile).getParentFileContent(), (int)parentOffset);
            if (lineColumn != null) {
                extraPositionOffset.setLine(lineColumn.line);
                extraPositionOffset.setCharacter(lineColumn.column);
                offset += parentOffset;
            }
        }
        Ref resultRef = Ref.create();
        service.complete(virtualFile, offset, kind, result2 -> resultRef.set(result2.iWillNotForgetToCancelTheFuture()));
        return (ClangResultFuture)resultRef.get();
    }

    private static void waitForConsumerFinished(@NotNull CompletableFuture<Void> accepted) {
        try {
            ClangUtils.waitCancelAware(accepted, Long.MAX_VALUE, "clangd all completions");
        }
        catch (ExecutionException | TimeoutException exception) {
            JsonSmartEnterProcessor.LOG.warn((Throwable)exception);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Contract(value="null -> null")
    @Nullable
    private static Document getDocument(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(virtualFile);
    }

    @Nullable
    private static Pair<String, Position> getSymbolCompletion(@Nullable OCSymbol symbol, @NotNull VirtualFile file2) {
        if (symbol == null) {
            return null;
        }
        Document document2 = ClangdCodeCompletionProvider.getDocument(file2);
        if (document2 == null) {
            return null;
        }
        if (symbol.getName().startsWith("~")) {
            return null;
        }
        String associatedPath = ClangdCodeCompletionProvider.pathToCompare(file2.getPath());
        Position associatedPosition = new Position();
        int offset = symbol.getOffset();
        try {
            associatedPosition.setLine(document2.getLineNumber(offset));
            associatedPosition.setCharacter(offset - document2.getLineStartOffset(associatedPosition.getLine()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsEx) {
            return null;
        }
        return new Pair((Object)associatedPath, (Object)associatedPosition);
    }

    @Nullable
    private static OCSymbol getRealSymbol(@NotNull String path, @NotNull Position position, @NotNull PsiElement fakePsi) {
        List<OCSymbol> symbols;
        if (!(fakePsi instanceof OCSymbolDeclarator)) {
            return null;
        }
        PsiElement realPsi = ClangdCodeCompletionProvider.psiFromClangdCompletion(path, position, fakePsi.getProject());
        if (realPsi instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)realPsi).getSymbol();
            Object originalSymbol = ((OCSymbolDeclarator)fakePsi).getSymbol();
            if (symbol != null && symbol.isSameSymbol((OCSymbol)originalSymbol, fakePsi.getProject())) {
                return symbol;
            }
        }
        if (realPsi instanceof OCCppNamespaceQualifier && !(symbols = ((OCCppNamespaceQualifier)realPsi).resolveToSymbols()).isEmpty()) {
            return symbols.get(0);
        }
        return null;
    }

    protected boolean isEnabled(@NotNull Project project2) {
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isClangdOn() && settings.getCompletionType() != ClangdSettings.CompletionType.Builtin;
    }

    private static boolean isEnumMemberCompletion(PsiElement element) {
        if (element == null) {
            return false;
        }
        if ((element = element.getParent()) == null) {
            return false;
        }
        element = element.getParent();
        return element instanceof OCEnum;
    }

    private static boolean isStructNameCompletion(PsiElement element) {
        if (element == null) {
            return false;
        }
        element = element.getParent();
        return element instanceof OCStruct;
    }

    private static void runNameSuggestionContributor(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        List contributors = CompletionContributor.forParameters((CompletionParameters)parameters);
        for (CompletionContributor contributor : contributors) {
            if (!(contributor instanceof OCNameSuggestionContributor)) continue;
            contributor.fillCompletionVariants(parameters, result2);
            return;
        }
    }

    private static void runExtraCompletionContributors(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, int invocationCount, boolean allowNameSuggestions) {
        if (!allowNameSuggestions && invocationCount <= 1) {
            return;
        }
        List contributors = CompletionContributor.forParameters((CompletionParameters)parameters);
        for (CompletionContributor contributor : contributors) {
            if (invocationCount > 1 && (contributor instanceof OCNonImportedReferenceCompletionContributor || contributor instanceof QualifiedSelectorCompletionContributor)) {
                parameters.setCompleteOnlyNotImported(true);
                contributor.fillCompletionVariants(parameters, result2);
            }
            if (contributor instanceof OCNameSuggestionContributor && allowNameSuggestions) {
                contributor.fillCompletionVariants(parameters, result2);
            }
            if (!result2.isStopped()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet originalResult) {
        IElementType contentElementType;
        Project project2 = parameters.getPosition().getProject();
        if (!this.isEnabled(project2)) {
            return;
        }
        PsiElement psiContextElement = parameters.getPosition().getContext();
        if (psiContextElement == null) {
            psiContextElement = parameters.getPosition().getContainingFile();
        }
        if (psiContextElement instanceof OCUDLiteralExpression) {
            return;
        }
        PsiFile psiFile = parameters.getOriginalFile();
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project2);
        if (service.isFileBanned(virtualFile.getUrl())) {
            return;
        }
        if (psiFile instanceof OCCodeFragmentImpl && !((contentElementType = ((OCCodeFragmentImpl)psiFile).getContentElementType()) instanceof OCExpressionCodeFragmentType)) {
            return;
        }
        String fragmentFilename = virtualFile instanceof OCFragmentVirtualFile ? virtualFile.getCanonicalPath() : "";
        CompletionSorterImpl sorter = ClangdCodeCompletionProvider.createClangdSorter(parameters, this.isClangdOnlyMode(project2));
        CompletionResultSet result2 = originalResult.withRelevanceSorter((CompletionSorter)sorter);
        ItemSourceChecker sourceChecker = new ItemSourceChecker();
        int offset = parameters.getOffset();
        Editor editor = parameters.getEditor();
        if (ClangdCompletionUtils.isLiveTemplateNameSegmentCompletion(project2, editor)) {
            ClangdCodeCompletionProvider.runNameSuggestionContributor(parameters, result2);
            result2.stopHere();
            return;
        }
        List allCarets = editor.getCaretModel().getAllCarets();
        Caret completionCaret = (Caret)allCarets.get(0);
        for (Caret caret : allCarets) {
            if (offset != caret.getOffset()) continue;
            completionCaret = caret;
            break;
        }
        int prefixOffset = offset - result2.getPrefixMatcher().getPrefix().length();
        String charBeforePrefix = ClangdCompletionUtils.getText(editor, prefixOffset - 1, prefixOffset);
        Position extraPositionOffset = new Position(0, 0);
        ClangResultFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> future = ClangdCodeCompletionProvider.clangdCompletionFuture(parameters, CompletionTriggerKind.Invoked, extraPositionOffset);
        try {
            Position completionCaretPosition = completionCaret != null ? ClangLanguageServiceUtils.offset2LspPos(editor.getDocument(), completionCaret.getOffset()) : new Position(0, 0);
            Ref atLeastOneElementAdded = Ref.create((Object)false);
            ProgressManager progressManager = ProgressManager.getInstance();
            ProgressIndicator completionProgressIndicator = progressManager.getProgressIndicator();
            CompletionStage accepted = future.asFuture().thenAcceptAsync(completionResult -> {
                assert (progressManager.getProgressIndicator() == null) : "Freshly created Java Thread has progress indicator?!";
                progressManager.runProcess(() -> {
                    if (completionResult != null) {
                        try {
                            atLeastOneElementAdded.set((Object)this.consume(parameters, result2, (Either<List<CLionCompletionItem>, CLionCompletionList>)completionResult, sourceChecker, charBeforePrefix, completionCaretPosition, extraPositionOffset, fragmentFilename));
                        }
                        catch (ExecutionException | TimeoutException exception) {
                            JsonSmartEnterProcessor.LOG.warn((Throwable)exception);
                        }
                    }
                }, (ProgressIndicator)ProgressWrapper.wrap((ProgressIndicator)completionProgressIndicator));
            });
            if (this.isClangdOnlyMode(project2)) {
                ClangdCodeCompletionProvider.runExtraCompletionContributors(parameters, result2, parameters.getInvocationCount(), allCarets.size() == 1);
                ClangdCodeCompletionProvider.waitForConsumerFinished((CompletableFuture<Void>)accepted);
                if (!((Boolean)atLeastOneElementAdded.get()).booleanValue() && parameters.getInvocationCount() <= 1 && !parameters.isAutoPopup()) {
                    ClangdCodeCompletionProvider.runExtraCompletionContributors(parameters, result2, 2, false);
                }
                result2.stopHere();
                return;
            }
            result2.runRemainingContributors(parameters, completionResult -> {
                LookupElement lookup = completionResult.getLookupElement();
                LookupElement elementToAdd = sourceChecker.createIdeaItemIfNeeded(lookup, item -> this.wrapLookup((LookupElement)item));
                if (elementToAdd != null) {
                    completionResult = completionResult.withLookupElement(elementToAdd);
                    result2.passResult(completionResult);
                }
            }, true, (CompletionSorter)sorter);
            ClangdCodeCompletionProvider.waitForConsumerFinished((CompletableFuture<Void>)accepted);
        }
        finally {
            future.release();
        }
    }

    private static class ItemSourceChecker {
        private final Map<Pair<String, Position>, LookupElement> fileOffsetCompletions = new HashMap<Pair<String, Position>, LookupElement>();
        private final Map<String, LookupElement> keywordStrings = new HashMap<String, LookupElement>();
        private final long startedTimestamp = System.currentTimeMillis();

        private ItemSourceChecker() {
        }

        @NotNull
        private static String trimKeywordLookup(@NotNull String lookupString) {
            return StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimStart((String)StringUtil.trimStart((String)lookupString.trim(), (String)"~"), (String)"#"), (String)";"), (String)"}").trim(), (String)"{").trim();
        }

        synchronized LookupElement createIdeaItemIfNeeded(LookupElement origLookup, Function<LookupElement, LookupElement> decorator) {
            LookupElement lookup = origLookup;
            if (lookup instanceof LookupElementDecorator) {
                lookup = ((LookupElementDecorator)lookup).getDelegate();
            }
            if (!(lookup instanceof LookupElementBuilder)) {
                return this.tryAddIdeaItemAsKeyword(origLookup, decorator);
            }
            LookupElementBuilder builder2 = (LookupElementBuilder)lookup;
            PsiElement psiElem = builder2.getPsiElement();
            if (!(psiElem instanceof OCSymbolDeclarator)) {
                return this.tryAddIdeaItemAsKeyword(origLookup, decorator);
            }
            OCSymbolDeclarator symbolDeclarator = (OCSymbolDeclarator)psiElem;
            Object symbol = symbolDeclarator.getSymbol();
            if (symbol == null || psiElem.getContainingFile() == null || psiElem.getContainingFile().getVirtualFile() == null || symbol instanceof OCLabelSymbol || ClangdCodeCompletionProvider.isMacro(symbol) || ClangdCodeCompletionProvider.isNamespace(symbol)) {
                return this.tryAddIdeaItemAsKeyword(origLookup, decorator);
            }
            VirtualFile file2 = psiElem.getContainingFile().getVirtualFile();
            Pair otherCompletion = ClangdCodeCompletionProvider.getSymbolCompletion(symbol, file2);
            if (otherCompletion == null) {
                return this.tryAddIdeaItemAsKeyword(origLookup, decorator);
            }
            OCSymbol realSymbol = ClangdCodeCompletionProvider.getRealSymbol((String)otherCompletion.first, (Position)otherCompletion.second, psiElem);
            if (realSymbol == null) {
                return this.tryAddIdeaItemAsKeyword(origLookup, decorator);
            }
            symbol = realSymbol;
            otherCompletion = ClangdCodeCompletionProvider.getSymbolCompletion(realSymbol, file2);
            Ref lookupElementRef = new Ref(null);
            if (otherCompletion != null) {
                lookupElementRef.set((Object)this.addIdeaItemIfNeeded(this.fileOffsetCompletions, otherCompletion, origLookup, decorator));
            }
            Object finalSymbol = symbol;
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)associated -> {
                LookupElement foundElement;
                if (associated.equals(finalSymbol)) {
                    return true;
                }
                VirtualFile associatedFile = associated.getContainingFile();
                Pair associatedCompletion = ClangdCodeCompletionProvider.getSymbolCompletion(associated, associatedFile != null ? associatedFile : file2);
                if (associatedCompletion != null && (foundElement = this.addIdeaItemIfNeeded(this.fileOffsetCompletions, associatedCompletion, origLookup, decorator)) == null) {
                    lookupElementRef.set(null);
                }
                return true;
            }), psiElem.getProject());
            return (LookupElement)lookupElementRef.get();
        }

        @Nullable
        synchronized LookupElement createClangdItemIfNeeded(@NotNull CLionCompletionItem completion, boolean clangdOnlyMode, @NotNull Function<CLionCompletionItem, LookupElement> builder2) {
            if (ClangdCodeCompletionProvider.isKeyword(completion) || ClangdCodeCompletionProvider.isHeaderFile(completion) || ClangdCodeCompletionProvider.isFolder(completion) || completion.getFromFile() == null || ClangdCodeCompletionProvider.isMacro(completion) || ClangdCodeCompletionProvider.isNamespace(completion)) {
                String keyText = completion.getTextEdit().getNewText();
                if (!clangdOnlyMode && (keyText.equals("public") || keyText.equals("private") || keyText.equals("protected"))) {
                    return null;
                }
                keyText = keyText.replace("<caret>", "").trim();
                if (ClangdCodeCompletionProvider.isPPDirective(completion)) {
                    keyText = '#' + keyText;
                } else if (ClangdCodeCompletionProvider.isHeaderFile(completion) && (keyText.endsWith("\"") || keyText.endsWith(">") || keyText.endsWith("/"))) {
                    keyText = keyText.substring(0, keyText.length() - 1);
                } else if (ClangdCodeCompletionProvider.isFolder(completion) && keyText.endsWith("/")) {
                    keyText = keyText.substring(0, keyText.length() - 1);
                } else if (ClangdCodeCompletionProvider.isMacro(completion) || ClangdCodeCompletionProvider.isNamespace(completion)) {
                    keyText = completion.getFilterText();
                }
                return this.addClangdItemIfNeeded(this.keywordStrings, ItemSourceChecker.trimKeywordLookup(keyText), () -> (LookupElement)builder2.apply(completion));
            }
            LookupElement addedAsKeyword = this.keywordStrings.get(ItemSourceChecker.trimKeywordLookup(completion.getFilterText()));
            if (addedAsKeyword != null && addedAsKeyword.getUserData(IDEA_TIMESTAMP) != null) {
                this.markAsClangdItem(addedAsKeyword);
                return null;
            }
            String filePath = completion.getFromFile();
            Pair clangdCompletion = new Pair((Object)ClangdCodeCompletionProvider.pathToCompare(filePath), (Object)completion.getFromFilePosition());
            LookupElement completionItem = this.addClangdItemIfNeeded(this.fileOffsetCompletions, clangdCompletion, () -> (LookupElement)builder2.apply(completion));
            if (completionItem != null) {
                this.keywordStrings.put(ItemSourceChecker.trimKeywordLookup(completion.getFilterText()), completionItem);
            }
            return completionItem;
        }

        private <T> LookupElement addClangdItemIfNeeded(@NotNull Map<T, LookupElement> existing, @NotNull T key, @NotNull Supplier<LookupElement> clangdItemBuilder) {
            LookupElement addedFromIdea = existing.get(key);
            if (addedFromIdea != null && addedFromIdea.getUserData(IDEA_TIMESTAMP) != null) {
                this.markAsClangdItem(addedFromIdea);
                return null;
            }
            LookupElement clangdItem = clangdItemBuilder.get();
            this.markAsClangdItem(clangdItem);
            existing.put(key, clangdItem);
            return clangdItem;
        }

        private LookupElement tryAddIdeaItemAsKeyword(@NotNull LookupElement element, @NotNull Function<LookupElement, LookupElement> decorator) {
            return this.addIdeaItemIfNeeded(this.keywordStrings, ItemSourceChecker.trimKeywordLookup(element.getLookupString()), element, decorator);
        }

        private <T> LookupElement addIdeaItemIfNeeded(@NotNull Map<T, LookupElement> existing, @NotNull T key, @NotNull LookupElement element, @NotNull Function<LookupElement, LookupElement> decorator) {
            LookupElement alreadyAdded = existing.get(key);
            if (alreadyAdded != null && alreadyAdded.getUserData(CLANGD_TIMESTAMP) != null) {
                this.markAsIdeaItem(alreadyAdded);
                return null;
            }
            LookupElement lookupElement = decorator.apply(element);
            this.markAsIdeaItem(lookupElement);
            existing.put(key, lookupElement);
            return lookupElement;
        }

        private void markAsClangdItem(@NotNull LookupElement element) {
            element.putUserDataIfAbsent(CLANGD_TIMESTAMP, (Object)((int)(System.currentTimeMillis() - this.startedTimestamp)));
        }

        private void markAsIdeaItem(@NotNull LookupElement element) {
            element.putUserDataIfAbsent(IDEA_TIMESTAMP, (Object)((int)(System.currentTimeMillis() - this.startedTimestamp)));
        }
    }
}

