/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.clang.CLionCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangUtils {
    public static final String CLANGD_PATH = "CLANGD_PATH";
    public static final Key<String> CLANGD_ARCHITECTURE = Key.create((String)"CLANGD_ARCHITECTURE");
    public static final Key<String> CLANGD_OS = Key.create((String)"CLANGD_OS");
    public static final Key<String> CLANGD_ENVIRONMENT = Key.create((String)"CLANGD_ENVIRONMENT");
    @NotNull
    static final Logger LOG = Logger.getInstance((String)ClangUtils.class.getName());
    private static final int MSVC_MAJOR_LENGTH = 2;
    private static final int MSVC_MINOR_LENGTH = 2;
    private static final Pattern VS_WARNINGS = Pattern.compile("^-[wW](?:[0-4]|d|e)[0-9]{4}$");
    private static final Key<Boolean> CLANGD_ON = Key.create((String)"CLANGD_ON");
    private static final Key<Boolean> CLANGD_CLANG_TIDY_ON = Key.create((String)"CLANG_TIDY_VIA_CLANGD_ON");
    private static final Key<Boolean> CLANGD_SHOW_ERRORS_ON = Key.create((String)"CLANGD_SHOW_ERRORS_ON");
    private static final Key<Boolean> CLANGD_NAVIGATION_ON = Key.create((String)"CLANGD_NAVIGATION_ON");
    private static final ScheduledExecutorService ourTimeoutHelper = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"TimeoutHelper");

    public static boolean isClangdAllowed(@NotNull Project project2) {
        return !ApplicationManager.getApplication().isUnitTestMode() || project2.getUserData(CLANGD_ON) == Boolean.TRUE;
    }

    @NotNull
    public static ClangCompilationCommand createCompilationCommand(@NotNull OCPsiFile ocFile, @NotNull CLionCompilationInfo info, boolean useInputFileAsEntryFile) throws IOException {
        CidrSwitchBuilder compilerOptions = new CidrSwitchBuilder();
        Application application = ApplicationManager.getApplication();
        Ref compilerExecutableRef = Ref.create();
        Ref compilerWorkingDirRef = Ref.create();
        Ref preprocessorDefinesRef = Ref.create();
        Ref inputFileRef = Ref.create();
        Ref entryFileRef = Ref.create();
        application.runReadAction(() -> {
            if (info.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            OCResolveConfiguration configuration = info.getConfiguration();
            OCLanguageKind languageKind = info.getLanguageKind();
            VirtualFile rootVirtualFile = info.getRootVirtualFile();
            OCCompilerKind compiler = info.getCompilerKind();
            File compilerExecutable = info.getCompilerExecutable();
            String ppDefines = configuration.getCompilerSettings(languageKind, rootVirtualFile).getPreprocessorDefines();
            if (compiler == MSVCCompilerKind.INSTANCE || compiler == ClangClCompilerKind.INSTANCE) {
                if (ppDefines.contains("__cplusplus")) {
                    compilerExecutableRef.set((Object)"clang++");
                } else {
                    compilerExecutableRef.set((Object)"clang");
                }
            } else {
                compilerExecutableRef.set((Object)compilerExecutable.getAbsolutePath());
            }
            compilerWorkingDirRef.set((Object)info.getCompilerWorkingDir());
            ClangUtils.addCompilerSwitches(ocFile, info, compilerOptions);
            ClangUtils.addIncludeDirectories(info, compilerOptions);
            preprocessorDefinesRef.set((Object)ppDefines);
            VirtualFile inputVirtualFile = ocFile.getVirtualFile() != null ? ocFile.getVirtualFile() : ocFile.getViewProvider().getVirtualFile();
            inputFileRef.set((Object)inputVirtualFile.getPath());
            entryFileRef.set((Object)rootVirtualFile.getPath());
            return null;
        });
        compilerOptions.addSingleRaw("-ferror-limit=0");
        String entryFile = useInputFileAsEntryFile ? (String)inputFileRef.get() : (String)entryFileRef.get();
        return new ClangCompilationCommand((String)inputFileRef.get(), entryFile, ((File)compilerWorkingDirRef.get()).getAbsolutePath(), (String)compilerExecutableRef.get(), compilerOptions.getArgs(), ClangUtils.preparePreprocessorDefines((String)preprocessorDefinesRef.get()));
    }

    private static void addCompilerSwitches(@NotNull OCPsiFile ocFile, @NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        OCCompilerSettings compilerSettings = ccInfo.getCompilerSettings();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches();
        if (compilerSwitches == null) {
            compilerSwitches = CidrCompilerSwitches.EMPTY;
        }
        compilerSwitches = ClangUtils.filterOutSearchPaths(compilerSwitches);
        compilerSwitches = ClangUtils.correctMsvcCppVersionIfNeeded(compilerSwitches);
        compilerSwitches = ClangUtils.filterOutOrFixUnknownArguments(ccInfo, compilerSwitches);
        compilerSwitches = ClangUtils.addGccConcepts(ccInfo, compilerSwitches);
        compilerSwitches = ClangUtils.filterOutErroneousFlags(compilerSwitches);
        switchBuilder.addAll(compilerSwitches);
        ClangUtils.addInputLanguageIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addTargetIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addCompatibilityModeIfNeeded(ccInfo, switchBuilder);
        ClangUtils.addCudaIncludeIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addCudaSwitches(ccInfo, switchBuilder);
        ClangUtils.applyUserFlags(ocFile, switchBuilder);
    }

    @NotNull
    private static CidrCompilerSwitches addGccConcepts(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches) {
        if (ccInfo.getCompilerKind() != GCCCompilerKind.INSTANCE) {
            return compilerSwitches;
        }
        ArrayList<String> flags = new ArrayList<String>(compilerSwitches.getList(CidrCompilerSwitches.Format.RAW));
        boolean hasConceptsFlag = flags.stream().anyMatch(it -> it.equals("-fconcepts"));
        if (!hasConceptsFlag) {
            return compilerSwitches;
        }
        int cxxStandardIdx = ContainerUtil.indexOf(flags, it -> it.startsWith("-std="));
        if (cxxStandardIdx == -1) {
            flags.add("-std=c++20");
        } else {
            flags.set(cxxStandardIdx, "-std=c++20");
        }
        flags.remove("-fconcepts");
        return new CidrCompilerSwitches(flags);
    }

    private static void addCudaSwitches(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo.getLanguageKind() != CUDALanguageKind.CUDA) {
            return;
        }
        switchBuilder.addSingleRaw("--cuda-device-only");
        switchBuilder.addSingleRaw("-fno-cuda-host-device-constexpr");
    }

    private static void addInputLanguageIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.equals("-x")) continue;
            return;
        }
        OCLanguageKind kind = ccInfo.getLanguageKind();
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c");
                    break;
                }
                case OBJ_C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c");
                    break;
                }
                case CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c++");
                    break;
                }
                case OBJ_CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c++");
                    break;
                }
                default: {
                    LOG.warn("Unexpected language kind: " + kind);
                    break;
                }
            }
        } else if (kind instanceof CUDALanguageKind) {
            switchBuilder.addSingleRaw("-x");
            switchBuilder.addSingleRaw("cuda");
        }
    }

    private static void addCompatibilityModeIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo.getCompilerKind() == OCCompilerKind.MSVC || ccInfo.getCompilerKind() == OCCompilerKind.CLANG_CL) {
            switchBuilder.addSingleRaw("-fms-compatibility");
        }
    }

    private static void addCudaIncludeIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo.getLanguageKind() != CUDALanguageKind.CUDA) {
            return;
        }
        List<String> flags = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
        if (!flags.contains("cuda_runtime.h")) {
            switchBuilder.addSingleRaw("-include");
            switchBuilder.addSingleRaw("cuda_runtime.h");
        }
        switchBuilder.addSingleRaw("-I" + ClangUtils.getClangCudaHeaderDir().getAbsolutePath() + "/cuda_wrappers");
        switchBuilder.addSingleRaw("-I" + ClangUtils.getClangCudaHeaderDir().getAbsolutePath());
    }

    private static List<Integer> findMsvcCppFlags(@NotNull List<String> flags) {
        ArrayList<Integer> foundIndeces = new ArrayList<Integer>();
        for (int i2 = 0; i2 < flags.size(); ++i2) {
            String flag = flags.get(i2);
            if (!flag.startsWith("/std:c++") && !flag.equals("-std:c++latest")) continue;
            foundIndeces.add(i2);
        }
        return foundIndeces;
    }

    @NotNull
    private static CidrCompilerSwitches correctMsvcCppVersionIfNeeded(@NotNull CidrCompilerSwitches compilerSwitches) {
        List<String> flags = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
        List<Integer> msvcFlagIndeces = ClangUtils.findMsvcCppFlags(flags);
        if (msvcFlagIndeces.isEmpty()) {
            return compilerSwitches;
        }
        ArrayList<String> updatedFlags = new ArrayList<String>(flags);
        for (int index : msvcFlagIndeces) {
            String cppFlag = (String)updatedFlags.get(index);
            if (cppFlag.endsWith("std:c++latest")) {
                updatedFlags.set(index, "-std=c++20");
                continue;
            }
            updatedFlags.set(index, "-" + cppFlag.substring(1));
        }
        return new CidrCompilerSwitches(updatedFlags);
    }

    private static void addTargetIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        boolean hasTargetRelatedParams = false;
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.startsWith("--target=")) continue;
            hasTargetRelatedParams = true;
            break;
        }
        if (!hasTargetRelatedParams) {
            String defines = ccInfo.getConfiguration().getCompilerSettings(ccInfo.getLanguageKind(), ccInfo.getRootVirtualFile()).getPreprocessorDefines();
            String architecture = ClangUtils.detectArchitecture(ccInfo.getProject(), defines);
            String vendor = "unknown";
            String os = ClangUtils.detectOS(ccInfo.getProject(), defines);
            String environment = ClangUtils.detectEnvironment(ccInfo.getProject(), defines);
            if (!(architecture == null || ApplicationManager.getApplication().isUnitTestMode() && os.equals("unknown"))) {
                switchBuilder.addSingleRaw("--target=" + architecture + "-" + vendor + "-" + os + "-" + environment);
            }
        }
    }

    @Nullable
    private static String detectArchitecture(@NotNull Project project2, @NotNull String defines) {
        String forced = (String)project2.getUserData(CLANGD_ARCHITECTURE);
        if (forced != null) {
            return forced;
        }
        String architecture = null;
        if (defines.contains("__x86_64__") || defines.contains("__amd64__") || defines.contains("_M_X64") || defines.contains("_M_AMD64")) {
            architecture = "x86_64";
        } else if (defines.contains("__i386__") || defines.contains("__i486__") || defines.contains("__i586__") || defines.contains("__i686__") || defines.contains("__i786__") || defines.contains("__i886__") || defines.contains("__i986__") || defines.contains("_M_IX86") || defines.contains("_M_I86") || defines.contains("__X86__") || defines.contains("__I86__") || defines.contains("_X86_")) {
            architecture = "i386";
        } else if (defines.contains("__arm__") || defines.contains("_M_ARM")) {
            architecture = "arm";
        } else if (defines.contains("__aarch64__")) {
            architecture = "arm64";
        } else if (defines.contains("__mips__")) {
            architecture = "mips";
        } else if (defines.contains("__powerpc__") || defines.contains("_M_PPC")) {
            architecture = "powerpc";
        } else if (defines.contains("__powerpc64__")) {
            architecture = "powerpc64";
        }
        return architecture;
    }

    @NotNull
    private static String detectOS(@NotNull Project project2, @NotNull String defines) {
        String forced = (String)project2.getUserData(CLANGD_OS);
        if (forced != null) {
            return forced;
        }
        if (defines.contains("__APPLE__") || defines.contains("__MACH__")) {
            return "darwin";
        }
        if (defines.contains("_WIN32") || defines.contains("_WIN64")) {
            return "windows";
        }
        if (defines.contains("__linux__")) {
            return "linux";
        }
        if (defines.contains("__FreeBSD__")) {
            return "freebsd";
        }
        return "unknown";
    }

    @NotNull
    private static String detectEnvironment(@NotNull Project project2, @NotNull String defines) {
        String forced = (String)project2.getUserData(CLANGD_ENVIRONMENT);
        if (forced != null) {
            return forced;
        }
        if (defines.contains("__CYGWIN__")) {
            return "cygnus";
        }
        if (defines.contains("__MINGW32__") || defines.contains("__MINGW64__")) {
            return "gnu";
        }
        if (defines.contains("_MSC_FULL_VER")) {
            String version;
            int versionStartPos = defines.indexOf("_MSC_FULL_VER") + "_MSC_FULL_VER".length() + 1;
            int versionEndPos = defines.indexOf(10, versionStartPos);
            if (versionStartPos >= 0 && versionEndPos >= 0 && (version = defines.substring(versionStartPos, versionEndPos)).length() > 4) {
                return "msvc" + version.substring(0, 2) + "." + version.substring(2, 4) + "." + version.substring(4);
            }
        }
        return "unknown";
    }

    private static String preparePreprocessorDefines(@NotNull String defines) {
        String[] definesArray = defines.split("\n");
        boolean isMSVC = SystemInfo.isWindows && Arrays.stream(definesArray).anyMatch(define -> define.contains("_MSC_VER"));
        Stream<String> definesStream = Arrays.stream(definesArray);
        definesStream = definesStream.filter(define -> {
            if (define.startsWith("#define __has_feature(") || define.startsWith("#define __has_extension(") || define.startsWith("#define __has_builtin(") || define.startsWith("#define __has_attribute(") || define.startsWith("#define __has_include(") || define.startsWith("#define __has_include_next(") || define.startsWith("#define __has_warning(") || define.startsWith("#define __is_identifier(") || define.startsWith("#define __building_module(") || define.startsWith("#define __has_cpp_attribute(") || define.startsWith("#define __has_c_attribute(") || define.startsWith("#define __has_declspec(") || define.startsWith("#define __is_target_arch(") || define.startsWith("#define __is_target_vendor(") || define.startsWith("#define __is_target_os(") || define.startsWith("#define __is_target_environment(") || define.startsWith("#define __is_target_variant_os(") || define.startsWith("#define __is_target_variant_environment(")) {
                return false;
            }
            if (define.startsWith("#define __builtin_va_start(list, paramN)") || define.startsWith("#define __builtin_va_arg(list, type)") || define.startsWith("#define __builtin_va_end(list)") || define.startsWith("#define __builtin_va_copy(dest, src)") || define.startsWith("#define __builtin_offsetof(type, member)") || define.startsWith("#define __builtin_types_compatible_p(X,Y)") || define.startsWith("#define __builtin_choose_expr(C,T,E)")) {
                return false;
            }
            return !define.startsWith("#define __extension__");
        });
        if (isMSVC) {
            Set msvcMacrosNames = MacrosNames.MSVC_MACORS_NAMES;
            definesStream = definesStream.filter(define -> {
                if (!define.startsWith("#define ")) {
                    return true;
                }
                Matcher matcher = MacrosNames.DEFINE_NAME.matcher((CharSequence)define);
                if (!matcher.find()) {
                    return true;
                }
                String macroName = matcher.group(1);
                return !msvcMacrosNames.contains(macroName);
            });
        }
        StringBuilder filteredDefines = new StringBuilder();
        definesStream.forEach(define -> filteredDefines.append((String)define).append("\n"));
        ClangUtils.appendUnsupportedBuiltins2Intrinsics(filteredDefines);
        return filteredDefines.toString();
    }

    private static void appendUnsupportedBuiltins2Intrinsics(@NotNull StringBuilder defines) {
        defines.append("#define __builtin_ia32_addps _mm_add_ps\n#define __builtin_ia32_addsd _mm_add_sd\n#define __builtin_ia32_addpd _mm_add_pd\n#define __builtin_ia32_addss _mm_add_ss\n#define __builtin_ia32_paddb128 _mm_add_epi8\n#define __builtin_ia32_paddw128 _mm_add_epi16\n#define __builtin_ia32_paddd128 _mm_add_epi32\n#define __builtin_ia32_paddq128 _mm_add_epi64\n#define __builtin_ia32_subps _mm_sub_ps\n#define __builtin_ia32_subsd _mm_sub_sd\n#define __builtin_ia32_subpd _mm_sub_pd\n#define __builtin_ia32_subss _mm_sub_ss\n#define __builtin_ia32_psubb128 _mm_sub_epi8\n#define __builtin_ia32_psubw128 _mm_sub_epi16\n#define __builtin_ia32_psubd128 _mm_sub_epi32\n#define __builtin_ia32_psubq128 _mm_sub_epi64\n#define __builtin_ia32_mulsd _mm_mul_sd\n#define __builtin_ia32_mulpd _mm_mul_pd\n#define __builtin_ia32_mulps _mm_mul_ps\n#define __builtin_ia32_mulss _mm_mul_ss\n#define __builtin_ia32_pmullw128 _mm_mullo_epi16\n#define __builtin_ia32_divsd _mm_div_sd\n#define __builtin_ia32_divpd _mm_div_pd\n#define __builtin_ia32_divps _mm_div_ps\n#define __builtin_ia32_subss _mm_div_ss\n#define __builtin_ia32_andpd _mm_and_pd\n#define __builtin_ia32_andps _mm_and_ps\n#define __builtin_ia32_pand128 _mm_and_si128\n#define __builtin_ia32_andnpd _mm_andnot_pd\n#define __builtin_ia32_andnps _mm_andnot_ps\n#define __builtin_ia32_pandn128 _mm_andnot_si128\n#define __builtin_ia32_orpd _mm_or_pd\n#define __builtin_ia32_orps _mm_or_ps\n#define __builtin_ia32_por128 _mm_or_si128\n#define __builtin_ia32_xorpd _mm_xor_pd\n#define __builtin_ia32_xorps _mm_xor_ps\n#define __builtin_ia32_pxor128 _mm_xor_si128\n#define __builtin_ia32_cvtps2dq _mm_cvtps_epi32\n#define __builtin_ia32_cvtsd2ss _mm_cvtsd_ss\n#define __builtin_ia32_cvtsi2sd _mm_cvtsi32_sd\n#define __builtin_ia32_cvtss2sd _mm_cvtss_sd\n#define __builtin_ia32_cvttsd2si _mm_cvttsd_si32\n#define __builtin_ia32_vec_ext_v2df _mm_cvtsd_f64\n#define __builtin_ia32_loadhpd _mm_loadh_pd\n#define __builtin_ia32_loadlpd _mm_loadl_pd\n#define __builtin_ia32_loadlv4si _mm_loadl_epi64\n#define __builtin_ia32_cmpeqps _mm_cmpeq_ps\n#define __builtin_ia32_cmpltps _mm_cmplt_ps\n#define __builtin_ia32_cmpleps _mm_cmple_ps\n#define __builtin_ia32_cmpgtps _mm_cmpgt_ps\n#define __builtin_ia32_cmpgeps _mm_cmpge_ps\n#define __builtin_ia32_cmpunordps _mm_cmpunord_ps\n#define __builtin_ia32_cmpneqps _mm_cmpneq_ps\n#define __builtin_ia32_cmpnltps _mm_cmpnlt_ps\n#define __builtin_ia32_cmpnleps _mm_cmpnle_ps\n#define __builtin_ia32_cmpngtps _mm_cmpngt_ps\n#define __builtin_ia32_cmpordps _mm_cmpord_ps\n#define __builtin_ia32_cmpeqss _mm_cmpeq_ss\n#define __builtin_ia32_cmpltss _mm_cmplt_ss\n#define __builtin_ia32_cmpless _mm_cmple_ss\n#define __builtin_ia32_cmpunordss _mm_cmpunord_ss\n#define __builtin_ia32_cmpneqss _mm_cmpneq_ss\n#define __builtin_ia32_cmpnltss _mm_cmpnlt_ss\n#define __builtin_ia32_cmpnless _mm_cmpnle_ss\n#define __builtin_ia32_cmpngtss _mm_cmpngt_ss\n#define __builtin_ia32_cmpngess _mm_cmpnge_ss\n#define __builtin_ia32_cmpordss _mm_cmpord_ss\n#define __builtin_ia32_movss _mm_move_ss\n#define __builtin_ia32_movsd _mm_move_sd\n#define __builtin_ia32_movhlps _mm_movehl_ps\n#define __builtin_ia32_movlhps _mm_movelh_ps\n#define __builtin_ia32_movqv4si _mm_move_epi64\n#define __builtin_ia32_unpckhps _mm_unpackhi_ps\n#define __builtin_ia32_unpckhpd _mm_unpackhi_pd\n#define __builtin_ia32_punpckhbw128 _mm_unpackhi_epi8\n#define __builtin_ia32_punpckhwd128 _mm_unpackhi_epi16\n#define __builtin_ia32_punpckhdq128 _mm_unpackhi_epi32\n#define __builtin_ia32_punpckhqdq128 _mm_unpackhi_epi64\n#define __builtin_ia32_unpcklps _mm_unpacklo_ps\n#define __builtin_ia32_unpcklpd _mm_unpacklo_pd\n#define __builtin_ia32_punpcklbw128 _mm_unpacklo_epi8\n#define __builtin_ia32_punpcklwd128 _mm_unpacklo_epi16\n#define __builtin_ia32_punpckldq128 _mm_unpacklo_epi32\n#define __builtin_ia32_punpcklqdq128 _mm_unpacklo_epi64\n#define __builtin_ia32_cmpeqpd _mm_cmpeq_pd\n#define __builtin_ia32_cmpltpd _mm_cmplt_pd\n#define __builtin_ia32_cmplepd _mm_cmple_pd\n#define __builtin_ia32_cmpgtpd _mm_cmpgt_pd\n#define __builtin_ia32_cmpgepd _mm_cmpge_pd\n#define __builtin_ia32_cmpunordpd _mm_cmpunord_pd\n#define __builtin_ia32_cmpneqpd _mm_cmpneq_pd\n#define __builtin_ia32_cmpnltpd _mm_cmpnlt_pd\n#define __builtin_ia32_cmpnlepd _mm_cmpnle_pd\n#define __builtin_ia32_cmpngtpd _mm_cmpngt_pd\n#define __builtin_ia32_cmpngepd _mm_cmpnge_pd\n#define __builtin_ia32_cmpordpd _mm_cmpord_pd\n#define __builtin_ia32_cmpeqsd _mm_cmpeq_sd\n#define __builtin_ia32_cmpltsd _mm_cmplt_sd\n#define __builtin_ia32_cmplesd _mm_cmple_sd\n#define __builtin_ia32_cmpunordsd _mm_cmpunord_sd\n#define __builtin_ia32_cmpneqsd _mm_cmpneq_sd\n#define __builtin_ia32_cmpnltsd _mm_cmpnlt_sd\n#define __builtin_ia32_cmpnlesd _mm_cmpnle_sd\n#define __builtin_ia32_cmpordsd _mm_cmpord_sd\n#define __builtin_ia32_cvtsi642ss _mm_cvtsi64_ss\n#define __builtin_ia32_cvttss2si64 _mm_cvtss_si64\n#define __builtin_ia32_shufpd _mm_shuffle_pd\n#define __builtin_ia32_pshufhw _mm_shufflehi_epi16\n#define __builtin_ia32_pshuflw _mm_shufflelo_epi16\n#define __builtin_ia32_pshufd _mm_shuffle_epi32\n#define __builtin_ia32_movshdup _mm_movehdup_ps\n#define __builtin_ia32_movsldup _mm_moveldup_ps\n#define __builtin_ia32_maxps _mm_max_ps\n#define __builtin_ia32_pslldi128 _mm_slli_epi32\n#define __builtin_ia32_vec_set_v16qi _mm_insert_epi8\n#define __builtin_ia32_vec_set_v8hi _mm_insert_epi16\n#define __builtin_ia32_vec_set_v4si _mm_insert_epi32\n#define __builtin_ia32_vec_set_v2di _mm_insert_epi64\n#define __builtin_ia32_vec_ext_v16qi _mm_extract_epi8\n#define __builtin_ia32_vec_ext_v8hi _mm_extract_epi16\n#define __builtin_ia32_vec_ext_v4si _mm_extract_epi32\n#define __builtin_ia32_vec_ext_v2di _mm_extract_epi64\n#define __builtin_ia32_vec_ext_v4sf _mm_extract_ps\n");
    }

    private static void applyUserFlags(@NotNull OCPsiFile ocFile, @NotNull CidrSwitchBuilder switchBuilder) {
        ClangdSettings settings = ClangdSettings.getInstance(ocFile.getProject());
        List userFlags = ContainerUtil.map((Collection)StringUtil.split((String)settings.getClangFlags(), (String)","), StringUtil::trim);
        List disabledWarnings = (List)ocFile.getProject().getUserData(ClangdSettings.DISABLED_WARNINGS);
        if (!ContainerUtil.isEmpty((Collection)userFlags)) {
            for (String flag : userFlags) {
                if (ClangUtils.isWarningOption(flag)) {
                    String warnOptName = ClangUtils.getWarningName(flag);
                    if (disabledWarnings != null && disabledWarnings.contains(warnOptName)) continue;
                }
                switchBuilder.addSingleRaw(flag);
            }
        }
    }

    @NotNull
    private static CidrCompilerSwitches filterOutSearchPaths(@NotNull CidrCompilerSwitches compilerSwitches) {
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            private boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    return false;
                }
                if (parameter.equals("-F") || parameter.equals("-I") || parameter.equals("-iquote")) {
                    this.skipOptionValue = true;
                    return false;
                }
                if (parameter.startsWith("-F") || parameter.startsWith("-I") || parameter.startsWith("-iquote")) {
                    return false;
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions(filter);
    }

    @NotNull
    private static CidrCompilerSwitches filterOutErroneousFlags(@NotNull CidrCompilerSwitches compilerSwitches) {
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            boolean skipNext = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipNext) {
                    this.skipNext = false;
                    return false;
                }
                if (parameter.equals("-include-pch")) {
                    this.skipNext = true;
                    return false;
                }
                if (parameter.equals("-fconcepts")) {
                    return false;
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions(filter);
    }

    @NotNull
    private static CidrCompilerSwitches filterOutOrFixUnknownArguments(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches) {
        if (ccInfo.getCompilerKind() != MSVCCompilerKind.INSTANCE && ccInfo.getCompilerKind() != ClangClCompilerKind.INSTANCE) {
            return compilerSwitches;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        List<String> switches = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
        boolean addNext = false;
        for (String aSwitch : switches) {
            String parameter = aSwitch.trim();
            if (addNext) {
                filtered.add(parameter);
                addNext = false;
                continue;
            }
            if (ClangUtils.fixParameterWithArgument(parameter, filtered, "/D", "-D")) {
                addNext = true;
                continue;
            }
            if (ClangUtils.fixGluedParameter(parameter, filtered, "/D", "-D")) continue;
            if (ClangUtils.fixParameterWithArgument(parameter, filtered, "/FI", "-include")) {
                addNext = true;
                continue;
            }
            if (ClangUtils.fixGluedParameter(parameter, filtered, "/FI", "-include") || parameter.startsWith("/") || parameter.startsWith("@") || VS_WARNINGS.matcher(parameter).matches() || parameter.equalsIgnoreCase("-bigobj")) continue;
            filtered.add(parameter);
        }
        return filtered.isEmpty() ? CidrCompilerSwitches.EMPTY : new CidrCompilerSwitches(filtered);
    }

    private static boolean fixGluedParameter(@NotNull String parameter, @NotNull List<String> filtered, @NotNull String from, @NotNull String to) {
        if (parameter.startsWith(from) && parameter.length() > from.length()) {
            filtered.add(to + parameter.substring(from.length()));
            return true;
        }
        return false;
    }

    private static boolean fixParameterWithArgument(@NotNull String parameter, @NotNull List<String> filtered, @NotNull String from, @NotNull String to) {
        if (parameter.equals(from)) {
            filtered.add(to);
            return true;
        }
        return false;
    }

    private static void addIncludeDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        ClangUtils.addIncludeDirectories(info, switchBuilder, info.getRootVirtualFile().getParent(), false);
    }

    public static void addIncludeDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder, @Nullable VirtualFile parentDirectory, boolean restrictToClang) {
        ClangSwitchBuilder clangSwitchBuilder = new ClangSwitchBuilder(switchBuilder);
        if (parentDirectory != null && parentDirectory.isDirectory()) {
            clangSwitchBuilder.withQuoteIncludePath(parentDirectory.getPath());
        }
        for (HeadersSearchPath path : info.getHeaderPaths()) {
            if (restrictToClang) {
                clangSwitchBuilder.withSwitch("-Xclang");
            }
            clangSwitchBuilder.withHeaderSearchPath(path);
        }
    }

    @NotNull
    public static Pair<File, Boolean> getClangdPath() {
        boolean customClangd = true;
        File clangdPath = ClangUtils.getCustomClangdPath();
        if (clangdPath == null) {
            customClangd = false;
            clangdPath = ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "clangd.exe" : "clangd");
        }
        return Pair.create((Object)clangdPath, (Object)customClangd);
    }

    @Nullable
    private static File getCustomClangdPath() {
        String path = System.getProperty(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        path = System.getenv(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    @NotNull
    public static File getBuiltinClangToolPath(@NotNull String toolName) {
        return CidrPathManager.getBinPath(ClangUtils.class, "clion/bin", "clang/" + CidrPathManager.getPlatformRelativePath(toolName), null).toFile();
    }

    @NotNull
    public static File getClangCudaHeaderDir() {
        return ClangUtils.getBuiltinClangToolPath("cuda_includes");
    }

    private static boolean isWarningOption(@NotNull String option) {
        return option.startsWith("-W");
    }

    private static boolean isWarningOptionOn(@NotNull String warning) {
        assert (ClangUtils.isWarningOption(warning));
        return !warning.startsWith("-Wno-");
    }

    private static boolean isWarningOptionOff(@NotNull String warning) {
        return !ClangUtils.isWarningOptionOn(warning);
    }

    @NotNull
    private static String getWarningName(@NotNull String warningOption) {
        assert (ClangUtils.isWarningOption(warningOption));
        return ClangUtils.isWarningOptionOn(warningOption) ? warningOption.substring("-W".length()) : warningOption.substring("-Wno-".length());
    }

    @NotNull
    private static String makeWarningOn(@NotNull String warningOptName) {
        assert (!ClangUtils.isWarningOption(warningOptName));
        return "-W" + warningOptName;
    }

    @NotNull
    private static String makeWarningOff(@NotNull String warningOptName) {
        assert (!ClangUtils.isWarningOption(warningOptName));
        return "-Wno-" + warningOptName;
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Supplier<String> logTask) {
        if (ClangDebugLevel.isWarnOrMore()) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.warn(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull String msg) {
        if (ClangDebugLevel.isWarnOrMore()) {
            logger.warn(msg);
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Throwable ex) {
        if (ClangDebugLevel.isWarnOrMore()) {
            logger.warn(ex);
        }
    }

    public static void infoClangd(@NotNull Logger logger, @NotNull Supplier<String> logTask) {
        if (ClangDebugLevel.isInfoOrMore()) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.info(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void infoClangd(@NotNull Logger logger, @NotNull String msg) {
        if (ClangDebugLevel.isInfoOrMore()) {
            logger.info(msg);
        }
    }

    public static boolean isClangdOn(@NotNull Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode() || ClangUtils.hasKey(CLANGD_ON, project2)) {
            return ClangUtils.getKey(CLANGD_ON, project2);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isClangdOn();
    }

    public static void forceClangdOn(@NotNull Project project2) {
        project2.putUserData(CLANGD_ON, (Object)true);
    }

    public static void forceClangdOff(@NotNull Project project2) {
        project2.putUserData(CLANGD_ON, (Object)false);
    }

    public static void nonForceClangd(@NotNull Project project2) {
        project2.putUserData(CLANGD_ON, null);
    }

    public static boolean isClangTidyViaClangdOn(@NotNull Project project2) {
        if (ClangUtils.hasKey(CLANGD_CLANG_TIDY_ON, project2)) {
            return ClangUtils.getKey(CLANGD_CLANG_TIDY_ON, project2);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isClangdOn() && settings.isClangTidyViaClangd();
    }

    public static void forceClangTidyViaClangdOn(@NotNull Project project2) {
        project2.putUserData(CLANGD_CLANG_TIDY_ON, (Object)true);
    }

    public static void forceClangTidyViaClangdOff(@NotNull Project project2) {
        project2.putUserData(CLANGD_CLANG_TIDY_ON, (Object)false);
    }

    public static boolean isClangTidyViaClangdForced(@Nullable Project project2) {
        return project2 != null && project2.getUserData(CLANGD_CLANG_TIDY_ON) != null;
    }

    public static void forceClangdShowErrorsOn(@NotNull Project project2) {
        project2.putUserData(CLANGD_SHOW_ERRORS_ON, (Object)true);
    }

    public static void forceClangdShowErrorsOff(@NotNull Project project2) {
        project2.putUserData(CLANGD_SHOW_ERRORS_ON, (Object)false);
    }

    public static void nonForceClangdShowErrors(@NotNull Project project2) {
        project2.putUserData(CLANGD_SHOW_ERRORS_ON, null);
    }

    public static boolean isClangdShowErrors(@NotNull Project project2) {
        if (ClangUtils.hasKey(CLANGD_SHOW_ERRORS_ON, project2)) {
            return ClangUtils.getKey(CLANGD_SHOW_ERRORS_ON, project2);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isClangdShowErrors();
    }

    public static void forceClangdNavigationOn(@NotNull Project project2) {
        project2.putUserData(CLANGD_NAVIGATION_ON, (Object)true);
    }

    public static void forceClangdNavigationOff(@NotNull Project project2) {
        project2.putUserData(CLANGD_NAVIGATION_ON, (Object)false);
    }

    public static void stopForcingClangdNavigation(@NotNull Project project2) {
        project2.putUserData(CLANGD_NAVIGATION_ON, null);
    }

    public static boolean isNavigationViaClangd(@NotNull Project project2) {
        if (ClangUtils.hasKey(CLANGD_NAVIGATION_ON, project2)) {
            return ClangUtils.getKey(CLANGD_NAVIGATION_ON, project2);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isNavigationViaClangd();
    }

    private static boolean hasKey(@NotNull Key<?> projectKey, @Nullable Project project2) {
        if (project2 != null) {
            Object forced = project2.getUserData(projectKey);
            return forced != null;
        }
        return false;
    }

    private static boolean getKey(@NotNull Key<Boolean> projectKey, @Nullable Project project2) {
        Boolean forced;
        if (project2 != null && (forced = (Boolean)project2.getUserData(projectKey)) != null) {
            return forced;
        }
        return false;
    }

    private static ProgressIndicator prepareIndicatorToBeCancelledByWA(boolean hasTimeout, @NotNull Disposable clangdActionHolder) {
        Application application = ApplicationManager.getApplication();
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null && !hasTimeout && !application.isUnitTestMode()) {
            String msg = "Not cancellable waiting?";
            CidrLogService.logOnce(Level.WARNING, msg, new Exception(msg));
        }
        if (indicator != null && !application.isDispatchThread() && application.isReadAccessAllowed()) {
            application.addApplicationListener(new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (indicator.isRunning()) {
                        indicator.cancel();
                    }
                }
            }, clangdActionHolder);
        }
        return indicator;
    }

    @Nullable
    public static <T> T waitForClangFuture(@NotNull Future<? extends Supplier<? extends T>> future) throws ExecutionException {
        Supplier<? extends T> supplier = ClangUtils.waitCancelAware(future, "clang future");
        return supplier != null ? (T)supplier.get() : null;
    }

    @Nullable
    public static <T> T waitForClangFuture(@NotNull Future<? extends Supplier<? extends T>> future, long timoutMs) throws ExecutionException, TimeoutException {
        Supplier<? extends T> supplier = ClangUtils.waitCancelAware(future, timoutMs, "clang future");
        return supplier != null ? (T)supplier.get() : null;
    }

    public static <T> T waitCancelAware(@NotNull Future<T> clangFuture, @NotNull String waitingFor) throws ExecutionException {
        while (true) {
            try {
                return ClangUtils.waitCancelAware(clangFuture, Long.MAX_VALUE, waitingFor);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static <T> T waitCancelAware(@NotNull Future<T> clangFuture, long timeoutMs, @NotNull String waitingFor) throws ExecutionException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 10[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isInternalException(@NotNull Exception ex) {
        String message = ex.getMessage();
        return message != null && (message.contains("trying to get AST for non-added document") || message.contains("invalid AST"));
    }

    private static boolean isServerException(@NotNull ExecutionException ex) {
        return ex.getCause() instanceof ResponseErrorException || ex.getCause() instanceof JsonRpcException;
    }

    public static void logServerException(@NotNull Logger logger, @NotNull String message, @NotNull ExecutionException ex) {
        if (ClangUtils.isServerException(ex)) {
            CidrLogService.logOnce(Level.WARNING, message, ex);
        } else if (ex.getCause() instanceof TimeoutException) {
            logger.warn(message, (Throwable)ex);
        } else {
            logger.error(message, (Throwable)ex);
        }
    }

    @Nullable
    public static <T> T getIfCompletedNormally(@NotNull CompletableFuture<T> future) {
        if (future.isDone() && !future.isCancelled() && !future.isCompletedExceptionally()) {
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.warn("How is it possible?!", (Throwable)ex);
            }
        }
        return null;
    }

    @Nullable
    public static LineColumn getLineColumn(@NotNull PsiFile file2, int offset) {
        if (file2 instanceof OCCodeFragment) {
            OCCodeFragment fragment = (OCCodeFragment)file2;
            CharSequence contents = fragment.getViewProvider().getContents();
            return StringUtil.offsetToLineColumn((CharSequence)contents, (int)offset);
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null) {
            return null;
        }
        int line = doc.getLineNumber(offset);
        int column = offset - doc.getLineStartOffset(line) + 1;
        return LineColumn.of((int)line, (int)column);
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeoutInSeconds) {
        return ClangUtils.timeoutAfter(timeoutInSeconds, null);
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeoutInSeconds, T completeValue) {
        return ClangUtils.timeoutAfter(timeoutInSeconds, TimeUnit.SECONDS, completeValue);
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeout, TimeUnit unit, T completeValue) {
        CompletableFuture result2 = new CompletableFuture();
        ourTimeoutHelper.schedule(() -> result2.complete(completeValue), timeout, unit);
        return result2;
    }

    public static <T> void tie(@NotNull CompletableFuture<T> first, @NotNull CompletableFuture<T> second) {
        ClangUtils.propagate(first, second);
        ClangUtils.propagate(second, first);
    }

    private static <T> void propagate(@NotNull CompletableFuture<T> from, @NotNull CompletableFuture<T> to) {
        from.whenComplete((res, ex) -> {
            if (!to.isDone()) {
                if (ex != null) {
                    to.completeExceptionally((Throwable)ex);
                } else {
                    to.complete(res);
                }
            }
        });
    }

    public static <T> CompletableFuture<T> exceptTimeoutAfter(long timeoutInSeconds) {
        return ClangUtils.exceptTimeoutAfter(timeoutInSeconds, TimeUnit.SECONDS);
    }

    public static <T> CompletableFuture<T> exceptTimeoutAfter(long timeout, TimeUnit unit) {
        CompletableFuture result2 = new CompletableFuture();
        ourTimeoutHelper.schedule(() -> result2.completeExceptionally(new TimeoutException()), timeout, unit);
        return result2;
    }

    public static CompletableFuture<String> getClangToolVersionAsync(final @NotNull String toolName, final @NotNull String path, @NotNull ProgressIndicator indicator) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        Task.Backgroundable task2 = new Task.Backgroundable(null, OCInspectionsBundle.message("configurable.clangTool.version.task.title", toolName)){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    CapturingProcessHandler processHandler = new CapturingProcessHandler(new GeneralCommandLine(new String[]{path, "--version"}));
                    String processOutput = processHandler.runProcessWithProgressIndicator(indicator).getStdout();
                    ProgressManager.checkCanceled();
                    future.complete(processOutput.trim());
                }
                catch (com.intellij.execution.ExecutionException e) {
                    LOG.debug("Failed to check builtin " + toolName + " version", (Throwable)e);
                    future.complete(null);
                }
                catch (ProcessCanceledException e) {
                    LOG.debug("Failed to check builtin " + toolName + " version", (Throwable)e);
                    future.completeExceptionally(e);
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, indicator);
        return future;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static CidrCompilerSwitches filterClangdCUDAFlags(@Nullable CidrCompilerSwitches compilerSwitches, @NotNull OCLanguageKind languageKind) {
        if (compilerSwitches == null) {
            return null;
        }
        if (!languageKind.isCuda()) {
            return compilerSwitches;
        }
        final List<String> skipSwitches = Arrays.asList("--cuda-gpu-arch", "--cuda-path", "-g");
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(){
            boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                boolean tokenIsSwitch = parameter.startsWith("-");
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (skipSwitches.contains(parameter)) {
                    this.skipOptionValue = true;
                    return false;
                }
                if (skipSwitches.stream().anyMatch(it -> parameter.startsWith((String)it))) {
                    return false;
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions(argumentsFilter2);
    }

    @Nullable
    public static TextRange findIdentifierRange(@NotNull CharSequence text, int offset) {
        if (offset >= 0 && offset < text.length() && ClangUtils.isCppIdentifierPart(text.charAt(offset))) {
            int curOffset;
            for (curOffset = offset; curOffset >= 0 && ClangUtils.isCppIdentifierPart(text.charAt(curOffset)); --curOffset) {
            }
            ++curOffset;
            while (Character.isDigit(text.charAt(curOffset)) && curOffset < offset) {
                ++curOffset;
            }
            if (ClangUtils.isCppIdentifierStart(text.charAt(curOffset))) {
                int startRange = curOffset;
                for (curOffset = offset; curOffset < text.length() && ClangUtils.isCppIdentifierPart(text.charAt(curOffset)); ++curOffset) {
                }
                int endRange = curOffset;
                return new TextRange(startRange, endRange);
            }
        }
        return null;
    }

    private static boolean isCppIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static boolean isCppIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static class NotAllowedException
    extends RuntimeException {
        public NotAllowedException() {
            super("Call 'forceClangdOn()' in your test");
        }
    }

    private static class MacrosNames {
        @NotNull
        private static final Set<String> MSVC_MACORS_NAMES = new HashSet<String>(MSVCCompilerKt.getBuiltinMacrosNames());
        @NotNull
        private static final Pattern DEFINE_NAME = Pattern.compile("#define ([\\w]+)");

        private MacrosNames() {
        }
    }

    public static final class ClangCompilationCommand {
        @NotNull
        public final String inputFile;
        @NotNull
        public final String entryFile;
        @NotNull
        public final String workingDir;
        @NotNull
        public final String compilerExecutable;
        @NotNull
        public final List<String> compilerOptions;
        @Nullable
        public final String preprocessorDefines;

        public ClangCompilationCommand(@NotNull String inputFile, @NotNull String entryFile, @NotNull String workingDir, @NotNull String compilerExecutable, @NotNull List<String> compilerOptions, @Nullable String defines) {
            this.inputFile = inputFile;
            this.entryFile = entryFile;
            this.workingDir = workingDir;
            this.compilerExecutable = compilerExecutable;
            this.compilerOptions = Collections.unmodifiableList(compilerOptions);
            this.preprocessorDefines = defines;
        }

        @NotNull
        public ClangCompilationCommand derive(String ... moreOptions) {
            ArrayList<String> newOptions = new ArrayList<String>(this.compilerOptions.size() + moreOptions.length);
            newOptions.addAll(this.compilerOptions);
            newOptions.addAll(Arrays.asList(moreOptions));
            return new ClangCompilationCommand(this.inputFile, this.entryFile, this.workingDir, this.compilerExecutable, newOptions, this.preprocessorDefines);
        }
    }
}

