/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.CidrLogService;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public enum ClangDebugLevel {
    OFF(0),
    WARN(1),
    INFO(2);

    private final int priority;

    private ClangDebugLevel(int priority) {
        this.priority = priority;
    }

    @NotNull
    public static ClangDebugLevel getCurrentLevel() {
        try {
            switch (Registry.get((String)"clion.clang.clangd.debug").asString()) {
                case "false": 
                case "0": {
                    return OFF;
                }
                case "true": 
                case "1": {
                    return WARN;
                }
                case "2": {
                    return INFO;
                }
            }
        }
        catch (Throwable ex) {
            CidrLogService.logOnce(Level.WARNING, "Either add \"clion.clang.clangd.debug\" registry key, or don't use " + ClangDebugLevel.class.getSimpleName(), ex);
        }
        return OFF;
    }

    public static boolean isOff() {
        return ClangDebugLevel.getCurrentLevel() == OFF;
    }

    public static boolean isWarnOrMore() {
        return ClangDebugLevel.getCurrentLevel().priority >= ClangDebugLevel.WARN.priority;
    }

    public static boolean isInfoOrMore() {
        return ClangDebugLevel.getCurrentLevel().priority >= ClangDebugLevel.INFO.priority;
    }

    public static void setLevel(@NotNull ClangDebugLevel level) {
        Registry.get((String)"clion.clang.clangd.debug").setValue(level.priority);
    }
}

