/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLocalSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile file2) {
        return OCLanguageUtils.isSupported(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        OCFile ocFile = OCLanguageUtils.asOCFile(file2);
        ocFile.pushAnnotationSession(new AnnotationSession((PsiFile)ocFile));
        try {
            boolean bl = super.analyze(file2, updateWholeFile, holder, action);
            return bl;
        }
        finally {
            ocFile.popAnnotationSession();
        }
    }

    public void visit(@NotNull PsiElement element) {
        if (element instanceof OCReferenceElement) {
            if (OCElementUtil.getElementType(element.getFirstChild()) == OCTokenTypes.THIS_CPP_KEYWORD || ((OCNamespaceQualifierOwner)element).getNamespaceQualifier() != null || element.getParent() instanceof OCTypeElement || element instanceof OCMacroReferenceElementImpl) {
                return;
            }
            this.processCandidate(((OCReferenceElement)element).getName(), element);
        } else if (element instanceof OCLocalSymbolDeclarator && element instanceof PsiNameIdentifierOwner) {
            OCCallable context2 = OCRainbowVisitor.getElementContext(element);
            if (context2 == null) {
                return;
            }
            PsiNameIdentifierOwner identifierOwner = (PsiNameIdentifierOwner)element;
            PsiElement identifier = identifierOwner.getNameIdentifier();
            if ((context2 instanceof PsiNameIdentifierOwner || context2 instanceof OCFunctionDeclaration) && (context2 instanceof PsiNameIdentifierOwner && identifier == ((PsiNameIdentifierOwner)context2).getNameIdentifier() || context2 instanceof OCFunctionDeclaration && identifier == ((OCFunctionDeclaration)context2).getNameIdentifier())) {
                return;
            }
            this.processCandidate(identifierOwner.getName(), identifier);
        }
    }

    @Contract(value="null -> null")
    private static OCCallable getElementContext(@Nullable PsiElement element) {
        return (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
    }

    @NotNull
    public HighlightVisitor clone() {
        return new OCRainbowVisitor();
    }

    void processCandidate(@Nullable String symbolNameToFind, @Nullable PsiElement element) {
        if (element == null || symbolNameToFind == null) {
            return;
        }
        OCResolveUtil.processLocalSymbols(symbolNameToFind, element, (Processor<OCSymbol>)((Processor)symbol -> {
            OCCallable context2;
            PsiElement idLeaf;
            PsiFile file2;
            OCSymbolKind symbolKind = symbol.getKind();
            TextAttributesKey tak = null;
            switch (symbolKind) {
                case LOCAL_VARIABLE: 
                case CATCH_EXCEPTION_VARIABLE: {
                    tak = OCHighlightingKeys.LOCAL_VARIABLE;
                    break;
                }
                case PARAMETER: {
                    if (symbol instanceof OCThisSelfSuperSymbol) break;
                    tak = OCHighlightingKeys.PARAMETER;
                }
            }
            if (tak != null && (file2 = symbol.getContainingPsiFile(element.getProject())) != null && !((idLeaf = PsiTreeUtil.firstChild((PsiElement)element)) instanceof ForeignLeafPsiElement) && (context2 = OCRainbowVisitor.getElementContext(file2.findElementAt(symbol.getOffset()))) != null) {
                this.addInfo(this.getInfo(context2, idLeaf, symbol.getName(), tak));
                return false;
            }
            return true;
        }), true);
    }
}

