/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCLegacyAnnotator
extends OCAnnotator {
    private static final OCAnnotatorEnabler DEFAULT_ENABLER = new OCAnnotatorEnabler(true, true);
    private static final Key<OCAnnotatorEnabler> CLANGD_ANNOTATOR_ENABLER = Key.create((String)"CLANGD_ANNOTATOR_ENABLER");

    public static void enable(@NotNull Project project2, boolean enabledIfLegacy, boolean legacyIfObjC) {
        project2.putUserData(CLANGD_ANNOTATOR_ENABLER, (Object)new OCAnnotatorEnabler(enabledIfLegacy, legacyIfObjC));
    }

    public static void stopEnabling(@NotNull Project project2) {
        project2.putUserData(CLANGD_ANNOTATOR_ENABLER, null);
    }

    public static boolean isEnabledFor(@NotNull PsiFile file2) {
        OCAnnotatorEnabler enabler = (OCAnnotatorEnabler)file2.getProject().getUserData(CLANGD_ANNOTATOR_ENABLER);
        return enabler == null || enabler.isEnabled(file2);
    }

    @Override
    protected boolean isEnabled(@NotNull PsiFile file2) {
        return super.isEnabled(file2) && OCLegacyAnnotator.getEnabler(file2.getProject(), this.getHolder()).isEnabled(file2);
    }

    @NotNull
    private static OCAnnotatorEnabler getEnabler(@NotNull Project project2, @Nullable AnnotationHolder holder) {
        OCAnnotatorEnabler projectEnabler;
        if (!(holder != null && holder.isBatchMode() || (projectEnabler = (OCAnnotatorEnabler)project2.getUserData(CLANGD_ANNOTATOR_ENABLER)) == null)) {
            return projectEnabler;
        }
        return DEFAULT_ENABLER;
    }

    private static class OCAnnotatorEnabler {
        private final boolean myIsLegacyEnabled;
        private final boolean myLegacyIfObjc;

        private OCAnnotatorEnabler(boolean isLegacyEnabled, boolean legacyIfObjc) {
            this.myIsLegacyEnabled = isLegacyEnabled;
            this.myLegacyIfObjc = legacyIfObjc;
        }

        private boolean isEnabled(@NotNull PsiFile file2) {
            if (this.myLegacyIfObjc && file2 instanceof OCFile && ((OCFile)file2).getKind().isObjC()) {
                return true;
            }
            return this.myIsLegacyEnabled;
        }
    }
}

