/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBoxedExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.Nullable;

public class OCConstantExpressionVisitor
extends OCRecursiveVisitor {
    private boolean wasAmpersand;
    private boolean myConst;

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression) {
        if (expression.isGetAddress()) {
            this.wasAmpersand = true;
        }
        this.visitExpression(expression);
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
        if (this.wasAmpersand) {
            this.visitExpression(expression);
        } else {
            this.nonConstExpression(expression);
            this.myConst = false;
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expression) {
        if (this.wasAmpersand) {
            this.wasAmpersand = false;
            return;
        }
        OCSymbol symbol = expression.resolveToSymbol();
        if (symbol != null) {
            if (symbol instanceof OCTypeParameterSymbol) {
                return;
            }
            if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                OCType type = symbol.getResolvedType(OCResolveContext.forPsi(expression));
                if (OCConstantExpressionVisitor.isNonConstTypeConversion(type, expression)) {
                    this.nonConstExpression(expression);
                    this.myConst = false;
                }
            } else if (!this.isConstDeclarator(expression, symbol)) {
                this.nonConstExpression(expression);
                this.myConst = false;
            }
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression) {
        Object symbol;
        PsiElement resolved;
        OCExpression funRef = expression.getFunctionReferenceExpression();
        PsiReference reference = funRef.getReference();
        if (reference != null && (resolved = reference.resolve()) instanceof OCSymbolDeclarator && ((symbol = ((OCSymbolDeclarator)resolved).getSymbol()) instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isConstexpr() || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isConstexpr())) {
            super.visitCallExpression(expression);
            return;
        }
        if (!(funRef instanceof OCReferenceExpression)) {
            this.nonConstExpression(expression);
            this.myConst = false;
        } else {
            OCSymbol symbol2 = ((OCReferenceExpression)funRef).resolveToSymbol();
            if (OCCodeInsightUtil.isInPlainOldC(expression) && (symbol2 == null || !symbol2.getName().startsWith("__builtin"))) {
                this.nonConstExpression(expression);
                this.myConst = false;
            } else {
                super.visitCallExpression(expression);
            }
        }
    }

    @Override
    public void visitCastExpression(OCCastExpression expression) {
        if (OCConstantExpressionVisitor.isNonConstTypeConversion(expression.getResolvedType(), expression)) {
            this.nonConstExpression(expression);
            this.myConst = false;
        } else {
            super.visitCastExpression(expression);
        }
    }

    private static boolean isNonConstTypeConversion(OCType type, PsiElement context2) {
        return !OCCodeInsightUtil.isInPlainOldC(context2) && !type.isScalar() && !type.isUnknown();
    }

    @Override
    public void visitCppNewExpression(OCCppNewExpression expression) {
        this.nonConstExpression(expression);
        this.myConst = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isConstDeclarator(OCReferenceExpression expression, OCSymbol symbol) {
        if (!symbol.getKind().isConst() && symbol instanceof OCDeclaratorSymbol) {
            OCDeclaratorSymbol declarator = (OCDeclaratorSymbol)symbol;
            OCFile file2 = expression.getContainingOCFile();
            if ((file2 != null && file2.isCpp() || !OCCompilerFeaturesHelper.getDiagnosticLevel(file2, OCCompilerFeatures.Diagnostic.FOLDING_CONSTANT).isEnabled()) && declarator.isConst()) {
                return true;
            }
            if (file2 != null && !file2.isCpp() && declarator.getType().resolve(expression) instanceof OCArrayType) {
                return true;
            }
            if (symbol.getKind() != OCSymbolKind.BUILTIN_SYMBOL) return false;
            this.visitExpression(expression);
            return true;
        } else {
            if (!symbol.getKind().isConstructorOrDestructor()) return true;
            return false;
        }
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression expression) {
        OCType type = expression.getResolvedType();
        if (type.isPointerToObject() && !type.isPointerToString()) {
            this.myConst = false;
            this.nonConstExpression(expression);
        }
    }

    @Override
    public void visitBoxedExpression(OCBoxedExpression expression) {
        this.myConst = false;
        this.nonConstExpression(expression);
    }

    @Override
    public void visitBlockExpression(OCBlockExpression blockExpression) {
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
    }

    @Override
    public void visitSizeofExpression(OCSizeofExpression expression) {
    }

    protected void nonConstExpression(OCExpression expression) {
    }

    public boolean isConstant(@Nullable OCExpression expression) {
        if (expression != null) {
            this.myConst = true;
            expression.accept(this);
            return this.myConst;
        }
        return false;
    }
}

