/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextFreeResolveUtil {
    @Nullable
    public static OCClassSymbol resolveToClass(String className, Project project2) {
        Ref resolution = new Ref();
        String finalClassName = className;
        OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<? super OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCClassSymbol && ocSymbol.getName().equals(finalClassName) && !ocSymbol.isPredeclaration() && ((OCClassSymbol)ocSymbol).getCategoryName() == null) {
                resolution.set((Object)((OCClassSymbol)ocSymbol));
                return false;
            }
            return true;
        }), className);
        return (OCClassSymbol)resolution.get();
    }

    @Nullable
    public static OCMemberSymbol resolveToProperty(String className, String property, Project project2) {
        if (className == null) {
            return null;
        }
        OCClassSymbol symbol = ContextFreeResolveUtil.resolveToClass(className, project2);
        return ContextFreeResolveUtil.resolveToProperty(property, symbol, project2);
    }

    public static OCMemberSymbol resolveToProperty(String property, OCClassSymbol symbol, @NotNull Project project2) {
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        while (symbol != null) {
            symbol.processMembers(property, (Processor<? super OCMemberSymbol>)processor2);
            if (processor2.isFound()) {
                return (OCMemberSymbol)processor2.getFoundValue();
            }
            symbol = ContextFreeResolveUtil.resolveToClass(symbol.getSuperClassName(), project2);
        }
        return null;
    }
}

