/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationData<CONFIGURATION extends CidrTestRunConfiguration>
implements JDOMExternalizable,
Cloneable {
    @Nullable
    protected String myTestSuite;
    @Nullable
    protected String myTestName;
    @Nullable
    protected String myTestPattern;
    @Nullable
    private volatile String myCommandLineTestPattern;
    @NotNull
    protected Mode myTestMode = Mode.SUITE_TEST;
    @NotNull
    protected CONFIGURATION myConfiguration;

    public abstract void checkData() throws RuntimeConfigurationException;

    public CidrTestRunConfigurationData(@NotNull CONFIGURATION configuration) {
        this.myConfiguration = configuration;
        assert (!CidrTestRunConfigurationData.isPotentiallyThisCapturing(this.getClass())) : "TestData must not be initialized from an inner/anonymous (non-static) class. Otherwise it will leak in clone() and cause unexpected behavior";
    }

    static boolean isPotentiallyThisCapturing(@NotNull Class<?> clazz) {
        return clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers());
    }

    @Nullable
    public String getTestSuite() {
        return this.myTestSuite;
    }

    public void setTestSuite(@Nullable String testSuite) {
        this.myTestSuite = StringUtil.nullize((String)testSuite, (boolean)true);
    }

    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    public void setTestName(@Nullable String testName) {
        this.myTestName = StringUtil.nullize((String)testName, (boolean)true);
    }

    @Nullable
    public String getTestPattern() {
        return this.myTestPattern;
    }

    public void setTestPattern(@Nullable String testPattern) {
        this.myTestPattern = testPattern;
    }

    @NotNull
    public Mode getTestMode() {
        return this.myTestMode;
    }

    public void setTestMode(@NotNull Mode mode) {
        this.myTestMode = mode;
    }

    @NotNull
    public String suggestedName(@Nullable String fallbackName) {
        if (this.myTestSuite != null && this.myTestName != null) {
            return this.formatTestMethod();
        }
        if (this.myTestMode == Mode.PATTERN) {
            return "Pattern";
        }
        String scopeName = this.myTestSuite != null ? this.myTestSuite : fallbackName;
        return scopeName == null ? CidrBundle.message("test.defaultName.allTests", new Object[0]) : CidrBundle.message("test.defaultName.allTestsIn", scopeName);
    }

    @NotNull
    protected abstract String formatTestMethod();

    public void readExternal(Element element) throws InvalidDataException {
        this.setTestSuite(element.getAttributeValue("TEST_CLASS"));
        this.setTestName(element.getAttributeValue("TEST_METHOD"));
        this.setTestPattern(element.getAttributeValue("TEST_PATTERN"));
        String modeValue = element.getAttributeValue("TEST_MODE");
        this.setTestMode(modeValue == null || modeValue.equals("SUITE_TEST") ? Mode.SUITE_TEST : Mode.PATTERN);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        switch (this.myTestMode) {
            case SUITE_TEST: {
                if (this.myTestSuite != null) {
                    element.setAttribute("TEST_CLASS", this.myTestSuite);
                }
                if (this.myTestName == null) break;
                element.setAttribute("TEST_METHOD", this.myTestName);
                break;
            }
            case PATTERN: {
                if (this.myTestPattern == null) break;
                element.setAttribute("TEST_PATTERN", this.myTestPattern);
            }
        }
        element.setAttribute("TEST_MODE", this.myTestMode.name());
    }

    public CidrTestRunConfigurationData cloneForConfiguration(@NotNull CidrTestRunConfiguration configuration) {
        try {
            CidrTestRunConfigurationData result2 = this.clone();
            result2.myConfiguration = configuration;
            return result2;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected CidrTestRunConfigurationData clone() throws CloneNotSupportedException {
        CidrTestRunConfigurationData result2 = (CidrTestRunConfigurationData)super.clone();
        result2.myTestSuite = this.myTestSuite;
        result2.myTestName = this.myTestName;
        result2.myTestPattern = this.myTestPattern;
        result2.myTestMode = this.myTestMode;
        return result2;
    }

    public boolean equalTo(@NotNull CidrTestScopeElement scope) {
        return scope.isPatternLike() ? this.getTestMode() == Mode.PATTERN && Objects.equals(this.getTestPattern(), scope.getPattern()) : this.getTestMode() == Mode.SUITE_TEST && Objects.equals(this.getTestSuite(), scope.getSuiteName()) && Objects.equals(this.getTestName(), scope.getTestName());
    }

    @Nullable
    public String getCommandLineTestPattern() {
        if (this.myCommandLineTestPattern == null) {
            CidrTestLog.LOG.warn("Seems the `" + CidrBundle.message("test.before.run", new Object[0]) + "` task was manually removed from `Before launch` list.");
        }
        return this.myCommandLineTestPattern;
    }

    public void setCommandLineTestPattern(@Nullable String commandLineTestPattern) {
        this.myCommandLineTestPattern = commandLineTestPattern;
    }

    @NotNull
    public abstract SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor var1, @NotNull ExecutionTarget var2);

    @NonNls
    @Nullable
    public abstract String getTestingFrameworkId();

    public abstract CommandLineState createState(@NotNull ExecutionEnvironment var1, @NotNull Executor var2, @Nullable CidrTestScope var3);

    public static enum Mode {
        SUITE_TEST,
        PATTERN;

    }
}

