/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class CidrTestListUpdaterWithFileVersion
extends CidrTestListUpdater {
    private final HashMap<VirtualFile, Long> myTestFileVersionMap = new HashMap();

    CidrTestListUpdaterWithFileVersion(final @NotNull CidrTestFrameworkBase<?> framework, @NotNull Project project2) {
        super(framework, project2);
        project2.getMessageBus().connect((Disposable)this).subscribe(OCFileSymbolTableListener.TOPIC, (Object)new OCFileSymbolTableListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFileHasNewSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                HashMap hashMap = CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap;
                synchronized (hashMap) {
                    this.incTracker();
                    long version = CidrTestListUpdaterWithFileVersion.this.getFileVersion(virtualFile);
                    CidrTestListUpdater.log(framework.getFrameworkId(), " TU add ", virtualFile, " v=", version);
                    CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap.put(virtualFile, CidrTestListUpdaterWithFileVersion.this.getModificationCount());
                }
                CidrTestListUpdaterWithFileVersion.this.scheduleUpdate(virtualFile);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFileHasInvalidSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                HashMap hashMap = CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap;
                synchronized (hashMap) {
                    this.incTracker();
                    CidrTestListUpdater.log(framework.getFrameworkId(), " TU remove ", virtualFile);
                    CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap.remove(virtualFile);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAllSymbolTablesDropped() {
                HashMap hashMap = CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap;
                synchronized (hashMap) {
                    this.incTracker();
                    CidrTestListUpdater.log(framework.getFrameworkId(), " TU clear all");
                    CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap.clear();
                }
            }

            private void incTracker() {
                CidrTestListUpdaterWithFileVersion.this.incTestInfoVersion();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileVersion(@NotNull VirtualFile vf) {
        HashMap<VirtualFile, Long> hashMap = this.myTestFileVersionMap;
        synchronized (hashMap) {
            Long version = this.myTestFileVersionMap.get(vf);
            if (version == null) {
                version = this.getModificationCount();
                this.myTestFileVersionMap.put(vf, version);
            }
            return version;
        }
    }
}

