/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump.lang;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.HexdumpParserDefinition;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.HexdumpParserTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HexdumpParserUtil
extends GeneratedParserUtilBase {
    private static boolean isIgnoredToken(@Nullable IElementType elementType) {
        return elementType == null || HexdumpParserDefinition.WHITE_SPACES.contains(elementType) || HexdumpParserDefinition.COMMENTS.contains(elementType);
    }

    public static boolean afterWhitespace(@NotNull PsiBuilder builder2, int level) {
        return HexdumpParserUtil.isIgnoredToken(builder2.rawLookup(-1));
    }

    public static boolean afterNewline(@NotNull PsiBuilder builder2, int level) {
        return HexdumpParserUtil.afterNewline(builder2, level, 1);
    }

    public static boolean afterNewline(@NotNull PsiBuilder builder2, int level, int newlines) {
        IElementType elementType;
        int step = 0;
        do {
            if ((elementType = builder2.rawLookup(--step)) != null && elementType != HexdumpParserTypes.EOL || --newlines != 0) continue;
            return true;
        } while (HexdumpParserUtil.isIgnoredToken(elementType));
        return false;
    }
}

