/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.BaseDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.ErrorDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.AbstractHexdumpDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0014\u0010\u0017\u001a\u00020\u00162\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001aH\u0014J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0014\u0010 \u001a\u00020\u00162\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\b\u0010!\u001a\u00020\u0016H\u0016J$\u0010\"\u001a\u00020\u00162\n\u0010#\u001a\u00060$j\u0002`%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020'H\u0014J\u0014\u0010(\u001a\u00020\u00162\n\u0010#\u001a\u00060$j\u0002`%H\u0014J\u0014\u0010)\u001a\u00020\u00162\n\u0010#\u001a\u00060$j\u0002`%H\u0014J=\u0010*\u001a\u00020\u00162\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010\u001e\u001a\u00020\u001a2\b\u0010+\u001a\u0004\u0018\u00010\u00022\u0010\b\u0002\u0010,\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u0002\u00a2\u0006\u0002\u0010-R\u001a\u0010\r\u001a\u00060\u000ej\u0002`\u000f8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion;", "Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion;", "", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;)V", "myAsciiBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getMyAsciiBuffer", "()Ljava/lang/StringBuilder;", "rangeMarkersToDispose", "", "Lcom/intellij/openapi/editor/RangeMarker;", "dispose", "", "doRenderSeamless", "oldRegion", "getAddressForLineNumberInsideRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "lineNumber", "", "getLineNumberInsideRegion", "address", "getOffsetInsideLine", "highlightChangedBytes", "markOutdated", "renderEntry", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "renderFooter", "renderHeader", "renderSingleByte", "byte", "asciiBuffer", "(Ljava/lang/Appendable;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Ljava/lang/Byte;Ljava/lang/StringBuilder;)V", "Companion", "intellij.cidr.debugger"})
public final class CidrHexdumpRegion
extends BaseDocRegion<Byte> {
    private final List<RangeMarker> rangeMarkersToDispose;
    private StringBuilder myAsciiBuffer;
    private static final int WORD_BYTES = 4;
    private static final int LINE_BYTES = 16;
    public static final int PARAGRAPH_BYTES = 256;
    @NotNull
    public static final String BYTE_SEPARATOR = " ";
    @NotNull
    public static final String WORD_SEPARATOR = "  ";
    public static final Companion Companion = new Companion(null);

    @Override
    protected void doRenderSeamless(@NotNull BaseDocRegion<?> oldRegion) {
        super.doRenderSeamless(oldRegion);
        this.highlightChangedBytes((DocRegion)oldRegion);
    }

    /*
     * WARNING - void declaration
     */
    private final void highlightChangedBytes(DocRegion<?> oldRegion) {
        void $this$mapNotNullTo$iv$iv;
        DocRegion<?> docRegion = oldRegion;
        if (!(docRegion instanceof CidrHexdumpRegion)) {
            docRegion = null;
        }
        CidrHexdumpRegion cidrHexdumpRegion = (CidrHexdumpRegion)docRegion;
        CidrMemoryData.Data data = cidrHexdumpRegion != null ? cidrHexdumpRegion.getData() : null;
        if (!(data instanceof AbstractHexdumpDataProvider.ByteData)) {
            data = null;
        }
        AbstractHexdumpDataProvider.ByteData byteData = (AbstractHexdumpDataProvider.ByteData)data;
        if (byteData == null) {
            return;
        }
        AbstractHexdumpDataProvider.ByteData oldData = byteData;
        List editors = StreamsKt.toList((Stream)EditorFactory.getInstance().editors(this.getDocument()));
        if (editors.isEmpty()) {
            return;
        }
        Iterable $this$mapNotNull$iv = CollectionsKt.zip(oldData.getEntries(), this.getData().getEntries());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CidrMemoryData.DataEntry dataEntry;
            void oldEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair $dstr$oldEntry$newEntry = (Pair)element$iv$iv;
            boolean bl2 = false;
            CidrMemoryData.DataEntry dataEntry2 = (CidrMemoryData.DataEntry)$dstr$oldEntry$newEntry.component1();
            CidrMemoryData.DataEntry newEntry = (CidrMemoryData.DataEntry)$dstr$oldEntry$newEntry.component2();
            boolean bl3 = Intrinsics.areEqual((Object)oldEntry.getAddress(), (Object)newEntry.getAddress());
            boolean bl4 = false;
            boolean bl5 = false;
            if (_Assertions.ENABLED && !bl3) {
                boolean bl6 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            CidrMemoryData.DataEntry dataEntry3 = newEntry;
            bl4 = false;
            bl5 = false;
            CidrMemoryData.DataEntry it = dataEntry3;
            boolean bl7 = false;
            Byte by = (Byte)newEntry.getValue();
            if ((by == null || ((Number)oldEntry.getValue()).byteValue() != by.byteValue() ? dataEntry3 : null) == null) continue;
            dataEntry = dataEntry;
            boolean bl8 = false;
            boolean bl9 = false;
            CidrMemoryData.DataEntry it$iv$iv = dataEntry;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List changedEntries = (List)destination$iv$iv;
        TextAttributes fgAttributes = XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES.toTextAttributes();
        Iterable $this$forEach$iv = editors;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor editor = (Editor)element$iv;
            boolean bl = false;
            HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
            if (highlightManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.highlighting.HighlightManagerImpl");
            }
            HighlightManagerImpl highlightManager2 = (HighlightManagerImpl)highlightManager;
            int hideFlags = 4;
            highlightManager2.hideHighlights(editor, hideFlags);
            Iterable $this$forEach$iv2 = changedEntries;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                CidrMemoryData.DataEntry changedEntry = (CidrMemoryData.DataEntry)element$iv2;
                boolean bl11 = false;
                int offsetInDocument = this.getOffsetInDocument(changedEntry.getAddress());
                highlightManager2.addRangeHighlight(editor, offsetInDocument, offsetInDocument + 2, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, true, null);
                highlightManager2.addOccurrenceHighlight(editor, offsetInDocument, offsetInDocument + 2, fgAttributes, hideFlags, null, null);
            }
        }
    }

    @Override
    public void markOutdated() {
        TextAttributes commentAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DefaultLanguageHighlighterColors.LINE_COMMENT);
        TextAttributes fgAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.NO_HIGHLIGHTING).clone();
        fgAttributes.setForegroundColor(commentAttributes.getForegroundColor());
        fgAttributes.setBackgroundColor(commentAttributes.getBackgroundColor());
        EditorFactory.getInstance().editors(this.getDocument()).forEach((Consumer)new Consumer<Editor>(this, fgAttributes){
            final /* synthetic */ CidrHexdumpRegion this$0;
            final /* synthetic */ TextAttributes $fgAttributes;

            public final void accept(Editor editor) {
                HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
                if (highlightManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.highlighting.HighlightManagerImpl");
                }
                HighlightManagerImpl highlightManager2 = (HighlightManagerImpl)highlightManager;
                int hideFlags = 4;
                highlightManager2.hideHighlights(editor, hideFlags);
                RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(this.this$0.getRangeMarker().getStartOffset(), this.this$0.getRangeMarker().getEndOffset(), 1000, this.$fgAttributes, HighlighterTargetArea.EXACT_RANGE);
                Collection collection = CidrHexdumpRegion.access$getRangeMarkersToDispose$p(this.this$0);
                boolean bl = false;
                collection.add(rangeHighlighter);
            }
            {
                this.this$0 = cidrHexdumpRegion;
                this.$fgAttributes = textAttributes;
            }
        });
    }

    @Override
    protected void dispose() {
        super.dispose();
        Iterable $this$forEach$iv = this.rangeMarkersToDispose;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeMarker p1 = (RangeMarker)element$iv;
            boolean bl = false;
            p1.dispose();
        }
    }

    private final StringBuilder getMyAsciiBuffer() {
        if (this.myAsciiBuffer == null) {
            this.myAsciiBuffer = new StringBuilder();
        }
        return this.myAsciiBuffer;
    }

    @Override
    protected void renderHeader(@NotNull Appendable buffer) {
        Address start = this.getData().getRange().getStart();
        long missingStartBytesNumber = AddressUtil.reminder(start, 16);
        AddressRange missingStartRange = AddressUtil.until(start.minus(missingStartBytesNumber), start);
        for (Address address : missingStartRange) {
            this.renderSingleByte(buffer, address, null, this.getMyAsciiBuffer());
        }
    }

    @Override
    protected void renderFooter(@NotNull Appendable buffer) {
        Address endInclusive = this.getData().getRange().getEndInclusive();
        long missingEndBytesNumber = (long)16 - AddressUtil.reminder(endInclusive, 16) - 1L;
        AddressRange missingEndRange = AddressUtil.until(endInclusive.plus(1), endInclusive.plus(1).plus(missingEndBytesNumber));
        for (Address address : missingEndRange) {
            this.renderSingleByte(buffer, address, null, this.getMyAsciiBuffer());
        }
    }

    @Override
    protected void renderEntry(@NotNull Appendable buffer, @NotNull CidrMemoryData.DataEntry<Byte> dataEntry) {
        this.renderSingleByte(buffer, dataEntry.getAddress(), dataEntry.getValue(), this.getMyAsciiBuffer());
    }

    private final void renderSingleByte(Appendable buffer, Address address, Byte by, StringBuilder asciiBuffer) {
        Object object = by;
        if (object == null || (object = Companion.toUnsignedHexString((Byte)object)) == null) {
            object = WORD_SEPARATOR;
        }
        Object byteString = object;
        boolean bl = ((String)byteString).length() == 2;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = '\'' + (String)byteString + "' must be a zero-padded unsigned byte";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (Companion.isAlignedTo(address, 256)) {
            buffer.append('\n');
        }
        if (Companion.isAlignedTo(address, 4)) {
            buffer.append(WORD_SEPARATOR);
        }
        buffer.append(BYTE_SEPARATOR);
        buffer.append((CharSequence)byteString);
        StringBuilder stringBuilder = asciiBuffer;
        if (stringBuilder != null) {
            stringBuilder.append(by != null && by >= 32 && by < 127 ? (char)by.byteValue() : (char)'\u00b7');
        }
        if (Companion.isAlignedTo(address.plus(1), 16)) {
            if (asciiBuffer != null) {
                buffer.append("   \u2502 ");
                buffer.append(asciiBuffer);
                buffer.append(" \u2502");
                asciiBuffer.setLength(0);
            }
            buffer.append('\n');
        }
    }

    static /* synthetic */ void renderSingleByte$default(CidrHexdumpRegion cidrHexdumpRegion, Appendable appendable, Address address, Byte by, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 8) != 0) {
            stringBuilder = null;
        }
        cidrHexdumpRegion.renderSingleByte(appendable, address, by, stringBuilder);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Address getAddressForLineNumberInsideRegion(int lineNumber) {
        void start;
        if (lineNumber == 0) {
            return null;
        }
        AddressRange addressRange = this.getRange();
        Address address = addressRange.component1();
        Address endInclusive = addressRange.component2();
        Address alignedStart = start.minus(AddressUtil.reminder((Address)start, 16));
        Address alignedEndInclusive = endInclusive.minus(AddressUtil.reminder(endInclusive, 16)).plus(16).minus(1);
        Address address2 = alignedStart.plus((lineNumber - 1) * 16);
        return address2.compareTo(alignedEndInclusive) <= 0 ? address2 : null;
    }

    @Override
    protected int getLineNumberInsideRegion(@NotNull Address address) {
        return CidrHexdumpRegion.Companion.lineOf((int)address.minus(this.getRange().getStart())) + 1;
    }

    @Override
    protected int getOffsetInsideLine(@NotNull Address address, int lineNumber) {
        StringBuilder buffer = new StringBuilder();
        Address lineStartAddress = AddressUtil.roundDown(address, (Number)16);
        for (Address eachAddress : AddressUtil.addressRangeInclusive(lineStartAddress, address)) {
            CidrHexdumpRegion.renderSingleByte$default(this, buffer, eachAddress, null, null, 8, null);
        }
        CharSequence charSequence = StringsKt.trim((CharSequence)buffer, (char[])new char[]{'\n'});
        boolean bl = false;
        boolean bl2 = false;
        CharSequence it = charSequence;
        boolean bl3 = false;
        boolean bl4 = !StringsKt.contains$default((CharSequence)it, (char)'\n', (boolean)false, (int)2, null);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Unexpected line break inside a line: '" + (CharSequence)it + '\'';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        CharSequence line = charSequence;
        return RangesKt.coerceAtLeast((int)(line.length() - 2), (int)0);
    }

    public CidrHexdumpRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<Byte> dataRegion, @NotNull AddressSpace<DocRegion<Byte>> reallocatedSpace) {
        super(document2, textRange, dataRegion, reallocatedSpace);
        boolean bl = false;
        this.rangeMarkersToDispose = new ArrayList();
        this.myAsciiBuffer = new StringBuilder();
    }

    public static final /* synthetic */ List access$getRangeMarkersToDispose$p(CidrHexdumpRegion $this) {
        return $this.rangeMarkersToDispose;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J@\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007J\n\u0010\u001b\u001a\u00020\u0005*\u00020\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion$Companion;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc$DocRegionFactory;", "", "()V", "BYTE_SEPARATOR", "", "LINE_BYTES", "", "PARAGRAPH_BYTES", "WORD_BYTES", "WORD_SEPARATOR", "createDocRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "lineOf", "offset", "isAlignedTo", "", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "n", "toUnsignedHexString", "intellij.cidr.debugger"})
    public static final class Companion
    implements CidrMemoryDoc.DocRegionFactory<Byte> {
        @Override
        @NotNull
        public DocRegion<Byte> createDocRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<Byte> dataRegion, @NotNull AddressSpace<DocRegion<Byte>> reallocatedSpace) {
            return dataRegion instanceof CidrMemoryData.DataRegion.Completed.LoadError ? (DocRegion)new ErrorDocRegion(document2, textRange, (CidrMemoryData.DataRegion.Completed.LoadError)dataRegion) : (DocRegion)new CidrHexdumpRegion(document2, textRange, dataRegion, reallocatedSpace);
        }

        public final boolean isAlignedTo(@NotNull Address $this$isAlignedTo, int n) {
            return $this$isAlignedTo.getUnsignedLongValue() % (long)n == 0L;
        }

        @NotNull
        public final String toUnsignedHexString(byte $this$toUnsignedHexString) {
            return StringsKt.padStart((String)Integer.toUnsignedString(Byte.toUnsignedInt($this$toUnsignedHexString), 16), (int)2, (char)'0');
        }

        private final int lineOf(int offset) {
            return offset / 16;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

