/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererExtension;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueRenderer {
    private static final Pattern SWIFT_DESCRIPTION_PATTERN = Pattern.compile("( *((\u25bf .*)|(- .*? : .*?))(\n|$))*");
    @NotNull
    protected final CidrPhysicalValue myValue;
    @NotNull
    private final CachedDebuggerResult<Pair<String, XFullValueEvaluator>> myValueCache = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<Boolean> myMayHaveChildrenCache = new CachedDebuggerResult();
    protected int myCurrentIndex = 0;

    public ValueRenderer(@NotNull CidrPhysicalValue value) {
        this.myValue = value;
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        return this.myValue;
    }

    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        boolean isPointer = this.myValue.getPreparedVarData().isPointer();
        boolean isSwift = this.myValue.isSwiftContext();
        if (child.getName().matches("\\[\\w+\\]")) {
            return this.getChildEvaluationExpression(child, "", this.myValue);
        }
        if (!isSwift && isPointer) {
            return this.getChildEvaluationExpression(child, "->", this.myValue);
        }
        if (!isSwift && this.myValue instanceof CidrElementValue) {
            CidrElementValue value = (CidrElementValue)this.myValue;
            if (value.getIndex() == 0) {
                return this.getChildEvaluationExpression(child, "->", value.getContainer());
            }
        } else if (this.myValue instanceof CidrMemberValue) {
            CidrPhysicalValue parent = ((CidrMemberValue)this.myValue).getParent();
            if (this.isSuperNode()) {
                return parent.getPreparedRenderer().getChildEvaluationExpression(child, lvalue);
            }
        }
        return this.getChildEvaluationExpression(child, ".", this.myValue);
    }

    private boolean isSuperNode() {
        LLValue var = this.myValue.getVar();
        return var.getType().equals(var.getName());
    }

    protected LLValueData messageSendToSelfData(String selectorAndArgs, String returnType, EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return context2.getData(this.messageSendToSelf(selectorAndArgs, returnType, context2));
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, String returnType, EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return context2.messageSend(this.myValue.getVar(), selectorAndArgs, returnType);
    }

    @Nullable
    public Icon getIcon(boolean hasChildren) {
        return hasChildren ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
    }

    @NotNull
    public StringBuilder getConsoleDescription(@NotNull EvaluationContext context2) throws ExecutionException {
        StringBuilder builder2 = new StringBuilder();
        try {
            boolean hasChildren;
            String value = (String)this.computeValueAndEvaluator((EvaluationContext)context2).first;
            builder2.append("(").append(this.myValue.getType()).append((") " + value).trim());
            if (this.shouldPrintChildrenConsoleDescription() && (hasChildren = this.computeMayHaveChildren(context2))) {
                builder2.append("\n");
                this.printChildrenConsoleDescription(context2, builder2);
            }
        }
        catch (DebuggerCommandException e) {
            ValueRenderer.appendConsoleError(builder2, this.toString());
        }
        return builder2;
    }

    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    private void printChildrenConsoleDescription(EvaluationContext context2, StringBuilder builder2) throws ExecutionException, DebuggerCommandException {
        builder2.append("{\n");
        ConsoleDescriptionNode container = new ConsoleDescriptionNode(builder2, context2);
        try {
            this.computeChildren(context2, container);
        }
        catch (ExecutionRuntimeException e) {
            throw e.cause;
        }
        finally {
            builder2.append("}");
        }
    }

    private static void appendConsoleError(StringBuilder builder2, @NotNull String errorMessage) {
        builder2.append("error: ").append(errorMessage);
    }

    @NotNull
    public String getDisplayType() {
        return ValueRenderer.getShortenedType(this.myValue.getVar().getType());
    }

    @NotNull
    public static String getShortenedType(@NotNull String type) {
        int TEMPLATE_TYPE_REDUCE_LEVEL = 1;
        StringBuilder result2 = new StringBuilder();
        int count = 0;
        for (int i2 = 0; i2 < type.length(); ++i2) {
            char c = type.charAt(i2);
            if (c == '<') {
                ++count;
            }
            if (count <= TEMPLATE_TYPE_REDUCE_LEVEL) {
                int length = result2.length();
                if (c == '>' && length > 2 && result2.charAt(length - 1) == ' ' && result2.charAt(length - 2) != '>') {
                    result2.setLength(length - 1);
                }
                result2.append(c);
            }
            if (c != '>') continue;
            --count;
        }
        return count == 0 ? result2.toString() : type;
    }

    protected String getChildEvaluationExpression(CidrPhysicalValue child, String separator, CidrPhysicalValue parent) {
        boolean cast;
        ValueRendererExtension extension = ValueRendererExtension.getExtension(parent.getFrame().getFrame().getLanguage());
        if (extension != null) {
            return extension.getChildEvaluationExpression(child, separator, parent);
        }
        String parentRefExpression = parent.getEvaluationExpression();
        boolean bl = cast = parent.getVar().getTypeClass() == LLValue.TypeClass.OBJC_POINTER;
        if (cast) {
            parentRefExpression = "((" + parent.getType() + ")(" + parentRefExpression + "))";
        }
        return parentRefExpression + separator + child.getVar().getName();
    }

    @NotNull
    public Pair<String, XFullValueEvaluator> computeValueAndEvaluator(final @NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return this.myValueCache.getResult(new CachedDebuggerResult.NotNullCalculator<Pair<String, XFullValueEvaluator>>(){

            @Override
            @NotNull
            public Pair<String, XFullValueEvaluator> calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context2);
                if (data.isNullPointer()) {
                    LLValue var = ValueRenderer.this.getValue().getVar();
                    boolean objc = var.getTypeClass() == LLValue.TypeClass.OBJC_POINTER || "id".equals(var.getType()) && ValueRenderer.this.getValue().isObjectiveCContext();
                    return Pair.create((Object)(objc ? "nil" : "NULL"), null);
                }
                if (ValueRenderer.this.myValue.isSwiftVoid()) {
                    return Pair.create((Object)"", null);
                }
                Pair result2 = ValueRenderer.this.doComputeValueAndEvaluator(context2);
                return ((String)result2.first).equals("{...}") ? Pair.create((Object)"", null) : result2;
            }
        });
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return this.doComputeValueAndEvaluator(context2, this.myValue.getPresentationVar(), this.myValue.getPresentationVarData(context2));
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context2, LLValue var, LLValueData data) throws ExecutionException, DebuggerCommandException {
        ImmediateFullValueEvaluator evaluator;
        String description2;
        boolean isRawStringViewEnabled = Registry.is((String)"cidr.debugger.value.stringEvaluator", (boolean)false);
        Pair result2 = null;
        String descriptionOrig = data.getDescription();
        if (descriptionOrig != null) {
            description2 = descriptionOrig;
            if (this.myValue.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT) {
                description2 = StringUtil.unescapeStringCharacters((String)description2);
            }
            if (!this.ignoreDescription(description2 = description2.trim())) {
                evaluator = null;
                boolean hasLongerDescription = data.hasLongerDescription();
                if (isRawStringViewEnabled && !hasLongerDescription && ValueRendererUtils.isQuotedString(descriptionOrig)) {
                    evaluator = new ImmediateFullValueEvaluator(CidrDebuggerBundle.message("debugger.variables.showRawStringValue.link", new Object[0]), ValueRendererUtils.getRawString(descriptionOrig));
                } else if (isRawStringViewEnabled && hasLongerDescription && ValueRendererUtils.isBeginQuotedString(descriptionOrig)) {
                    evaluator = this.createFullDescriptionEvaluator(var, ValueRendererUtils::getRawString);
                } else if (hasLongerDescription) {
                    evaluator = this.createFullDescriptionEvaluator(var, null);
                }
                result2 = Pair.create((Object)StringUtil.first((String)description2, (int)1000, (boolean)false), (Object)evaluator);
            }
        }
        if (result2 == null) {
            description2 = this.doComputeFallbackValue(context2, var, data);
            evaluator = null;
            if (isRawStringViewEnabled && ValueRendererUtils.isQuotedString(description2)) {
                evaluator = new ImmediateFullValueEvaluator(CidrDebuggerBundle.message("debugger.variables.showRawStringValue.link", new Object[0]), ValueRendererUtils.getRawString(description2));
            } else if (description2.length() > 1000) {
                evaluator = new ImmediateFullValueEvaluator(description2);
            }
            result2 = Pair.create((Object)StringUtil.first((String)description2, (int)1000, (boolean)false), (Object)evaluator);
        }
        return result2;
    }

    protected boolean ignoreDescription(@NotNull String description2) {
        DebuggerDriver.DebuggerLanguage language = this.myValue.getLanguage();
        return language == DebuggerDriver.StandardDebuggerLanguage.OBJC && StringUtil.containsLineBreak((CharSequence)description2) || language == DebuggerDriver.StandardDebuggerLanguage.SWIFT && SWIFT_DESCRIPTION_PATTERN.matcher(description2).matches();
    }

    @NotNull
    protected String doComputeFallbackValue(@NotNull EvaluationContext context2, @NotNull LLValue var, @NotNull LLValueData data) throws ExecutionException, DebuggerCommandException {
        return data.getValue();
    }

    @Nullable
    private XFullValueEvaluator createFullDescriptionEvaluator(final @NotNull LLValue value, final @Nullable Function<String, String> descriptionProc) {
        return new XFullValueEvaluator(){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                ValueRenderer.this.getValue().getProcess().postCommand(driver -> {
                    if (callback.isObsolete()) {
                        return;
                    }
                    try {
                        int _10mb = 0xA00000;
                        String description2 = driver.getDescription(value, _10mb);
                        description2 = StringUtil.notNullize((String)description2);
                        if (descriptionProc != null) {
                            description2 = (String)descriptionProc.apply(description2);
                        }
                        callback.evaluated(description2);
                    }
                    catch (DebuggerCommandException e) {
                        callback.errorOccurred(e.getMessage());
                    }
                    catch (ExecutionException e) {
                        callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                        throw e;
                    }
                });
            }
        };
    }

    public boolean computeMayHaveChildren(final @NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        Integer result2;
        if (this.mayHaveChildrenViaChildrenCount() && (result2 = this.computeChildrenCount(context2, 1)) != null) {
            return result2 > 0;
        }
        return this.myMayHaveChildrenCache.getResult(new CachedDebuggerResult.NotNullCalculator<Boolean>(){

            @Override
            @NotNull
            public Boolean calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context2);
                return data.isNullPointer() || ValueRenderer.this.myValue.isSwiftVoid() ? false : data.mayHaveChildren();
            }
        });
    }

    protected boolean mayHaveChildrenViaChildrenCount() {
        return false;
    }

    @Nullable
    protected Integer computeChildrenCount(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return this.computeChildrenCount(context2, Integer.MAX_VALUE);
    }

    @Nullable
    private Integer computeChildrenCount(@NotNull EvaluationContext context2, int max) throws ExecutionException, DebuggerCommandException {
        LLValueData data = this.myValue.getVarData(context2);
        return data.isNullPointer() || this.myValue.isSwiftVoid() ? new Integer(0) : this.doComputeChildrenCount(context2, max);
    }

    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context2, int max) throws ExecutionException, DebuggerCommandException {
        return context2.getChildrenCount(this.myValue.getPresentationVar(), max);
    }

    public final void computeChildren(@NotNull EvaluationContext context2, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        if (!this.computeMayHaveChildren(context2)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context2, container);
    }

    protected int getBatchSize() {
        return ValueRenderer.getPositiveNumberFromRegistry("cidr.debugger.value.maxChildren", 50);
    }

    private static int getPositiveNumberFromRegistry(@NotNull String key, int defaultValue) {
        int value = Registry.intValue((String)key, (int)defaultValue);
        if (value <= 0) {
            CidrDebuggerLog.LOG.warn(key + " must be a positive number, falling back to default value: " + defaultValue);
            value = defaultValue;
        }
        return value;
    }

    protected void doComputeChildren(@NotNull EvaluationContext context2, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        LLValue var = this.myValue.getPresentationVar();
        DebuggerDriver.ResultList<LLValue> result2 = context2.getVariableChildren(var, this.getCurrentIndex(), this.getBatchSize());
        this.addChildrenTo(result2.list, context2, container, this.areChildrenModifiable(var, this.myValue.getPresentationVarData(context2)));
        if (result2.hasMore) {
            container.tooManyChildren(-1);
        }
    }

    protected void addChildrenTo(@NotNull List<LLValue> children, @NotNull EvaluationContext context2, @NotNull XCompositeNode container, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        SmartList values = new SmartList();
        for (LLValue each : children) {
            if (container.isObsolete()) {
                return;
            }
            values.add(new CidrMemberValue(each, this.myValue, modifiable));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, container);
        this.myCurrentIndex += children.size();
    }

    protected int getCurrentIndex() {
        return this.myCurrentIndex;
    }

    protected boolean areChildrenModifiable(@NotNull LLValue var, @NotNull LLValueData data) {
        return !data.isSynthetic();
    }

    private static class ConsoleDescriptionNode
    implements XCompositeNode {
        private final StringBuilder myBuilder;
        private final EvaluationContext myContext;

        ConsoleDescriptionNode(StringBuilder builder2, EvaluationContext context2) {
            this.myBuilder = builder2;
            this.myContext = context2;
        }

        public void addChildren(@NotNull XValueChildrenList children, boolean last) {
            for (int i2 = 0; i2 < children.size(); ++i2) {
                String name = children.getName(i2);
                this.myBuilder.append("\t").append(name).append(" = ");
                try {
                    String shiftedChildren = ((CidrValue)children.getValue(i2)).getConsoleDescription(this.myContext).replace("\n", "\n\t");
                    this.myBuilder.append(shiftedChildren);
                }
                catch (DebuggerCommandException e) {
                    this.setErrorMessage(e.getMessage());
                }
                catch (ExecutionException e) {
                    throw new ExecutionRuntimeException(e);
                }
                this.myBuilder.append("\n");
            }
        }

        public void tooManyChildren(int remaining) {
            this.myBuilder.append("\t...");
            if (remaining > 0) {
                this.myBuilder.append(remaining).append(" more\n");
            }
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            ValueRenderer.appendConsoleError(this.myBuilder, errorMessage);
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            this.setErrorMessage(errorMessage);
        }

        public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }
    }

    static class ExecutionRuntimeException
    extends RuntimeException {
        ExecutionException cause;

        ExecutionRuntimeException(ExecutionException exception) {
            this.cause = exception;
        }
    }
}

