/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSContainerValueRenderer;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NSEnumerableValueRenderer
extends NSContainerValueRenderer {
    private boolean myInitialized;

    public NSEnumerableValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    @Override
    protected boolean mayHaveChildrenViaChildrenCount() {
        return true;
    }

    @Override
    protected final void doComputeChildren(@NotNull EvaluationContext context2, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        Integer nullableCount;
        if (!this.myInitialized) {
            this.willExpand(context2);
            this.myInitialized = true;
        }
        if ((nullableCount = this.computeChildrenCount(context2)) == null) {
            throw new ExecutionException("Internal error: " + NSEnumerableValueRenderer.class.getSimpleName() + " requires children count");
        }
        int count = nullableCount;
        int batchSize = this.getBatchSize();
        ArrayList<CidrValue> children = new ArrayList<CidrValue>(batchSize);
        for (int i2 = 0; i2 < batchSize && this.getCurrentIndex() < count; ++i2) {
            if (container.isObsolete()) {
                return;
            }
            CidrValue child = this.nextChild(context2);
            if (child == null) break;
            children.add(child);
        }
        CidrValue.addAllTo(children, container);
        int remaining = count - this.getCurrentIndex();
        if (remaining > 0) {
            container.tooManyChildren(remaining);
        }
    }

    @Nullable
    protected abstract CidrValue nextChild(@NotNull EvaluationContext var1) throws ExecutionException, DebuggerCommandException;

    protected void willExpand(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
    }
}

