/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrErrorValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrValue
extends XNamedValue
implements UserDataHolderEx {
    public static final Key<Boolean> DO_NOT_SHOW_ADDRESSES = Key.create((String)"DO_NOT_SHOW_ADDRESSES");
    private static final Logger LOG = Logger.getInstance(CidrValue.class);
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    @NotNull
    private final CidrDebugProcess myProcess;
    @Nullable
    private final XSourcePosition myPosition;
    @NotNull
    private final CidrStackFrame myFrame;
    @NotNull
    private final List<String> myPresentationErrors = Collections.synchronizedList(new ArrayList());

    public CidrValue(@NotNull String displayName2, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        super(displayName2);
        this.myProcess = process2;
        this.myPosition = position;
        this.myFrame = frame;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrStackFrame getFrame() {
        return this.myFrame;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    @NotNull
    public String getEvaluationExpression() {
        return this.getEvaluationExpression(false);
    }

    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.getName();
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        return this.myProcess;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            XSourcePosition computedPosition;
            XSourcePosition position = this.getSourcePosition();
            if (position == null) {
                navigatable.setSourcePosition(null);
                return;
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator == null) {
                LOG.warn("computeSourcePosition finished with error: ProgressIndicator is null");
                return;
            }
            try {
                computedPosition = this.doComputePositionAsync(position, indicator).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.info("computeSourcePosition finished with error: " + e.getMessage());
                return;
            }
            ReadAction.run(() -> navigatable.setSourcePosition(computedPosition));
        }, CidrDebuggerBundle.message("cidr.value.computing.source.position", new Object[0]), true, this.myProcess.getProject());
    }

    @NotNull
    protected abstract CompletableFuture<XSourcePosition> doComputePositionAsync(@NotNull XSourcePosition var1, @NotNull ProgressIndicator var2);

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        this.doComputeInlineDebuggerDataAsync(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0));
        return ThreeState.YES;
    }

    protected void doComputeInlineDebuggerDataAsync(XNavigatable navigatable) {
        XSourcePosition position = this.getSourcePosition();
        if (position == null) {
            navigatable.setSourcePosition(null);
            return;
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        XDebugSessionListener listener = new XDebugSessionListener((ProgressIndicator)indicator){
            final /* synthetic */ ProgressIndicator val$indicator;
            {
                this.val$indicator = progressIndicator;
            }

            public void sessionResumed() {
                this.val$indicator.cancel();
            }

            public void sessionStopped() {
                this.val$indicator.cancel();
            }
        };
        XDebugSession session = this.myProcess.getSession();
        session.addSessionListener(listener);
        this.doComputePositionAsync(position, (ProgressIndicator)indicator).whenComplete((p, t) -> {
            session.removeSessionListener(listener);
            ReadAction.run(() -> navigatable.setSourcePosition(p));
        });
    }

    public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node2)) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            if (node2.isObsolete()) {
                return;
            }
            boolean hasChildren = false;
            try {
                XFullValueEvaluator evaluator;
                XValuePresentation presentation;
                Icon icon;
                EvaluationContext context2 = this.createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node2));
                try {
                    hasChildren = this.doComputeMayHaveChildren(context2);
                    icon = this.doComputeIcon(context2, hasChildren);
                }
                catch (DebuggerCommandException e) {
                    icon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
                    this.myPresentationErrors.add(e.getMessage());
                    hasChildren = true;
                }
                try {
                    Pair<XValuePresentation, XFullValueEvaluator> presentationAndEvaluator = this.doComputePresentationAndEvaluator(context2);
                    presentation = (XValuePresentation)presentationAndEvaluator.first;
                    evaluator = (XFullValueEvaluator)presentationAndEvaluator.second;
                }
                catch (DebuggerCommandException e) {
                    CidrErrorValue.doComputePresentation(node2, e.getMessage(), hasChildren);
                    return;
                }
                if (evaluator != null) {
                    node2.setFullValueEvaluator(evaluator);
                }
                node2.setPresentation(icon, presentation, hasChildren);
            }
            catch (com.intellij.execution.ExecutionException e) {
                CidrErrorValue.doComputePresentation(node2, CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)), hasChildren);
                throw e;
            }
        });
    }

    protected abstract boolean doComputeMayHaveChildren(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract Icon doComputeIcon(@NotNull EvaluationContext var1, boolean var2) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract String doComputeType(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @NotNull
    protected abstract Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @NotNull
    protected Pair<XValuePresentation, XFullValueEvaluator> doComputePresentationAndEvaluator(@NotNull EvaluationContext context2) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        String type = this.doComputeType(context2);
        Pair<String, XFullValueEvaluator> valueAndEvaluator = this.doComputeValueAndEvaluator(context2);
        return Pair.create((Object)this.createValuePresentation(context2, (String)valueAndEvaluator.first, type), (Object)valueAndEvaluator.second);
    }

    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context2, @NotNull String value, @Nullable String type) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        return new XRegularValuePresentation(value, type);
    }

    public final void computeChildren(@NotNull XCompositeNode node2) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node2)) {
            return;
        }
        if (!this.myPresentationErrors.isEmpty()) {
            node2.addChildren(CidrValue.createErrorChildren(this.myPresentationErrors), false);
        }
        this.computeValueChildren(node2);
    }

    @NotNull
    protected static XValueChildrenList createErrorChildren(@NotNull List<String> errors) {
        XValueChildrenList errorNodesList = new XValueChildrenList();
        for (String each : errors) {
            errorNodesList.add((XNamedValue)new CidrErrorValue(each));
        }
        return errorNodesList;
    }

    protected abstract void computeValueChildren(@NotNull XCompositeNode var1);

    public static void addLocalValues(@NotNull Collection<LLValue> vars, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull XCompositeNode toNode) {
        if (toNode.isObsolete()) {
            return;
        }
        SmartList values = new SmartList();
        for (LLValue each : vars) {
            values.add(new CidrLocalValue(each, process2, position, frame));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, toNode);
    }

    public static void addAllTo(@NotNull Collection<CidrValue> values, @NotNull XCompositeNode toNode) {
        if (toNode.isObsolete()) {
            return;
        }
        XValueChildrenList list = values.isEmpty() ? XValueChildrenList.EMPTY : new XValueChildrenList(values.size());
        for (CidrValue each : values) {
            list.add((XNamedValue)each);
        }
        toNode.addChildren(list, true);
    }

    @NotNull
    public abstract String getConsoleDescription(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable) {
        return this.getProcess().createEvaluationContext(driver, expirable, this.myFrame);
    }
}

