/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrSymbolicBreakpointType
extends XBreakpointType<XBreakpoint<Properties>, Properties> {
    public CidrSymbolicBreakpointType(String id) {
        this(id, CidrDebuggerBundle.message("debug.symbolic.breakpoints", new Object[0]));
    }

    protected CidrSymbolicBreakpointType(String id, String title) {
        super(id, title);
    }

    public String getDisplayText(XBreakpoint<Properties> breakpoint) {
        String result2;
        Properties properties = (Properties)breakpoint.getProperties();
        if (properties == null) {
            return CidrDebuggerBundle.message("debug.symbolic.breakpoint.invalid", new Object[0]);
        }
        String string = result2 = StringUtil.isEmpty((String)properties.getSymbolPattern()) ? "<Empty>" : properties.getSymbolPattern();
        if (properties.getModuleName() != null) {
            result2 = properties.getModuleName() + ": " + result2;
        }
        return result2;
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_method_breakpoint;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        return AllIcons.Debugger.Db_dep_method_breakpoint;
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @Nullable
    public Properties createProperties() {
        return new Properties();
    }

    @NotNull
    public XBreakpoint<Properties> addBreakpoint(Project project2, JComponent parentComponent) {
        return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)project2).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new Properties()));
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XBreakpoint<Properties>> createCustomTopPropertiesPanel(@NotNull Project project2) {
        return this.createSymbolicBreakpointPropertiesPanel(project2);
    }

    protected abstract CidrSymbolicBreakpointPropertiesPanel createSymbolicBreakpointPropertiesPanel(@NotNull Project var1);

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<Properties> breakpoint, @NotNull Project project2) {
        return CidrDebuggerLanguageSupportManager.getInstance().createEditor(breakpoint);
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        @Nullable
        private String mySymbolPattern;
        @Nullable
        private String myModuleName;

        public Properties() {
        }

        public Properties(@Nullable String symbolPattern, @Nullable String moduleName) {
            this.mySymbolPattern = symbolPattern;
            this.myModuleName = moduleName;
        }

        @Nullable
        public String getSymbolPattern() {
            return this.mySymbolPattern;
        }

        public void setSymbolPattern(@Nullable String symbolPattern) {
            this.mySymbolPattern = symbolPattern;
        }

        @Nullable
        public String getModuleName() {
            return this.myModuleName;
        }

        public void setModuleName(@Nullable String moduleName) {
            this.myModuleName = moduleName;
        }

        @NotNull
        public Properties getState() {
            return this;
        }

        public void loadState(@NotNull Properties state) {
            this.mySymbolPattern = state.mySymbolPattern;
            this.myModuleName = state.myModuleName;
        }
    }
}

