/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.WriteAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrCodePointHandlerBase<T extends XBreakpoint<?>>
extends XBreakpointHandler<T> {
    protected final CidrDebugProcess myProcess;
    private final Map<T, List<LLCodepoint>> myBreakpoints = FactoryMap.create(key -> new ArrayList());
    private final Map<Integer, T> myIdToBreakpoint = new THashMap();

    public CidrCodePointHandlerBase(CidrDebugProcess process2, @NotNull Class<? extends XBreakpointType<T, ?>> type) {
        super(type);
        this.myProcess = process2;
    }

    public void registerBreakpoint(@NotNull T breakpoint) {
        long threadId = this.myProcess.getCurrentThreadId();
        int frameIndex = this.myProcess.getCurrentFrameIndex();
        this.myProcess.postCommand(driver -> this.doRegisterBreakpoint(driver, breakpoint, threadId, frameIndex));
    }

    public void unregisterBreakpoint(@NotNull T breakpoint, boolean temporary) {
        this.myProcess.postCommand(driver -> this.doUnregisterBreakpoint(driver, breakpoint));
    }

    protected void doRegisterBreakpoint(DebuggerDriver driver, T breakpoint, long threadId, int frameIndex) throws ExecutionException {
        Collection<LLCodepoint> added = this.addCodepointsInBackend(driver, breakpoint, threadId, frameIndex);
        if (added.isEmpty()) {
            return;
        }
        this.registerCodepointsMapping(breakpoint, added);
    }

    protected void doUnregisterBreakpoint(@NotNull DebuggerDriver driver, T breakpoint) throws ExecutionException {
        List<Integer> idsToRemove = this.unregisterCodepointsMapping(breakpoint);
        if (idsToRemove.isEmpty()) {
            return;
        }
        try {
            this.removeCodepointsInBackend(driver, idsToRemove, breakpoint);
        }
        catch (DebuggerCommandException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCodepointsMapping(T breakpoint, Collection<LLCodepoint> added) {
        Map<T, List<LLCodepoint>> map2 = this.myBreakpoints;
        synchronized (map2) {
            this.myBreakpoints.get(breakpoint).addAll(added);
            for (LLCodepoint each : added) {
                this.myIdToBreakpoint.put(each.getId(), breakpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> unregisterCodepointsMapping(T breakpoint) {
        List idsToRemove;
        Map<T, List<LLCodepoint>> map2 = this.myBreakpoints;
        synchronized (map2) {
            List<LLCodepoint> removed = this.myBreakpoints.remove(breakpoint);
            if (removed == null) {
                return Collections.emptyList();
            }
            idsToRemove = ContainerUtil.map(removed, LLCodepoint::getId);
            for (Integer each : idsToRemove) {
                this.myIdToBreakpoint.remove(each);
            }
        }
        return Collections.unmodifiableList(idsToRemove);
    }

    protected abstract Collection<LLCodepoint> addCodepointsInBackend(DebuggerDriver var1, T var2, long var3, int var5) throws ExecutionException;

    protected void removeCodepointsInBackend(DebuggerDriver driver, List<Integer> ids, T breakpoint) throws ExecutionException, DebuggerCommandException {
        driver.removeCodepoints(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getCodepoint(int id) {
        Map<T, List<LLCodepoint>> map2 = this.myBreakpoints;
        synchronized (map2) {
            return (T)((XBreakpoint)this.myIdToBreakpoint.get(id));
        }
    }

    @Nullable
    protected String convertCondition(XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        String conversion;
        if (breakpoint.getCondition() != null && (conversion = (String)WriteAction.computeAndWait(() -> {
            try {
                return CidrEvaluatorHelper.getInstance().convertExpression(this.myProcess, breakpoint.getCondition(), breakpoint.getSourcePosition());
            }
            catch (CidrEvaluatorHelper.ConversionException e) {
                if (breakpoint instanceof XLineBreakpoint) {
                    this.myProcess.getSession().setBreakpointInvalid((XLineBreakpoint)breakpoint, e.getMessage());
                }
                return null;
            }
        })) != null) {
            return conversion;
        }
        return breakpoint.getCondition();
    }
}

