/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBTokenType;
import org.jetbrains.annotations.NotNull;

public class LLDBParser
implements PsiParser {
    private static final String[] LLDB_EXPRESSION_COMMANDS = new String[]{"print", "p", "po", "expression", "expr"};
    private static final String[] LLDB_NOUNS = new String[]{"breakpoint", "command", "frame", "log", "memory", "platform", "process", "register", "settings", "source", "target", "thread", "type"};

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder2) {
        PsiBuilder.Marker mark = builder2.mark();
        this.parseLLDBCommand(builder2);
        LLDBParser.eatEverything(builder2);
        mark.done(root);
        return builder2.getTreeBuilt();
    }

    private void parseLLDBCommand(PsiBuilder builder2) {
        PsiBuilder.Marker command = builder2.mark();
        if (builder2.getTokenType() == GDBTokenType.IDENTIFIER) {
            String commandName = builder2.getTokenText();
            PsiBuilder.Marker commandNameMarker = builder2.mark();
            builder2.advanceLexer();
            if (LLDBParser.isNoun(commandName) && !builder2.eof() && builder2.getTokenType() == GDBTokenType.IDENTIFIER) {
                builder2.advanceLexer();
            }
            commandNameMarker.done((IElementType)GDBTokenType.COMMAND_NAME);
            if (!builder2.eof()) {
                LLDBParser.parseCommandArguments(builder2, LLDBParser.isExpressionCommand(commandName));
            }
        } else {
            LLDBParser.eatEverything(builder2);
        }
        command.done((IElementType)GDBTokenType.DBG_COMMAND);
    }

    private static boolean isNoun(String name) {
        return ArrayUtil.contains((String)name, (String[])LLDB_NOUNS);
    }

    private static boolean isExpressionCommand(String commandName) {
        return ArrayUtil.contains((String)commandName, (String[])LLDB_EXPRESSION_COMMANDS);
    }

    private static void parseCommandArguments(PsiBuilder builder2, boolean isExpr) {
        PsiBuilder.Marker body = builder2.mark();
        boolean optionsEaten = LLDBParser.eatEverythingUntilDashDash(builder2);
        if (optionsEaten) {
            body.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
            PsiBuilder.Marker dashDash = builder2.mark();
            builder2.advanceLexer();
            dashDash.done((IElementType)GDBTokenType.COMMAND_ARGS_END);
            body = builder2.mark();
            LLDBParser.eatEverything(builder2);
        }
        body.done((IElementType)(isExpr ? GDBTokenType.EXPRESSION_PLACEHOLDER : GDBTokenType.COMMAND_ARGUMENTS));
    }

    private static boolean eatEverythingUntilDashDash(PsiBuilder builder2) {
        while (!builder2.eof()) {
            if (builder2.getTokenType() == GDBTokenType.DASHDASH && builder2.rawLookup(1) != GDBTokenType.IDENTIFIER) {
                return true;
            }
            builder2.advanceLexer();
        }
        return false;
    }

    private static void eatEverything(PsiBuilder builder2) {
        while (!builder2.eof()) {
            builder2.advanceLexer();
        }
    }
}

