/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.execution.CidrExecUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEvaluationContext;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriverConfiguration
extends DebuggerDriverConfiguration {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+\\.[\\d]+(?:\\.[\\d]+)*).*");
    private static boolean ourIsDebugModeEnabled = false;

    public static void setDebugMode(boolean isEnabled) {
        ourIsDebugModeEnabled = isEnabled;
    }

    public static boolean isDebugModeEnabled() {
        return ourIsDebugModeEnabled;
    }

    @Override
    @NotNull
    public String getDriverName() {
        return "LLDB";
    }

    @NotNull
    public static ArchitectureType getDefaultTargetArchitecture() {
        return ArchitectureType.X86_64;
    }

    @Nullable
    public String readVersion() {
        ToolVersion version = this.readToolVersion();
        return version == null ? null : version.toCompactString();
    }

    @Nullable
    public ToolVersion readToolVersion() {
        String displayVersion;
        try {
            GeneralCommandLine commandLine = this.createLLDBFrontendCommandLine(LLDBDriverConfiguration.getDefaultTargetArchitecture());
            commandLine.addParameter("--version");
            displayVersion = CidrToolsUtil.readOneLineWithProgress(commandLine, 10000);
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.info("Cannot read LLDB version", (Throwable)e);
            return null;
        }
        if (displayVersion == null) {
            return null;
        }
        return LLDBDriverConfiguration.parseVersion(displayVersion);
    }

    @NotNull
    public static ToolVersion parseVersion(@NotNull String displayVersion) {
        return ToolVersion.parse(displayVersion, VERSION_PATTERN);
    }

    @Override
    public boolean isAttachSupported() {
        return true;
    }

    @Override
    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        return new LLDBDriver(handler, this, architectureType);
    }

    @NotNull
    private String getWinBinDir(@NotNull ArchitectureType architectureType) {
        return (architectureType == ArchitectureType.I386 ? "x86" : "x64") + "/bin/";
    }

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architectureType) {
        return this.getBundledLLDBFrameworkFile(architectureType);
    }

    @NotNull
    protected File getLLDBFrontendFile(@NotNull ArchitectureType architectureType) {
        return this.getLLDBBinFile(SystemInfo.isWindows ? this.getWinBinDir(architectureType) + "LLDBFrontend.exe" : (SystemInfo.isMac ? "LLDBFrontend" : "bin/LLDBFrontend"));
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        return CidrDebuggerPathManager.getLLDBBinFile(relativePath, null);
    }

    @NotNull
    protected File getBundledLLDBFrameworkFile(ArchitectureType architectureType) {
        return CidrDebuggerPathManager.getLLDBBinFile(SystemInfo.isWindows ? this.getWinBinDir(architectureType) + "liblldb.dll" : (SystemInfo.isMac ? "LLDB.framework" : "lib/liblldb.so"), SystemInfo.isMac ? "LLDB.framework/Resources" : "bin");
    }

    public static boolean hasBundledLLDB() {
        return new LLDBDriverConfiguration().getBundledLLDBFrameworkFile(LLDBDriverConfiguration.getDefaultTargetArchitecture()).exists();
    }

    @Override
    @Deprecated
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver) throws ExecutionException {
        return this.createDriverCommandLine(driver, LLDBDriverConfiguration.getDefaultTargetArchitecture());
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) throws ExecutionException {
        GeneralCommandLine result2 = this.createLLDBFrontendCommandLine(architectureType);
        result2.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        this.configureDriverCommandLine(result2);
        return result2;
    }

    @NotNull
    private GeneralCommandLine createLLDBFrontendCommandLine(@NotNull ArchitectureType architectureType) throws ExecutionException {
        File lldbFrameworkFile = this.getLLDBFrameworkFile(architectureType);
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File frontendExecutable = this.getLLDBFrontendFile(architectureType);
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result2 = new GeneralCommandLine();
        result2.setExePath(frontendExecutable.getAbsolutePath());
        Map env = result2.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_PRELOAD", lldbFrameworkFile.getAbsolutePath());
        } else if (SystemInfo.isWindows) {
            File lldbFrameworkDir = lldbFrameworkFile.getParentFile();
            CidrExecUtil.appendSearchPath(env, "PATH", lldbFrameworkDir.getPath());
            File lldbFrontendDir = frontendExecutable.getParentFile();
            if (!FileUtil.filesEqual((File)lldbFrontendDir, (File)lldbFrameworkDir)) {
                CidrExecUtil.appendSearchPath(env, "PATH", lldbFrontendDir.getPath());
            }
            String parentPATH = (String)result2.getParentEnvironment().get("PATH");
            CidrExecUtil.appendSearchPath(env, "PATH", parentPATH);
            if (this.useNativePDBPlugin()) {
                env.put("LLDB_USE_NATIVE_PDB_READER", "1");
            }
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            File debugserver = new File(lldbFrameworkFile, "Resources/debugserver");
            if (debugserver.exists()) {
                env.put("LLDB_DEBUGSERVER_PATH", debugserver.getAbsolutePath());
                env.put("LLDB_DEBUGSERVER_EXTRA_ARG_1", "--reverse-connect");
            }
            env.put("NSUnbufferedIO", "YES");
            File pythonDir = CidrDebuggerPathManager.getOSXSystemPythonBinDir();
            if (pythonDir != null) {
                env.put("PATH", result2.getParentEnvironment().get("PATH"));
                CidrExecUtil.appendSearchPath(env, "PATH", pythonDir.getAbsolutePath());
            } else {
                CidrDebuggerLog.LOG.warn("Python bin dir not found");
            }
        }
        if (SystemInfo.isUnix && this.useSTLRenderers()) {
            result2.putUserData(LLDBDriver.ENABLE_STL_RENDERERS, (Object)true);
            env.put("PYTHONPATH", CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().getAbsolutePath());
        }
        if (this.disableASLR()) {
            env.put("LLDB_LAUNCH_FLAG_DISABLE_ASLR", "1");
        }
        LLDBDriverConfiguration.setupCommonParameters(result2);
        return result2;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result2) {
        if (LLDBDriverConfiguration.isDebugModeEnabled()) {
            result2.addParameter("--debug");
        }
    }

    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, long threadId, int frameIndex, @NotNull UserDataHolderEx cacheHolder) {
        return new LLDBEvaluationContext(driver, expirable, threadId, frameIndex, cacheHolder);
    }

    @Override
    public boolean supportsArrayEvaluation() {
        return true;
    }

    @Override
    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return Registry.is((String)"cidr.debugger.lldb.statics");
    }

    public boolean useNativePDBPlugin() {
        return Registry.is((String)"cidr.debugger.lldb.useNativePDBPlugin");
    }

    public boolean disableASLR() {
        return false;
    }

    public boolean useSTLRenderers() {
        return true;
    }

    @Contract(value="null -> null")
    public String convertToProjectModelPath(@Nullable String absolutePath) {
        return absolutePath;
    }
}

