/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLBreakpoint
extends LLCodepoint {
    @NotNull
    private final String myOrigFile;
    private final int myOrigLine;
    @Nullable
    private final String myCondition;
    @Nullable
    private final List<LLBreakpointLocation> myLocations;

    public LLBreakpoint(int id, @NotNull String file2, int line, @Nullable String condition, @Nullable List<LLBreakpointLocation> locations) {
        super(id);
        this.myOrigFile = file2;
        this.myOrigLine = line;
        this.myCondition = condition;
        this.myLocations = locations;
    }

    @NotNull
    public String getOrigFile() {
        return this.myOrigFile;
    }

    public int getOrigLine() {
        return this.myOrigLine;
    }

    @Nullable
    public String getCondition() {
        return this.myCondition;
    }

    public boolean isPending() {
        if (this.myLocations == null) {
            return true;
        }
        for (LLBreakpointLocation loc : this.myLocations) {
            if (!loc.isResolved()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String result2 = "Breakpoint-" + this.getId() + "@" + this.getOrigFile() + ":" + this.getOrigLine();
        if (this.myCondition != null) {
            result2 = result2 + ":condition:" + this.myCondition;
        }
        if (this.myLocations != null) {
            result2 = result2 + ":locations:[";
            result2 = result2 + String.join((CharSequence)",", ContainerUtil.map(this.myLocations, loc -> loc.toString()));
            result2 = result2 + "]";
        }
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LLBreakpoint that = (LLBreakpoint)o;
        if (this.myOrigLine != that.myOrigLine) {
            return false;
        }
        if (!this.myOrigFile.equals(that.myOrigFile)) {
            return false;
        }
        if (!Objects.equals(this.myCondition, that.myCondition)) {
            return false;
        }
        if (this.myLocations != null && that.myLocations != null) {
            if (this.myLocations.size() != that.myLocations.size()) {
                return false;
            }
            for (int i2 = 0; i2 < this.myLocations.size(); ++i2) {
                if (Objects.equals(this.myLocations.get(i2), that.myLocations.get(i2))) continue;
                return false;
            }
        } else if (this.myLocations != that.myLocations) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myOrigFile.hashCode();
        result2 = 31 * result2 + this.myOrigLine;
        result2 = 31 * result2 + (this.myCondition != null ? this.myCondition.hashCode() : 0);
        result2 = 31 * result2;
        if (this.myLocations != null) {
            for (LLBreakpointLocation loc : this.myLocations) {
                result2 += 31 * result2 + loc.hashCode();
            }
        }
        return result2;
    }
}

