/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/ShowInMemoryViewAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "isEnabled", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "nodeName", "", "update", "intellij.cidr.debugger"})
public final class ShowInMemoryViewAction
extends XDebuggerTreeActionBase
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        XValue value = XDebuggerTreeActionBase.getSelectedValue((DataContext)e.getDataContext());
        e.getPresentation().setVisible(value instanceof CidrPhysicalValue);
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node2, @NotNull AnActionEvent e) {
        if (!super.isEnabled(node2, e)) {
            return false;
        }
        XValue xValue = (XValue)node2.getValueContainer();
        if (!(xValue instanceof CidrPhysicalValue)) {
            xValue = null;
        }
        CidrPhysicalValue cidrPhysicalValue = (CidrPhysicalValue)xValue;
        if (cidrPhysicalValue == null) {
            return false;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return false;
        }
        LLValueData data = value.getPreparedVarData();
        return !data.isPointer() || data.isValidPointer();
    }

    protected void perform(@NotNull XValueNodeImpl node2, @NotNull String nodeName, @NotNull AnActionEvent e) {
        XDebugSessionTab sessionTab;
        XValue xValue = (XValue)node2.getValueContainer();
        if (!(xValue instanceof CidrPhysicalValue)) {
            xValue = null;
        }
        CidrPhysicalValue cidrPhysicalValue = (CidrPhysicalValue)xValue;
        if (cidrPhysicalValue == null) {
            return;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return;
        }
        CidrDebugProcess debugProcess = value.getProcess();
        Project project2 = debugProcess.getProject();
        XSourcePosition xSourcePosition = debugProcess.createMemoryPosition(Address.NULL);
        if (xSourcePosition == null) {
            return;
        }
        XSourcePosition someMemoryPosition = xSourcePosition;
        VirtualFile memoryFile = someMemoryPosition.getFile();
        FileEditorProvider fileEditorProvider = (FileEditorProvider)ArraysKt.singleOrNull((Object[])FileEditorProviderManager.getInstance().getProviders(project2, memoryFile));
        if (fileEditorProvider == null) {
            return;
        }
        FileEditorProvider provider2 = fileEditorProvider;
        FileEditor fileEditor = provider2.createEditor(project2, memoryFile);
        debugProcess.setUpMemoryView(fileEditor);
        MemoryViewPanel memoryViewPanel = debugProcess.getMemoryViewPanel();
        GotoAddressPanel gotoAddressPanel = memoryViewPanel.getGotoAddressPanel();
        if (gotoAddressPanel == null) {
            return;
        }
        GotoAddressPanel gotoAddressPanel2 = gotoAddressPanel;
        XDebugSession debugSession = debugProcess.getSession();
        if (debugSession instanceof XDebugSessionImpl && (sessionTab = ((XDebugSessionImpl)debugSession).getSessionTab()) != null) {
            Content memoryViewContent = sessionTab.getUi().findContent("DEBUGGER_MEMORY_VIEW");
            JComponent memoryViewComponent = memoryViewPanel.getPreferredFocusableComponent();
            sessionTab.getUi().selectAndFocus(memoryViewContent, true, true).doWhenDone(new Runnable(memoryViewComponent){
                final /* synthetic */ JComponent $memoryViewComponent;

                public final void run() {
                    this.$memoryViewComponent.requestFocus();
                }
                {
                    this.$memoryViewComponent = jComponent;
                }
            });
        }
        gotoAddressPanel2.navigateToValue(value, true);
    }
}

