/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CidrEvaluator
extends XDebuggerEvaluator {
    public static final Key THROW_ON_EVALUATION = Key.create((String)"THROW_ON_EVALUATION");
    @NotNull
    protected final CidrStackFrame myFrame;

    public CidrEvaluator(@NotNull CidrStackFrame frame) {
        this.myFrame = frame;
    }

    @NotNull
    public CidrEvaluatedValue doEvaluate(@NotNull DebuggerDriver driver, @Nullable XSourcePosition valuePosition, @NotNull XExpression expression) throws ExecutionException, DebuggerCommandException {
        String expr;
        LLValue val;
        ThrowInTest.doThrow((UserDataHolder)this.myFrame.getProcess(), THROW_ON_EVALUATION);
        EvaluationContext context2 = this.createEvaluationContext(driver);
        if (expression.getMode() == EvaluationMode.EXPRESSION) {
            Pair<LLValue, String> pair = CidrEvaluatorHelper.getInstance().convertAndEvaluate(this.myFrame.getProcess(), driver, expression, valuePosition, this.myFrame);
            val = (LLValue)((Object)pair.first);
            expr = (String)pair.second;
        } else {
            val = context2.evaluate(expression.getExpression());
            expr = expression.getExpression();
        }
        return new CidrEvaluatedValue(val, this.myFrame.getProcess(), valuePosition, this.myFrame, expr);
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return this.myFrame.getProcess().driverSupportsCodeFragmentEvaluation();
    }

    protected EvaluationContext createEvaluationContext(DebuggerDriver driver) {
        return this.myFrame.getProcess().createEvaluationContext(driver, null, this.myFrame);
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        this.evaluate((XExpression)XExpressionImpl.fromText((String)expression), callback, expressionPosition);
    }

    public void evaluate(final @NotNull XExpression expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, final @Nullable XSourcePosition expressionPosition) {
        this.myFrame.getProcess().postCommand(new CidrDebugProcess.DebuggerUIUpdateCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                XSourcePosition valuePosition = expressionPosition == null ? CidrEvaluator.this.myFrame.getSourcePosition() : expressionPosition;
                try {
                    CidrEvaluatedValue evaluatedValue = CidrEvaluator.this.doEvaluate(driver, valuePosition, expression);
                    callback.evaluated((XValue)evaluatedValue);
                }
                catch (DebuggerCommandException e) {
                    callback.errorOccurred(e.getMessage());
                }
                catch (ExecutionException e) {
                    callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            }
        });
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(final @NotNull Project project2, final @NotNull Document document2, final int offset, final boolean sideEffectsAllowed) {
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(project2, new TaskInfo(){

            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            public String getTitle() {
                return CidrDebuggerBundle.message("debug.evaluating.expression", new Object[0]);
            }

            @Nls(capitalization=Nls.Capitalization.Title)
            public String getCancelText() {
                return CidrDebuggerBundle.message("debug.evaluating.expression.cancel", new Object[0]);
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            public String getCancelTooltipText() {
                return CidrDebuggerBundle.message("debug.evaluating.expression.cancel.tooltip", new Object[0]);
            }

            public boolean isCancellable() {
                return true;
            }
        }, PerformInBackgroundOption.DEAF){

            protected void showDialog() {
            }
        };
        JobScheduler.getScheduler().schedule(() -> {
            if (!indicator.isCanceled()) {
                indicator.background();
            }
        }, 500L, TimeUnit.MILLISECONDS);
        final AsyncPromise promise = new AsyncPromise();
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(project2, CidrDebuggerBundle.message("debug.evaluating.expression", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                promise.setResult((Object)CidrEvaluator.this.getExpressionInfoAtOffset(project2, document2, offset, sideEffectsAllowed));
            }

            public void onCancel() {
                promise.cancel();
            }
        }, (ProgressIndicator)indicator);
        return promise;
    }

    @NotNull
    public <T> Promise<T> getWhenDataIsReady(@NotNull Editor editor, @NotNull T data) {
        Project project2 = editor.getProject();
        if (project2 == null) {
            return Promises.resolvedPromise(data);
        }
        Document document2 = editor.getDocument();
        return this.getExpressionInfoAtOffsetAsync(project2, document2, document2.getText().length() - 1, true).then(unusedInfo -> data);
    }
}

