/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisDiagnosticsLevel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CidrDebuggerSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final boolean PRESENT_AS_OBJC = PlatformUtils.isAppCode() || PlatformUtils.isRubyMine();
    @NotNull
    private final CidrDebuggerSettings mySetting;
    private JPanel myPanel;
    private JCheckBox myEnableRenderersCheckBox;
    private JCheckBox myEnableCocoaRenderersCheckBox;
    private JCheckBox myEnableCoreDataRenderersCheckBox;
    private JCheckBox myEnableGNUSTLRenderersCheckBox;
    private JBLabel myEnableGNUSTLRenderersDescriptionLabel;
    private JCheckBox myHideValuesOutOfScopeCheckBox;
    private JCheckBox myEnableHexFormatting;
    private JCheckBox myEnableHexAsSecondaryFormatting;
    private JBLabel myEnableHexAsSecondaryFormattingLabel;
    private JCheckBox myEnableLLDBNatvisRenderers;
    private JBLabel myLLDBNatvisCheckBoxDescription;
    private JLabel myLLDBNativsDiagnosticsLevelLabel;
    private JComboBox<LLDBNatvisDiagnosticsLevel> myLLDBNatvisDiagnosticsLevel;

    public CidrDebuggerSettingsConfigurable(@NotNull CidrDebuggerSettings setting) {
        this.mySetting = setting;
        this.$$$setupUI$$$();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CidrDebuggerSettingsConfigurable.this.updateControls();
            }
        };
        this.myEnableRenderersCheckBox.addItemListener(listener);
        this.myEnableCocoaRenderersCheckBox.addItemListener(listener);
        if (PRESENT_AS_OBJC) {
            this.myEnableGNUSTLRenderersCheckBox.setVisible(false);
            this.myEnableGNUSTLRenderersDescriptionLabel.setVisible(false);
        } else {
            this.myEnableRenderersCheckBox.setVisible(false);
            this.myEnableCocoaRenderersCheckBox.setVisible(false);
            this.myEnableCoreDataRenderersCheckBox.setVisible(false);
        }
        this.myEnableHexFormatting.addItemListener(listener);
        if (!Experiments.getInstance().isFeatureEnabled("cidr.debugger.value.numberFormatting.hex")) {
            this.myEnableHexFormatting.setVisible(false);
            this.myEnableHexAsSecondaryFormatting.setVisible(false);
            this.myEnableHexAsSecondaryFormattingLabel.setVisible(false);
        }
        this.myEnableLLDBNatvisRenderers.addItemListener(e -> this.updateLLDBNatvisControls());
        if (!SystemInfoRt.isWindows) {
            this.myEnableLLDBNatvisRenderers.setVisible(false);
            this.myLLDBNativsDiagnosticsLevelLabel.setVisible(false);
            this.myLLDBNatvisDiagnosticsLevel.setVisible(false);
            this.myLLDBNatvisCheckBoxDescription.setVisible(false);
        }
    }

    private void updateControls() {
        boolean allEnabled = this.myEnableRenderersCheckBox.isSelected();
        boolean cocoaEnabled = allEnabled && this.myEnableCocoaRenderersCheckBox.isSelected();
        this.myEnableCocoaRenderersCheckBox.setEnabled(allEnabled);
        this.myEnableCoreDataRenderersCheckBox.setEnabled(cocoaEnabled);
        boolean hexEnabled = this.myEnableHexFormatting.isSelected();
        this.myEnableHexAsSecondaryFormatting.setEnabled(hexEnabled);
    }

    @NotNull
    public String getId() {
        return "Debugger.ObjectiveC";
    }

    @Nls
    public String getDisplayName() {
        return PRESENT_AS_OBJC ? "Objective-C" : "C/C++";
    }

    public String getHelpTopic() {
        return PRESENT_AS_OBJC ? "reference.idesettings.debugger.objectivec" : "reference.idesettings.debugger.cpp";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.mySetting.RENDERERS_ENABLED != this.myEnableRenderersCheckBox.isSelected() || this.mySetting.COCOA_RENDERERS_ENABLED != this.myEnableCocoaRenderersCheckBox.isSelected() || this.mySetting.CORE_DATA_RENDERERS_ENABLED != this.myEnableCoreDataRenderersCheckBox.isSelected() || this.mySetting.STL_RENDERERS_ENABLED != this.myEnableGNUSTLRenderersCheckBox.isSelected() || this.mySetting.VALUES_FILTER_ENABLED != this.myHideValuesOutOfScopeCheckBox.isSelected() || this.mySetting.HEX_FORMATTING_ENABLED != this.myEnableHexFormatting.isSelected() || this.mySetting.HEX_AS_SECONDARY_FORMATTING_ENABLED != this.myEnableHexAsSecondaryFormatting.isSelected() || this.mySetting.LLDB_NATVIS_RENDERERS_ENABLED != this.myEnableLLDBNatvisRenderers.isSelected() || this.mySetting.LLDB_NATVIS_DIAGNOSTICS_LEVEL != this.myLLDBNatvisDiagnosticsLevel.getSelectedItem();
    }

    public void apply() {
        this.mySetting.RENDERERS_ENABLED = this.myEnableRenderersCheckBox.isSelected();
        this.mySetting.COCOA_RENDERERS_ENABLED = this.myEnableCocoaRenderersCheckBox.isSelected();
        this.mySetting.CORE_DATA_RENDERERS_ENABLED = this.myEnableCoreDataRenderersCheckBox.isSelected();
        this.mySetting.STL_RENDERERS_ENABLED = this.myEnableGNUSTLRenderersCheckBox.isSelected();
        this.mySetting.VALUES_FILTER_ENABLED = this.myHideValuesOutOfScopeCheckBox.isSelected();
        this.mySetting.HEX_FORMATTING_ENABLED = this.myEnableHexFormatting.isSelected();
        this.mySetting.HEX_AS_SECONDARY_FORMATTING_ENABLED = this.myEnableHexAsSecondaryFormatting.isSelected();
        this.mySetting.LLDB_NATVIS_RENDERERS_ENABLED = this.myEnableLLDBNatvisRenderers.isSelected();
        this.mySetting.LLDB_NATVIS_DIAGNOSTICS_LEVEL = (LLDBNatvisDiagnosticsLevel)((Object)this.myLLDBNatvisDiagnosticsLevel.getSelectedItem());
    }

    public void reset() {
        this.myEnableRenderersCheckBox.setSelected(this.mySetting.RENDERERS_ENABLED);
        this.myEnableCocoaRenderersCheckBox.setSelected(this.mySetting.COCOA_RENDERERS_ENABLED);
        this.myEnableCoreDataRenderersCheckBox.setSelected(this.mySetting.CORE_DATA_RENDERERS_ENABLED);
        this.myEnableGNUSTLRenderersCheckBox.setSelected(this.mySetting.STL_RENDERERS_ENABLED);
        this.myHideValuesOutOfScopeCheckBox.setSelected(this.mySetting.VALUES_FILTER_ENABLED);
        this.myEnableHexFormatting.setSelected(this.mySetting.HEX_FORMATTING_ENABLED);
        this.myEnableHexAsSecondaryFormatting.setSelected(this.mySetting.HEX_AS_SECONDARY_FORMATTING_ENABLED);
        this.updateControls();
        this.myEnableLLDBNatvisRenderers.setSelected(this.mySetting.LLDB_NATVIS_RENDERERS_ENABLED);
        this.myLLDBNatvisDiagnosticsLevel.setSelectedItem((Object)this.mySetting.LLDB_NATVIS_DIAGNOSTICS_LEVEL);
        this.updateLLDBNatvisControls();
    }

    private void updateLLDBNatvisControls() {
        boolean enabled = this.myEnableLLDBNatvisRenderers.isSelected();
        this.myLLDBNatvisDiagnosticsLevel.setEnabled(enabled);
        this.myLLDBNativsDiagnosticsLevelLabel.setEnabled(enabled);
    }

    private void createUIComponents() {
        this.myLLDBNatvisDiagnosticsLevel = new ComboBox((ComboBoxModel)new EnumComboBoxModel(LLDBNatvisDiagnosticsLevel.class));
        this.myLLDBNatvisDiagnosticsLevel.setEditable(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JBLabel jBLabel;
        JCheckBox jCheckBox2;
        JBLabel jBLabel2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JBLabel jBLabel3;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(13, 1, new Insets(0, 0, 8, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 4, 1, 0, 3, 3, 3, null, null, null));
        this.myEnableRenderersCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableValueRenderers.checkbox"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableCocoaRenderersCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableCocoaRenderers.checkbox"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null, 2));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myEnableCoreDataRenderersCheckBox = jBCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableCoreDataRenderers.checkbox"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 4));
        this.myEnableGNUSTLRenderersCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableGNUSTLRenderers.checkbox"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableGNUSTLRenderersDescriptionLabel = jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableGNUSTLRenderers.checkbox.description"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.variables.separator"));
        jPanel2.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myHideValuesOutOfScopeCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableValuesFilter.checkbox"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableValuesFilter.checkbox.hint"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myEnableHexFormatting = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableHexNumberFormatting.checkbox"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableHexAsSecondaryFormattingLabel = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableHexNumberFormatting.asSecondary.checkbox.hint"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null, 5));
        this.myEnableHexAsSecondaryFormatting = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableHexNumberFormatting.asSecondary.checkbox"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myLLDBNatvisCheckBoxDescription = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableLLDBNatvisRenderers.checkbox.description"));
        jPanel2.add((Component)jBLabel, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(11, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myLLDBNativsDiagnosticsLevelLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableLLDBNatvisRenderers.diagnostics"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null, 2));
        JComboBox<LLDBNatvisDiagnosticsLevel> jComboBox = this.myLLDBNatvisDiagnosticsLevel;
        jPanel3.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myEnableLLDBNatvisRenderers = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrDebuggerSettingsConfigurable.class).getString("debug.settings.enableLLDBNatvisRenderers.checkbox"));
        jCheckBox.setToolTipText("");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

