/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ExecutableFileFormatUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CidrOSProcessUtil {
    private static final Logger LOG = Logger.getInstance(CidrOSProcessUtil.class);

    @NotNull
    public static ArchitectureType getProcessArchitectureType(int pid) {
        if (SystemInfo.isWindows) {
            return CidrOSProcessUtil.getWindowsProcessArchitectureType(pid);
        }
        if (SystemInfo.isLinux) {
            return CidrOSProcessUtil.getLinuxProcessArchitectureType(pid);
        }
        throw new IllegalStateException("getProcessArchitectureType() is not implemented for macOS processes");
    }

    @NotNull
    public static ArchitectureType getLinuxProcessArchitectureType(int pid) {
        if (!SystemInfo.isLinux) {
            throw new IllegalStateException(System.getProperty("os.name") + " is not supported");
        }
        try {
            return ExecutableFileFormatUtil.readElfMachineType("/proc/" + pid + "/exe");
        }
        catch (IOException e) {
            LOG.warn("Couldn't get executable information of process: pid=" + pid, (Throwable)e);
            return ArchitectureType.UNKNOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ArchitectureType getWindowsProcessArchitectureType(int pid) {
        WinNT.HANDLE hProcess = Kernel32.INSTANCE.OpenProcess(4096, false, pid);
        if (hProcess == WinBase.INVALID_HANDLE_VALUE) {
            return ArchitectureType.UNKNOWN;
        }
        IntByReference isWow64Ref = new IntByReference(0);
        try {
            if (!Kernel32.INSTANCE.IsWow64Process(hProcess, isWow64Ref)) {
                ArchitectureType architectureType = ArchitectureType.UNKNOWN;
                return architectureType;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(hProcess);
        }
        boolean isWow64 = isWow64Ref.getValue() == 1;
        return isWow64 ? ArchitectureType.I386 : CidrOSProcessUtil.getWindowsArch();
    }

    @NotNull
    private static ArchitectureType getWindowsArch() {
        WinBase.SYSTEM_INFO systemInfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetNativeSystemInfo(systemInfo);
        int processorArchitecture = systemInfo.processorArchitecture.dwOemID.getLow().intValue();
        if (processorArchitecture == 0) {
            return ArchitectureType.I386;
        }
        if (processorArchitecture == 9) {
            return ArchitectureType.X86_64;
        }
        if (processorArchitecture == 5) {
            return ArchitectureType.ARM;
        }
        if (processorArchitecture == 12) {
            return ArchitectureType.ARM64;
        }
        return ArchitectureType.UNKNOWN;
    }
}

