/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrContextRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends RunConfigurationProducer<CONFIGURATION> {
    private static final Pattern TEMPLATE_ARGS = Pattern.compile("<.*>");
    protected final CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> myBinder;

    protected CidrContextRunConfigurationProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(true);
        this.myBinder = binder;
    }

    @Deprecated
    protected CidrContextRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(configurationType);
        this.myBinder = binder;
    }

    @NotNull
    protected List<TARGET> getTargetsForFile(@Nullable PsiFile containingFile, @NotNull Predicate<TARGET> condition) {
        if (containingFile == null) {
            return Collections.emptyList();
        }
        ArrayList<OCResolveConfiguration> orderedConfigurations = new ArrayList<OCResolveConfiguration>(OCWorkspace.getInstance(containingFile.getProject()).getConfigurations());
        orderedConfigurations.retainAll(OCInclusionContextUtil.getAllBuildConfigurationsForFile(containingFile, null));
        ArrayList<TARGET> targets = new ArrayList<TARGET>(orderedConfigurations.size());
        for (OCResolveConfiguration configuration : orderedConfigurations) {
            TARGET target = this.myBinder.getTargetFromResolveConfiguration(configuration);
            if (target == null || !condition.apply(target)) continue;
            targets.add(target);
        }
        return Collections.unmodifiableList(targets);
    }

    @NotNull
    public List<TARGET> getExecutableTargetsForFile(@Nullable PsiFile containingFile) {
        return this.getTargetsForFile(containingFile, target -> target.isExecutable());
    }

    public void setupTarget(@NotNull CONFIGURATION newConfigurationWithTemplateDefaults, @NotNull List<TARGET> targetsWithContext) {
        this.findBuiltTargetAndConfiguration(newConfigurationWithTemplateDefaults, targetsWithContext, true);
    }

    @Nullable
    protected BuildTargetAndConfigurationData findBuiltTargetAndConfiguration(@NotNull CONFIGURATION configuration, @NotNull List<TARGET> targetsWithContext, boolean adjustConfigurationFromContext) {
        Pair<TARGET, BC> selectedTargetAndConfig;
        if (targetsWithContext.isEmpty()) {
            return null;
        }
        CidrBuildTarget target = null;
        CidrBuildConfigurationHelper<CidrBuildConfiguration, CidrBuildTarget> helper = ((CidrRunConfiguration)configuration).getHelper();
        Project project2 = configuration.getProject();
        BuildTargetAndConfigurationData data = null;
        RunnerAndConfigurationSettings selectedSettings = RunManager.getInstance((Project)project2).getSelectedConfiguration();
        if (selectedSettings != null && this.myBinder.isSupportedRunConfiguration(selectedSettings.getConfiguration())) {
            selectedTargetAndConfig = this.myBinder.getTargetAndConfiguration((CidrRunConfiguration)selectedSettings.getConfiguration());
            data = helper.findSimilarValidInTargets((CidrBuildTarget)selectedTargetAndConfig.first, (CidrBuildConfiguration)selectedTargetAndConfig.second, targetsWithContext);
        }
        if (data == null) {
            selectedTargetAndConfig = this.myBinder.getTargetAndConfiguration(configuration);
            data = helper.findSimilarValidInTargets((CidrBuildTarget)selectedTargetAndConfig.first, (CidrBuildConfiguration)selectedTargetAndConfig.second, targetsWithContext);
        }
        if (data != null && data.target != null) {
            target = (CidrBuildTarget)helper.findTarget(data.target, targetsWithContext);
        }
        if (target == null) {
            data = null;
            target = (CidrBuildTarget)targetsWithContext.get(0);
        }
        assert (target != null);
        BuildTargetData buildTargetData = new BuildTargetData(target);
        if (data == null) {
            Object buildConfiguration = ((CidrRunConfiguration)configuration).getHelper().getDefaultConfiguration(target);
            data = new BuildTargetAndConfigurationData(buildTargetData, buildConfiguration == null ? null : buildConfiguration.getName());
        }
        if (adjustConfigurationFromContext) {
            if (configuration instanceof CidrExecutableDataHolder) {
                ((CidrExecutableDataHolder)configuration).setExecutableData(new ExecutableData(buildTargetData));
            }
            ((CidrRunConfiguration)configuration).setTargetAndConfigurationData(data);
        }
        return data;
    }

    @Nullable
    public static String getCanonicalNameFromSymbol(@NotNull OCSymbolWithQualifiedName namespaceSymbol, @NotNull OCResolveContext context2) {
        OCQualifiedName namespaceQName = namespaceSymbol.getResolvedQualifiedName(context2);
        return namespaceQName == null ? null : CidrContextRunConfigurationProducer.replaceTemplateParamTo(namespaceQName.getFullName(context2), "");
    }

    public static String replaceTemplateParamTo(@NotNull String name, @NotNull String replacement) {
        return TEMPLATE_ARGS.matcher(name).replaceAll(replacement);
    }
}

