/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import org.jetbrains.annotations.NotNull;

public final class BuildTargetData {
    @NotNull
    public final String projectName;
    @NotNull
    public final String targetName;

    public BuildTargetData(@NotNull String projectName, @NotNull String targetName) {
        this.projectName = projectName;
        this.targetName = targetName;
    }

    public BuildTargetData(@NotNull CidrBuildTarget target) {
        this(target.getProjectName(), target.getName());
    }

    public String toString() {
        return this.getDisplayString();
    }

    @NotNull
    public String getDisplayString() {
        return BuildTargetAndConfigurationData.formatDisplayString(this.projectName, this.targetName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildTargetData that = (BuildTargetData)o;
        if (!this.projectName.equals(that.projectName)) {
            return false;
        }
        return this.targetName.equals(that.targetName);
    }

    public int hashCode() {
        int result2 = this.projectName.hashCode();
        result2 = 31 * result2 + this.targetName.hashCode();
        return result2;
    }
}

