/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.doxygen.comment.ComplexItemBuilder;
import com.jetbrains.cidr.doxygen.comment.InfoItemImpl;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.lang.documentation.doxygen.api.InfoItem;
import com.jetbrains.cidr.lang.documentation.doxygen.api.TagItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DoxygenCommentTagImpl
implements TagItem,
ComplexItemBuilder {
    private final String name;
    private final String options;
    private final List<String> params;
    private final List<InfoItem> items = new ArrayList<InfoItem>();

    public DoxygenCommentTagImpl(DxDocTag tag) {
        this.name = tag.getName();
        this.options = tag.getOptions().isEmpty() ? "" : "[" + StringUtil.join(tag.getOptions(), (String)", ") + "]";
        this.params = tag.getParamList().stream().map(p -> p.getName()).collect(Collectors.toList());
    }

    public DoxygenCommentTagImpl(String tagName, String options2, String paramName, String description2) {
        this.name = tagName;
        this.options = options2;
        this.params = Collections.singletonList(paramName);
        this.addText(description2);
    }

    @Override
    public void addText(@NotNull String text) {
        if (text.isEmpty()) {
            return;
        }
        this.items.add(new InfoItemImpl(text));
    }

    @Override
    public void addTag(@NotNull TagItem item) {
        this.items.add(item);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public List<String> getParameters() {
        return this.params;
    }

    @Override
    @NotNull
    public String getDescription() {
        return StringUtil.trimTrailing((String)StringUtil.join(this.items, InfoItem::getDescription, (String)" "));
    }

    @Override
    @NotNull
    public List<InfoItem> getContent() {
        return new ArrayList<InfoItem>(this.items);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoxygenCommentTagImpl tag = (DoxygenCommentTagImpl)o;
        if (this.name != null ? !this.name.equals(tag.name) : tag.name != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(tag.options) : tag.options != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(tag.params) : tag.params != null) {
            return false;
        }
        return !(this.items != null ? !this.items.equals(tag.items) : tag.items != null);
    }

    public int hashCode() {
        int result2 = this.name != null ? this.name.hashCode() : 0;
        result2 = 31 * result2 + (this.options != null ? this.options.hashCode() : 0);
        result2 = 31 * result2 + (this.params != null ? this.params.hashCode() : 0);
        result2 = 31 * result2 + (this.items != null ? this.items.hashCode() : 0);
        return result2;
    }
}

