/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.psi.DxDocComment;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.doxygen.psi.DxParamId;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import com.jetbrains.cidr.doxygen.psi.impl.DxPsiImplUtil;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.psi.OCCallable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxReference
extends PsiReferenceBase<DxParamId>
implements PsiReference {
    public DxReference(@NotNull PsiElement element, @NotNull TextRange textRange) {
        super((PsiElement)((DxParamId)element), textRange);
    }

    @Nullable
    public PsiElement resolve() {
        DxDocTag tag = (DxDocTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, DxDocTag.class);
        DxDocComment comment = (DxDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, DxDocComment.class);
        if (tag != null && comment != null) {
            Optional<Object> result2 = Optional.empty();
            if (tag.getName().equals(DoxygenCmd.PARAM.toString())) {
                result2 = this.resolveParam(comment);
            } else if (tag.getName().equals(DoxygenCmd.TPARAM.toString())) {
                result2 = this.resolveTemplateParam(comment);
            }
            if (result2.isPresent()) {
                return (PsiElement)result2.get();
            }
        }
        return null;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        return DxPsiImplUtil.setName((DxParamId)this.getElement(), newElementName);
    }

    @NotNull
    public TextRange getRangeInElement() {
        return TextRange.create((int)0, (int)((DxParamId)this.myElement).getText().length());
    }

    private Optional<? extends PsiNamedElement> resolveParam(@NotNull DxDocComment comment) {
        PsiComment psiComment = DoxygenUtil.getHostComment(comment);
        OCCallable<?> func = DoxygenUtil.findFunction(psiComment);
        if (func != null && func.getParameters() != null) {
            return func.getParameters().stream().filter(p -> ((DxParamId)this.myElement).getText().equals(p.getName())).findFirst();
        }
        return Optional.empty();
    }

    private Optional<? extends PsiNamedElement> resolveTemplateParam(@NotNull DxDocComment comment) {
        PsiComment psiComment = DoxygenUtil.getHostComment(comment);
        if (psiComment instanceof PsiDocCommentBase) {
            PsiElement owner = ((PsiDocCommentBase)psiComment).getOwner();
            return Optional.ofNullable(DoxygenUtil.traverseTemplateParametersList(owner, (element, name) -> !((DxParamId)this.myElement).getText().equals(name)));
        }
        return Optional.empty();
    }

    public Object @NotNull [] getVariants() {
        ASTNode node2;
        PsiElement prev = ((DxParamId)this.myElement).getPrevSibling();
        if (prev != null && (node2 = prev.getNode()) != null && node2.getElementType() == DxTypes.ELLIPSIS) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        DxDocTag tag = (DxDocTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, DxDocTag.class);
        DxDocComment comment = (DxDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, DxDocComment.class);
        if (tag != null && comment != null) {
            PsiComment hostComment = DoxygenUtil.getHostComment(comment);
            if (tag.getName().equals(DoxygenCmd.PARAM.toString())) {
                return DxReference.getParamVariants(hostComment);
            }
            if (tag.getName().equals(DoxygenCmd.TPARAM.toString())) {
                return DxReference.getTemplateParamVariants(hostComment);
            }
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    private static Object[] getParamVariants(@Nullable PsiComment psiComment) {
        List<PsiNamedElement> params;
        OCCallable<?> func = DoxygenUtil.findFunction(psiComment);
        if (func != null && (params = func.getParameters()) != null) {
            return params.stream().map(p -> "<unnamed>".equals(p.getName()) ? p.getText() : p.getName()).filter(name -> name != null && DxReference.isValidIdentifier(name)).toArray();
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    private static Object[] getTemplateParamVariants(@Nullable PsiComment psiComment) {
        if (psiComment instanceof PsiDocCommentBase) {
            PsiElement owner = ((PsiDocCommentBase)psiComment).getOwner();
            ArrayList params = new ArrayList();
            DoxygenUtil.traverseTemplateParametersList(owner, name -> {
                if (DxReference.isValidIdentifier(name)) {
                    params.add(name);
                }
            });
            return params.toArray();
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    private static boolean isValidIdentifier(@NotNull String name) {
        if (name.isEmpty()) {
            return false;
        }
        return name.startsWith("...") || Character.isJavaIdentifierPart(name.charAt(0));
    }
}

