/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.doxygen.DxLanguage;
import com.jetbrains.cidr.doxygen.lexer.DoxygenLexerAdapter;
import com.jetbrains.cidr.doxygen.parser.DoxygenParser;
import com.jetbrains.cidr.doxygen.psi.DxFile;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import org.jetbrains.annotations.NotNull;

public class DxParserDefinition
implements ParserDefinition {
    public static final TokenSet WHITE_SPACES = TokenSet.WHITE_SPACE;
    public static final TokenSet IDS = TokenSet.create((IElementType[])new IElementType[]{DxTypes.PARAM_ID});
    public static final TokenSet COMMENTS = TokenSet.EMPTY;
    public static final TokenSet STRINGS = TokenSet.create((IElementType[])new IElementType[]{DxTypes.DOC_COMMENT_DATA});
    public static final IFileElementType FILE = new IFileElementType(Language.findInstance(DxLanguage.class));

    @NotNull
    public Lexer createLexer(Project project2) {
        return new DoxygenLexerAdapter();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return STRINGS;
    }

    @NotNull
    public PsiParser createParser(Project project2) {
        return new DoxygenParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new DxFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node2) {
        return DxTypes.Factory.createElement(node2);
    }
}

