/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathTree<Self extends PathTree<Self, T>, T>
implements Cloneable {
    @Nullable
    protected THashSet<T> myItems;
    @Nullable
    protected THashMap<String, Self> myChildren;

    public void addItem(@NotNull String path, @NotNull T item) {
        Self subTree = this.getNotNullSubTree(path);
        ((PathTree)subTree).getItemsForWrite().add(item);
    }

    public void addItems(@NotNull String path, T ... items) {
        Self subTree = this.getNotNullSubTree(path);
        ContainerUtil.addAll(((PathTree)subTree).getItemsForWrite(), (Object[])items);
    }

    public int removeItem(@NotNull String path, @NotNull T ref) {
        THashSet<T> references;
        Self subTree = this.getSubTree(path, SearchStrategy.NULL_IF_NOT_FOUND);
        if (subTree != null && (references = ((PathTree)subTree).myItems) != null) {
            references.remove(ref);
            return references.size();
        }
        return 0;
    }

    @NotNull
    public Set<T> getItems() {
        return this.myItems == null ? Collections.emptySet() : this.myItems;
    }

    @NotNull
    public Collection<Self> getChildren() {
        return this.myChildren == null ? Collections.emptySet() : this.myChildren.values();
    }

    @NotNull
    protected Self getNotNullSubTree(@NotNull String path) {
        return this.getSubTree(path, SearchStrategy.BUILD_IF_NOT_FOUND);
    }

    @Deprecated
    @Nullable
    public Self getSubTree(@NotNull String path, boolean createSubtrees) {
        return this.getSubTree(path, createSubtrees ? SearchStrategy.BUILD_IF_NOT_FOUND : SearchStrategy.NULL_IF_NOT_FOUND);
    }

    @Nullable
    public Self getSubTree(@NotNull String path, @NotNull SearchStrategy strategy2) {
        return this.getSubTree(this.splitPathInComponents(this.toCanonicalPath(path)), strategy2);
    }

    @NotNull
    private List<String> splitPathInComponents(@NotNull String path) {
        return StringUtil.split((String)path, (String)"/", (boolean)true, (boolean)false);
    }

    @NotNull
    private String toCanonicalPath(@NotNull String path) {
        int index = path.indexOf("://");
        if (index < 0) {
            return FileUtil.toCanonicalPath((String)path, (boolean)true);
        }
        int split = index + "://".length();
        return path.substring(0, split) + FileUtil.toCanonicalPath((String)path.substring(split), (boolean)true);
    }

    @Nullable
    private Self getSubTree(@NotNull Iterable<String> pathComps, SearchStrategy strategy2) {
        Self result2 = this.self();
        Iterator<String> iterator2 = pathComps.iterator();
        while (iterator2.hasNext()) {
            Self t = result2;
            String key = iterator2.next();
            Self st = super.getChild(key);
            if (st == null) {
                if (strategy2 == SearchStrategy.BUILD_IF_NOT_FOUND) {
                    st = super.createChild(key);
                } else {
                    if (strategy2 == SearchStrategy.DEEPEST_EXISTING_PREFIX) {
                        return result2;
                    }
                    return null;
                }
            }
            result2 = st;
        }
        return result2;
    }

    @NotNull
    protected Self self() {
        return (Self)this;
    }

    @NotNull
    protected abstract Self createNewTree(@Nullable Self var1);

    @NotNull
    Set<T> getItemsForWrite() {
        if (this.myItems == null) {
            this.myItems = new THashSet();
        }
        return this.myItems;
    }

    @Nullable
    private Self getChild(@NotNull String key) {
        if (this.myChildren == null) {
            return null;
        }
        return (Self)((PathTree)this.myChildren.get((Object)key));
    }

    private Self createChild(@NotNull String name) {
        if (this.myChildren == null) {
            this.myChildren = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
        }
        Self tree = this.createNewTree(this.self());
        this.myChildren.put((Object)name, tree);
        return tree;
    }

    Self clone(@Nullable Self parent) {
        Object clone = this.createNewTree(parent);
        THashSet<T> items = this.myItems;
        ((PathTree)clone).myItems = items != null ? new THashSet(items) : null;
        THashMap<String, Self> children = this.myChildren;
        if (children == null) {
            return clone;
        }
        ((PathTree)clone).myChildren = new THashMap(children.size(), FileUtil.PATH_HASHING_STRATEGY);
        children.forEachEntry((pathSegment, child) -> {
            clone.myChildren.put(pathSegment, (Object)child.clone(clone));
            return true;
        });
        return clone;
    }

    @Nullable
    public static <Self extends PathTree<Self, T>, T> Self merge(@NotNull @NotNull Collection<@NotNull Self> trees, boolean allowReuse) {
        return trees.isEmpty() ? null : PathTree.merge(null, trees, allowReuse);
    }

    @NotNull
    private static <Self extends PathTree<Self, T>, T> Self merge(@Nullable Self parent, @NotNull @NotNull Collection<@NotNull Self> trees, boolean allowReuse) {
        Iterator<@NotNull Self> it = trees.iterator();
        assert (it.hasNext());
        PathTree tree = (PathTree)it.next();
        if (!it.hasNext()) {
            return (Self)(allowReuse ? tree : tree.clone(parent));
        }
        Self mergedTree = tree.createNewTree(parent);
        MultiMap childrenPerKey = new MultiMap(trees.size(), 0.75f);
        TObjectObjectProcedure collector = (key, value) -> {
            childrenPerKey.putValue(key, value);
            return true;
        };
        while (true) {
            THashMap<String, Self> children;
            THashSet<T> items;
            if ((items = tree.myItems) != null) {
                mergedTree.getItemsForWrite().addAll((Collection<T>)items);
            }
            if ((children = tree.myChildren) != null) {
                children.forEachEntry(collector);
            }
            if (!it.hasNext()) break;
            tree = (PathTree)it.next();
        }
        if (childrenPerKey.isEmpty()) {
            return mergedTree;
        }
        mergedTree.myChildren = new THashMap(childrenPerKey.size(), FileUtil.PATH_HASHING_STRATEGY);
        for (Map.Entry entry : childrenPerKey.entrySet()) {
            Self mergedChild = PathTree.merge(mergedTree, (Collection)entry.getValue(), allowReuse);
            mergedTree.myChildren.put(entry.getKey(), mergedChild);
        }
        return mergedTree;
    }

    public static enum SearchStrategy {
        NULL_IF_NOT_FOUND,
        BUILD_IF_NOT_FOUND,
        DEEPEST_EXISTING_PREFIX;

    }
}

